/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mgcp.stack;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.ModifyConnection;
import jain.protocol.ip.mgcp.message.ModifyConnectionResponse;
import jain.protocol.ip.mgcp.message.parms.CallIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionDescriptor;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.NotificationRequestParms;
import jain.protocol.ip.mgcp.message.parms.RequestIdentifier;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.io.IOException;
import java.net.InetAddress;
import java.text.ParseException;
import org.apache.log4j.Logger;
import org.mobicents.mgcp.stack.JainMgcpStackImpl;
import org.mobicents.mgcp.stack.TransactionHandler;
import org.mobicents.mgcp.stack.parser.MgcpContentHandler;
import org.mobicents.mgcp.stack.parser.MgcpMessageParser;
import org.mobicents.mgcp.stack.parser.Utils;

public class ModifyConnectionHandler
extends TransactionHandler {
    private ModifyConnection command = null;
    private ModifyConnectionResponse response = null;
    private Logger logger = Logger.getLogger(ModifyConnectionHandler.class);

    public ModifyConnectionHandler(JainMgcpStackImpl stack) {
        super(stack);
    }

    public ModifyConnectionHandler(JainMgcpStackImpl stack, InetAddress address, int port) {
        super(stack, address, port);
    }

    public JainMgcpCommandEvent decodeCommand(String message) throws ParseException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Decoding modify connection command");
        }
        MgcpMessageParser parser = new MgcpMessageParser(new CommandContentHandle());
        try {
            parser.parse(message);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.command;
    }

    public JainMgcpResponseEvent decodeResponse(String message) throws ParseException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Decoding create connection response command");
        }
        MgcpMessageParser parser = new MgcpMessageParser(new ResponseContentHandle());
        try {
            parser.parse(message);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.response;
    }

    public String encode(JainMgcpCommandEvent event) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Encoding ModifyConnection object into MGCP modify connection command");
        }
        ModifyConnection evt = (ModifyConnection)event;
        String msg = "MDCX " + evt.getTransactionHandle() + " " + evt.getEndpointIdentifier() + " MGCP 1.0\n";
        msg = msg + "C:" + evt.getCallIdentifier() + "\n";
        msg = msg + "I:" + evt.getConnectionIdentifier() + "\n";
        if (evt.getBearerInformation() != null) {
            msg = msg + "B:e:" + evt.getBearerInformation() + "\n";
        }
        if (evt.getLocalConnectionOptions() != null) {
            msg = msg + Utils.encodeLocalConnectionOptions(evt.getLocalConnectionOptions());
        }
        if (evt.getMode() != null) {
            msg = msg + "M:" + evt.getMode() + "\n";
        }
        if (evt.getNotificationRequestParms() != null) {
            msg = msg + Utils.encodeNotificationRequestParms(evt.getNotificationRequestParms());
        }
        if (evt.getNotifiedEntity() != null) {
            msg = msg + "N:" + evt.getNotifiedEntity() + "\n";
        }
        if (evt.getRemoteConnectionDescriptor() != null) {
            msg = msg + "\n" + evt.getRemoteConnectionDescriptor();
        }
        return msg;
    }

    public String encode(JainMgcpResponseEvent event) {
        ModifyConnectionResponse response = (ModifyConnectionResponse)event;
        ReturnCode returnCode = response.getReturnCode();
        String msg = returnCode.getValue() + " " + response.getTransactionHandle() + " " + returnCode.getComment() + "\n";
        if (response.getLocalConnectionDescriptor() != null) {
            msg = msg + "\n" + response.getLocalConnectionDescriptor();
        }
        return msg;
    }

    public JainMgcpResponseEvent getProvisionalResponse() {
        ModifyConnectionResponse provisionalresponse = null;
        if (!this.sent) {
            provisionalresponse = new ModifyConnectionResponse(this.commandEvent.getSource(), ReturnCode.Transaction_Being_Executed);
        }
        return provisionalresponse;
    }

    private class ResponseContentHandle
    implements MgcpContentHandler {
        public void header(String header) throws ParseException {
            String[] tokens = header.split("\\s");
            int tid = Integer.parseInt(tokens[1]);
            ModifyConnectionHandler.this.response = new ModifyConnectionResponse((Object)ModifyConnectionHandler.this.stack, Utils.decodeReturnCode(Integer.parseInt(tokens[0])));
            ModifyConnectionHandler.this.response.setTransactionHandle(tid);
        }

        public void param(String name, String value) throws ParseException {
        }

        public void sessionDescription(String sd) throws ParseException {
            ModifyConnectionHandler.this.response.setLocalConnectionDescriptor(new ConnectionDescriptor(sd));
        }
    }

    private class CommandContentHandle
    implements MgcpContentHandler {
        public void header(String header) throws ParseException {
            String[] tokens = header.split("\\s");
            String verb = tokens[0].trim();
            String transactionID = tokens[1].trim();
            String version = tokens[3].trim() + " " + tokens[4].trim();
            int tid = Integer.parseInt(transactionID);
            EndpointIdentifier endpoint = Utils.decodeEndpointIdentifier(tokens[2].trim());
            ModifyConnectionHandler.this.command = new ModifyConnection(ModifyConnectionHandler.this.getObjectSource(tid), new CallIdentifier("00"), endpoint, new ConnectionIdentifier("00"));
            ModifyConnectionHandler.this.command.setTransactionHandle(tid);
        }

        public void param(String name, String value) throws ParseException {
            if (name.equalsIgnoreCase("B")) {
                ModifyConnectionHandler.this.command.setBearerInformation(Utils.createBearerInformation(value));
            } else if (name.equalsIgnoreCase("c")) {
                ModifyConnectionHandler.this.command.setCallIdentifier(new CallIdentifier(value));
            } else if (name.equalsIgnoreCase("I")) {
                ModifyConnectionHandler.this.command.setConnectionIdentifier(new ConnectionIdentifier(value));
            } else if (name.equalsIgnoreCase("m")) {
                ModifyConnectionHandler.this.command.setMode(Utils.createConnectionMode(value));
            } else if (name.equalsIgnoreCase("L")) {
                ModifyConnectionHandler.this.command.setLocalConnectionOptions(Utils.createLocalOptions(value));
            } else if (name.equalsIgnoreCase("N")) {
                ModifyConnectionHandler.this.command.setNotifiedEntity(Utils.decodeNotifiedEntity(value));
            } else if (name.equalsIgnoreCase("X")) {
                ModifyConnectionHandler.this.command.setNotificationRequestParms(new NotificationRequestParms(new RequestIdentifier(value)));
            } else if (name.equalsIgnoreCase("R")) {
                ModifyConnectionHandler.this.command.getNotificationRequestParms().setRequestedEvents(Utils.decodeRequestedEvents(value));
            } else if (name.equalsIgnoreCase("S")) {
                ModifyConnectionHandler.this.command.getNotificationRequestParms().setSignalRequests(Utils.decodeEventNames(value));
            } else if (name.equalsIgnoreCase("T")) {
                ModifyConnectionHandler.this.command.getNotificationRequestParms().setDetectEvents(Utils.decodeEventNames(value));
            }
        }

        public void sessionDescription(String sd) throws ParseException {
            ModifyConnectionHandler.this.command.setRemoteConnectionDescriptor(new ConnectionDescriptor(sd));
        }
    }
}

