/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mgcp.stack;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.Notify;
import jain.protocol.ip.mgcp.message.parms.NotifiedEntity;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.mobicents.mgcp.stack.JainMgcpStackImpl;
import org.mobicents.mgcp.stack.ReceivedTransactionID;

public abstract class TransactionHandler
implements Runnable {
    private static int GENERATOR = 1;
    public static final int LONGTRAN_TIMER_TIMEOUT = 5000;
    private boolean sent;
    private int remoteTID;
    private int localTID;
    protected JainMgcpStackImpl stack;
    private InetAddress remoteAddress;
    private int remotePort;
    protected JainMgcpCommandEvent commandEvent;
    protected JainMgcpResponseEvent responseEvent;
    private Logger logger = Logger.getLogger(TransactionHandler.class);
    private static Timer timer = new Timer();
    private LongtranTimerTask longtranTimerTask;
    private boolean isCommand = false;
    private ReTransmissionTimerTask reTransmissionTimer;
    private THISTTimerTask tHISTTimerTask;
    private int A = 0;
    private int D = 2;
    private int N = 2;
    private DatagramPacket sendComandDatagram = null;
    private int countOfCommandRetransmitted = 0;

    public TransactionHandler(JainMgcpStackImpl stack) {
        this.stack = stack;
        this.localTID = GENERATOR++;
        stack.transactions.put(this.localTID, this);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("New mgcp transaction with id localID=" + this.localTID));
        }
    }

    private void processTxTimeout() {
        try {
            this.release();
            if (this.sent) {
                this.stack.provider.processTxTimeout(this.commandEvent);
            } else {
                this.stack.provider.processRxTimeout(this.commandEvent);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Failed to release mgcp transaction localID=" + this.localTID), (Throwable)e);
        }
    }

    private static boolean isProvisional(ReturnCode rc) {
        int rval = rc.getValue();
        return 99 < rval && rval < 200;
    }

    public TransactionHandler(JainMgcpStackImpl stack, InetAddress remoteAddress, int port) {
        this(stack);
        this.remoteAddress = remoteAddress;
        this.remotePort = port;
    }

    protected void release() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Released transaction (local id=" + this.localTID + "), stop timer"));
        }
        this.stack.transactions.remove(this.localTID);
        this.cancelTHISTTimerTask();
        this.cancelLongtranTimer();
        this.cancelReTransmissionTimer();
    }

    public int getRemoteTID() {
        return this.remoteTID;
    }

    public int getLocalTID() {
        return this.localTID;
    }

    protected abstract String encode(JainMgcpCommandEvent var1);

    protected abstract String encode(JainMgcpResponseEvent var1);

    protected abstract JainMgcpCommandEvent decodeCommand(String var1) throws ParseException;

    protected abstract JainMgcpResponseEvent decodeResponse(String var1) throws ParseException;

    public void run() {
        if (this.isCommand) {
            this.send(this.getCommandEvent());
        } else {
            this.send(this.getResponseEvent());
        }
    }

    private void send(JainMgcpCommandEvent event) {
        this.sent = true;
        String host = null;
        int port = 0;
        switch (event.getObjectIdentifier()) {
            case 108: {
                Notify notifyCommand = (Notify)event;
                NotifiedEntity notifiedEntity = notifyCommand.getNotifiedEntity();
                port = notifiedEntity.getPortNumber();
                host = notifiedEntity.getLocalName();
                break;
            }
            default: {
                String domainName = event.getEndpointIdentifier().getDomainName();
                int pos = domainName.indexOf(58);
                if (pos > 0) {
                    port = Integer.parseInt(domainName.substring(pos + 1));
                    host = domainName.substring(0, pos);
                    break;
                }
                port = 2427;
                host = domainName;
            }
        }
        InetAddress address = null;
        try {
            address = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Unknown endpoint " + host);
        }
        this.remoteTID = event.getTransactionHandle();
        event.setTransactionHandle(this.localTID);
        String msg = this.encode(event);
        byte[] data = msg.getBytes();
        this.sendComandDatagram = new DatagramPacket(data, data.length, address, port);
        this.resetReTransmissionTimer();
        this.resetTHISTTimerTask(false);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Send command event to " + address + ", message\n" + msg));
        }
        ++this.countOfCommandRetransmitted;
        this.stack.send(this.sendComandDatagram);
    }

    private void send(JainMgcpResponseEvent event) {
        this.cancelLongtranTimer();
        if (this.remoteAddress == null) {
            throw new IllegalArgumentException("Unknown orinator address");
        }
        event.setTransactionHandle(this.remoteTID);
        String msg = this.encode(event);
        byte[] data = msg.getBytes();
        DatagramPacket packet = new DatagramPacket(data, data.length, this.remoteAddress, this.remotePort);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("LocalID=" + this.localTID + ", Send response event to " + this.remoteAddress + ":" + this.remotePort + ", message\n" + msg));
        }
        this.stack.send(packet);
        if (TransactionHandler.isProvisional(event.getReturnCode())) {
            this.resetLongtranTimer();
        } else {
            this.release();
            this.stack.responseTx.put(event.getTransactionHandle(), this);
            this.resetTHISTTimerTask(true);
        }
    }

    public void receiveCommand(String message) {
        JainMgcpCommandEvent event = null;
        try {
            event = this.decodeCommand(message);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Event decoded: " + event));
            }
        }
        catch (ParseException e) {
            this.logger.error((Object)"Coud not parse message: ", (Throwable)e);
            return;
        }
        this.sent = false;
        this.commandEvent = event;
        this.remoteTID = event.getTransactionHandle();
        event.setTransactionHandle(this.localTID);
        this.resetLongtranTimer();
        this.stack.provider.processMgcpCommandEvent(event);
    }

    public void receiveResponse(String message) {
        this.cancelReTransmissionTimer();
        this.cancelLongtranTimer();
        JainMgcpResponseEvent event = null;
        try {
            event = this.decodeResponse(message);
        }
        catch (Exception e) {
            this.logger.error((Object)"Could not decode message: ", (Throwable)e);
        }
        event.setTransactionHandle(this.remoteTID);
        this.stack.provider.processMgcpResponseEvent(event, (JainMgcpEvent)this.commandEvent);
        if (TransactionHandler.isProvisional(event.getReturnCode())) {
            this.resetLongtranTimer();
        } else {
            this.release();
        }
    }

    private void cancelLongtranTimer() {
        if (this.longtranTimerTask != null) {
            this.longtranTimerTask.cancel();
            this.longtranTimerTask = null;
        }
    }

    private void resetLongtranTimer() {
        this.longtranTimerTask = new LongtranTimerTask();
        timer.schedule((TimerTask)this.longtranTimerTask, 5000L);
    }

    private void cancelReTransmissionTimer() {
        if (this.reTransmissionTimer != null) {
            this.reTransmissionTimer.cancel();
            this.reTransmissionTimer = null;
        }
    }

    private void resetReTransmissionTimer() {
        this.cancelReTransmissionTimer();
        this.reTransmissionTimer = new ReTransmissionTimerTask();
        timer.schedule((TimerTask)this.reTransmissionTimer, this.calculateReTransmissionTimeout());
    }

    private int calculateReTransmissionTimeout() {
        int reTransmissionTimeoutSec = this.A + this.N * this.D;
        this.N *= 2;
        return reTransmissionTimeoutSec * 1000;
    }

    private void cancelTHISTTimerTask() {
        if (this.tHISTTimerTask != null) {
            this.tHISTTimerTask.cancel();
            this.tHISTTimerTask = null;
        }
    }

    private void resetTHISTTimerTask(boolean responseSent) {
        this.cancelTHISTTimerTask();
        this.tHISTTimerTask = new THISTTimerTask(responseSent);
        timer.schedule((TimerTask)this.tHISTTimerTask, 30000L);
    }

    protected Object getObjectSource(int tid) {
        if (this.sent) {
            return this.stack;
        }
        return new ReceivedTransactionID(tid, this.remoteAddress.toString(), this.remotePort);
    }

    public boolean isCommand() {
        return this.isCommand;
    }

    public void setCommand(boolean isCommand) {
        this.isCommand = isCommand;
    }

    private JainMgcpCommandEvent getCommandEvent() {
        return this.commandEvent;
    }

    public void setCommandEvent(JainMgcpCommandEvent commandEvent) {
        this.commandEvent = commandEvent;
    }

    private JainMgcpResponseEvent getResponseEvent() {
        return this.responseEvent;
    }

    public void setResponseEvent(JainMgcpResponseEvent responseEvent) {
        this.responseEvent = responseEvent;
    }

    private class THISTTimerTask
    extends TimerTask {
        boolean responseSent = false;

        THISTTimerTask(boolean responseSent) {
            this.responseSent = responseSent;
        }

        public void run() {
            if (!this.responseSent) {
                if (TransactionHandler.this.logger.isDebugEnabled()) {
                    TransactionHandler.this.logger.debug((Object)"T-HIST timeout processTxTimeout ");
                }
                try {
                    TransactionHandler.this.processTxTimeout();
                }
                catch (Exception e) {
                    TransactionHandler.this.logger.error((Object)"Failed to delete the jainMgcpResponseEvent for txId", (Throwable)e);
                }
            } else {
                Integer key = new Integer(TransactionHandler.this.remoteTID);
                TransactionHandler obj = TransactionHandler.this.stack.responseTx.remove(key);
                if (TransactionHandler.this.logger.isDebugEnabled()) {
                    TransactionHandler.this.logger.debug((Object)("T-HIST timeout deleting Response for Tx = " + TransactionHandler.this.remoteTID + " Response = " + obj));
                }
                Object var2_3 = null;
            }
        }
    }

    private class ReTransmissionTimerTask
    extends TimerTask {
        private ReTransmissionTimerTask() {
        }

        public void run() {
            try {
                TransactionHandler.this.countOfCommandRetransmitted++;
                if (TransactionHandler.this.logger.isDebugEnabled()) {
                    TransactionHandler.this.logger.debug((Object)("Tx ID = " + TransactionHandler.this.localTID + " Sending the Command " + TransactionHandler.this.countOfCommandRetransmitted));
                }
                TransactionHandler.this.stack.send(TransactionHandler.this.sendComandDatagram);
                TransactionHandler.this.resetReTransmissionTimer();
            }
            catch (Exception e) {
                TransactionHandler.this.logger.error((Object)("Failed to release mgcp transaction localID=" + TransactionHandler.this.localTID), (Throwable)e);
            }
        }
    }

    private class LongtranTimerTask
    extends TimerTask {
        private LongtranTimerTask() {
        }

        public void run() {
            if (TransactionHandler.this.logger.isDebugEnabled()) {
                TransactionHandler.this.logger.debug((Object)("Transaction localID=" + TransactionHandler.this.localTID + " timeout"));
                TransactionHandler.this.processTxTimeout();
            }
        }
    }
}

