/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mgcp.stack;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.mobicents.mgcp.stack.JainMgcpStackImpl;
import org.mobicents.mgcp.stack.ReceivedTransactionID;

public abstract class TransactionHandler {
    private static int GENERATOR = 1;
    public static final int TIMEOUT = 5000;
    private boolean sent;
    private int remoteTID;
    private int localTID;
    protected JainMgcpStackImpl stack;
    private InetAddress remoteAddress;
    private int remotePort;
    protected JainMgcpCommandEvent commandEvent;
    private Logger logger = Logger.getLogger(TransactionHandler.class);
    private static Timer timer = new Timer();
    private TransactionTimerTask timerTask;

    private static boolean isProvisional(ReturnCode rc) {
        int rval = rc.getValue();
        return 99 < rval && rval < 200;
    }

    public TransactionHandler(JainMgcpStackImpl stack) {
        this.stack = stack;
        this.localTID = GENERATOR++;
        stack.transactions.put(this.localTID, this);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("New mgcp transaction with id localID=" + this.localTID));
        }
    }

    public TransactionHandler(JainMgcpStackImpl stack, InetAddress remoteAddress, int port) {
        this(stack);
        this.remoteAddress = remoteAddress;
        this.remotePort = port;
    }

    protected void release() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Released transaction (local id=" + this.localTID + "), stop timer"));
        }
        this.stack.transactions.remove(this.localTID);
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
    }

    public int getRemoteTID() {
        return this.remoteTID;
    }

    public int getLocalTID() {
        return this.localTID;
    }

    protected abstract String encode(JainMgcpCommandEvent var1);

    protected abstract String encode(JainMgcpResponseEvent var1);

    protected abstract JainMgcpCommandEvent decodeCommand(String var1) throws ParseException;

    protected abstract JainMgcpResponseEvent decodeResponse(String var1) throws ParseException;

    public void send(JainMgcpCommandEvent event) {
        this.sent = true;
        this.commandEvent = event;
        String domainName = event.getEndpointIdentifier().getDomainName();
        String host = null;
        int port = 0;
        int pos = domainName.indexOf(58);
        if (pos > 0) {
            port = Integer.parseInt(domainName.substring(pos + 1));
            host = domainName.substring(0, pos);
        } else {
            port = 2427;
            host = domainName;
        }
        InetAddress address = null;
        try {
            address = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Unknown endpoint " + host);
        }
        this.remoteTID = event.getTransactionHandle();
        event.setTransactionHandle(this.localTID);
        String msg = this.encode(event);
        byte[] data = msg.getBytes();
        DatagramPacket packet = new DatagramPacket(data, data.length, address, port);
        this.resetTimer();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Send command event to " + address + ", message\n" + msg));
        }
        this.stack.send(packet);
    }

    public void send(JainMgcpResponseEvent event) {
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        if (this.remoteAddress == null) {
            throw new IllegalArgumentException("Unknown orinator address");
        }
        event.setTransactionHandle(this.remoteTID);
        String msg = this.encode(event);
        byte[] data = msg.getBytes();
        DatagramPacket packet = new DatagramPacket(data, data.length, this.remoteAddress, this.remotePort);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("LocalID=" + this.localTID + ", Send response event to " + this.remoteAddress + ":" + this.remotePort + ", message\n" + msg));
        }
        this.stack.send(packet);
        if (TransactionHandler.isProvisional(event.getReturnCode())) {
            this.resetTimer();
        } else {
            this.release();
        }
    }

    public void receiveCommand(String message) {
        JainMgcpCommandEvent event = null;
        try {
            event = this.decodeCommand(message);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Event decoded: " + event));
            }
        }
        catch (ParseException e) {
            this.logger.error((Object)"Coud not parse message: ", (Throwable)e);
            return;
        }
        this.sent = false;
        this.commandEvent = event;
        this.remoteTID = event.getTransactionHandle();
        event.setTransactionHandle(this.localTID);
        this.resetTimer();
        this.stack.provider.processMgcpCommandEvent(event);
    }

    public void receiveResponse(String message) {
        JainMgcpResponseEvent event = null;
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        try {
            event = this.decodeResponse(message);
        }
        catch (Exception e) {
            this.logger.error((Object)"Could not decode message: ", (Throwable)e);
        }
        event.setTransactionHandle(this.remoteTID);
        this.stack.provider.processMgcpResponseEvent(event, (JainMgcpEvent)this.commandEvent);
        if (TransactionHandler.isProvisional(event.getReturnCode())) {
            this.resetTimer();
        } else {
            this.release();
        }
    }

    private void resetTimer() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
        this.timerTask = new TransactionTimerTask();
        timer.schedule((TimerTask)this.timerTask, 5000L);
    }

    protected Object getObjectSource(int tid) {
        if (this.sent) {
            return this.stack;
        }
        return new ReceivedTransactionID(tid, this.remoteAddress.toString(), this.remotePort);
    }

    private class TransactionTimerTask
    extends TimerTask {
        private TransactionTimerTask() {
        }

        public void run() {
            if (TransactionHandler.this.logger.isDebugEnabled()) {
                TransactionHandler.this.logger.debug((Object)("Transaction localID=" + TransactionHandler.this.localTID + " timeout"));
            }
            try {
                if (TransactionHandler.this.sent) {
                    TransactionHandler.this.stack.provider.processTxTimeout(TransactionHandler.this.commandEvent);
                } else {
                    TransactionHandler.this.stack.provider.processRxTimeout(TransactionHandler.this.commandEvent);
                }
                TransactionHandler.this.release();
            }
            catch (Exception e) {
                TransactionHandler.this.logger.error((Object)("Failed to release mgcp transaction localID=" + TransactionHandler.this.localTID), (Throwable)e);
            }
        }
    }
}

