/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mgcp.stack;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.CreateConnection;
import jain.protocol.ip.mgcp.message.CreateConnectionResponse;
import jain.protocol.ip.mgcp.message.parms.CallIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConflictingParameterException;
import jain.protocol.ip.mgcp.message.parms.ConnectionDescriptor;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionMode;
import jain.protocol.ip.mgcp.message.parms.DigitMap;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.NotificationRequestParms;
import jain.protocol.ip.mgcp.message.parms.NotifiedEntity;
import jain.protocol.ip.mgcp.message.parms.RequestIdentifier;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.io.IOException;
import java.net.InetAddress;
import java.text.ParseException;
import org.apache.log4j.Logger;
import org.mobicents.mgcp.stack.JainMgcpStackImpl;
import org.mobicents.mgcp.stack.TransactionHandler;
import org.mobicents.mgcp.stack.parser.MgcpContentHandler;
import org.mobicents.mgcp.stack.parser.MgcpMessageParser;
import org.mobicents.mgcp.stack.parser.Utils;

public class CreateConnectionHandler
extends TransactionHandler {
    private CreateConnection command;
    private CreateConnectionResponse response;
    private Logger logger = Logger.getLogger(CreateConnectionHandler.class);

    public CreateConnectionHandler(JainMgcpStackImpl stack) {
        super(stack);
    }

    public CreateConnectionHandler(JainMgcpStackImpl stack, InetAddress address, int port) {
        super(stack, address, port);
    }

    protected JainMgcpCommandEvent decodeCommand(String message) throws ParseException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Decoding create connection command");
        }
        MgcpMessageParser parser = new MgcpMessageParser(new CommandContentHandle());
        try {
            parser.parse(message);
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage(), -1);
        }
        return this.command;
    }

    protected JainMgcpResponseEvent decodeResponse(String message) throws ParseException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Decoding create connection response command");
        }
        MgcpMessageParser parser = new MgcpMessageParser(new ResponseContentHandle());
        try {
            parser.parse(message);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.response;
    }

    protected String encode(JainMgcpCommandEvent event) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Encoding CreateConnection object into MGCP create connection command");
        }
        CreateConnection evt = (CreateConnection)event;
        String msg = "CRCX " + evt.getTransactionHandle() + " " + evt.getEndpointIdentifier() + " MGCP 1.0\n";
        msg = msg + "C:" + evt.getCallIdentifier() + "\n";
        msg = msg + "M:" + evt.getMode() + "\n";
        if (evt.getBearerInformation() != null) {
            msg = msg + "B:e:" + evt.getBearerInformation() + "\n";
        }
        if (evt.getNotifiedEntity() != null) {
            msg = msg + "N:" + evt.getNotifiedEntity() + "\n";
        }
        if (evt.getLocalConnectionOptions() != null) {
            msg = msg + Utils.encodeLocalConnectionOptions(evt.getLocalConnectionOptions());
        }
        if (evt.getSecondEndpointIdentifier() != null) {
            msg = msg + "Z2:" + evt.getSecondEndpointIdentifier() + "\n";
        }
        if (evt.getNotificationRequestParms() != null) {
            msg = msg + Utils.encodeNotificationRequestParms(evt.getNotificationRequestParms());
        }
        if (evt.getRemoteConnectionDescriptor() != null) {
            msg = msg + "\n" + evt.getRemoteConnectionDescriptor();
        }
        return msg;
    }

    protected String encode(JainMgcpResponseEvent event) {
        CreateConnectionResponse response = (CreateConnectionResponse)event;
        ReturnCode returnCode = response.getReturnCode();
        String msg = returnCode.getValue() + " " + response.getTransactionHandle() + " " + returnCode.getComment() + "\n";
        if (response.getConnectionIdentifier() != null) {
            msg = msg + "I:" + response.getConnectionIdentifier() + "\n";
        }
        if (response.getSpecificEndpointIdentifier() != null) {
            msg = msg + "Z:" + response.getSpecificEndpointIdentifier() + "\n";
        }
        if (response.getSecondConnectionIdentifier() != null) {
            msg = msg + "I2:" + response.getSecondConnectionIdentifier() + "\n";
        }
        if (response.getSecondEndpointIdentifier() != null) {
            msg = msg + "Z2:" + response.getSecondEndpointIdentifier() + "\n";
        }
        if (response.getLocalConnectionDescriptor() != null) {
            msg = msg + "\n" + response.getLocalConnectionDescriptor();
        }
        return msg;
    }

    private class ResponseContentHandle
    implements MgcpContentHandler {
        public void header(String header) throws ParseException {
            String[] tokens = header.split("\\s");
            int tid = Integer.parseInt(tokens[1]);
            CreateConnectionHandler.this.response = new CreateConnectionResponse((Object)CreateConnectionHandler.this.stack, Utils.decodeReturnCode(Integer.parseInt(tokens[0])), new ConnectionIdentifier("00"));
            CreateConnectionHandler.this.response.setTransactionHandle(tid);
        }

        public void param(String name, String value) throws ParseException {
            if (name.equalsIgnoreCase("I")) {
                CreateConnectionHandler.this.response.setConnectionIdentifier(new ConnectionIdentifier(value));
            } else if (name.equalsIgnoreCase("I2")) {
                CreateConnectionHandler.this.response.setSecondConnectionIdentifier(new ConnectionIdentifier(value));
            } else if (name.equalsIgnoreCase("Z")) {
                CreateConnectionHandler.this.response.setSpecificEndpointIdentifier(Utils.createEndpointIdentifier(value));
            } else if (name.equalsIgnoreCase("Z2")) {
                CreateConnectionHandler.this.response.setSecondEndpointIdentifier(Utils.createEndpointIdentifier(value));
            }
        }

        public void sessionDescription(String sd) throws ParseException {
            CreateConnectionHandler.this.response.setLocalConnectionDescriptor(new ConnectionDescriptor(sd));
        }
    }

    private class CommandContentHandle
    implements MgcpContentHandler {
        public void header(String header) throws ParseException {
            String[] tokens = header.split("\\s");
            String verb = tokens[0].trim();
            String transactionID = tokens[1].trim();
            String version = tokens[3].trim() + " " + tokens[4].trim();
            int tid = Integer.parseInt(transactionID);
            EndpointIdentifier endpoint = Utils.decodeEndpointIdentifier(tokens[2].trim());
            CreateConnectionHandler.this.command = new CreateConnection(CreateConnectionHandler.this.getObjectSource(tid), new CallIdentifier("0"), endpoint, ConnectionMode.Inactive);
            CreateConnectionHandler.this.command.setTransactionHandle(tid);
        }

        public void param(String name, String value) throws ParseException {
            if (name.equalsIgnoreCase("B")) {
                CreateConnectionHandler.this.command.setBearerInformation(Utils.createBearerInformation(value));
            } else if (name.equalsIgnoreCase("c")) {
                CreateConnectionHandler.this.command.setCallIdentifier(new CallIdentifier(value));
            }
            if (name.equalsIgnoreCase("L")) {
                CreateConnectionHandler.this.command.setLocalConnectionOptions(Utils.createLocalOptions(value));
            } else if (name.equalsIgnoreCase("m")) {
                CreateConnectionHandler.this.command.setMode(Utils.createConnectionMode(value));
            } else if (name.equalsIgnoreCase("N")) {
                CreateConnectionHandler.this.command.setNotifiedEntity(new NotifiedEntity(value));
            } else if (name.equalsIgnoreCase("X")) {
                CreateConnectionHandler.this.command.setNotificationRequestParms(new NotificationRequestParms(new RequestIdentifier(value)));
            } else if (name.equalsIgnoreCase("D")) {
                CreateConnectionHandler.this.command.getNotificationRequestParms().setDigitMap(new DigitMap(value));
            } else if (name.equalsIgnoreCase("R")) {
                CreateConnectionHandler.this.command.getNotificationRequestParms().setRequestedEvents(Utils.decodeRequestedEvents(value));
            } else if (name.equalsIgnoreCase("S")) {
                CreateConnectionHandler.this.command.getNotificationRequestParms().setSignalRequests(Utils.decodeEventNames(value));
            } else if (name.equalsIgnoreCase("T")) {
                CreateConnectionHandler.this.command.getNotificationRequestParms().setDetectEvents(Utils.decodeEventNames(value));
            } else if (name.equalsIgnoreCase("Z")) {
                try {
                    CreateConnectionHandler.this.command.setSecondEndpointIdentifier(Utils.createEndpointIdentifier(value));
                }
                catch (ConflictingParameterException conflictingParameterException) {
                    // empty catch block
                }
            }
        }

        public void sessionDescription(String sd) throws ParseException {
            try {
                CreateConnectionHandler.this.command.setRemoteConnectionDescriptor(new ConnectionDescriptor(sd));
            }
            catch (Exception e) {
                CreateConnectionHandler.this.logger.error((Object)"Unexpected error in session descriptor", (Throwable)e);
            }
        }
    }
}

