/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.diameter.impl.ha.data;

import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Configuration;
import org.jdiameter.api.BaseSession;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.client.api.IContainer;
import org.jdiameter.common.api.data.ISessionDatasource;
import org.jdiameter.common.impl.app.AppSessionImpl;
import org.jdiameter.common.impl.data.LocalDataSource;
import org.mobicents.cache.MobicentsCache;
import org.mobicents.cluster.DefaultMobicentsCluster;
import org.mobicents.cluster.MobicentsCluster;
import org.mobicents.cluster.election.ClusterElector;
import org.mobicents.cluster.election.DefaultClusterElector;
import org.mobicents.diameter.impl.ha.data.SessionClusteredData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicatedDataSource
implements ISessionDatasource {
    private static final Logger logger = LoggerFactory.getLogger(ReplicatedDataSource.class);
    public static final String CLUSTER_DS_DEFAULT_FILE = "config/jdiameter-jbc.xml";
    private IContainer container;
    private ISessionDatasource localDataSource;
    private DefaultMobicentsCluster mobicentsCluster;
    private boolean localMode;
    static final String SESSION = "session";
    static final String _SESSIONS = "/diameter/appsessions";
    static final Fqn SESSIONS = Fqn.fromString((String)"/diameter/appsessions");

    public ReplicatedDataSource(IContainer container) {
        this(container, (ISessionDatasource)new LocalDataSource(), CLUSTER_DS_DEFAULT_FILE);
    }

    public ReplicatedDataSource(IContainer container, ISessionDatasource localDataSource, String cacheConffileName) {
        this.localDataSource = localDataSource;
        DefaultCacheFactory factory = new DefaultCacheFactory();
        Cache cache = factory.createCache(cacheConffileName, false);
        cache.start();
        MobicentsCache mcCache = new MobicentsCache(cache, "MC_JDiameter");
        this.mobicentsCluster = new DefaultMobicentsCluster(mcCache, null, (ClusterElector)new DefaultClusterElector());
        this.container = container;
    }

    public void addSession(BaseSession session) {
        SessionClusteredData scd = new SessionClusteredData(session.getSessionId(), (MobicentsCluster)this.mobicentsCluster);
        if (session.isReplicable()) {
            if (scd.exists()) {
                logger.warn("Session with id {} already present in clustered data.", (Object)session.getSessionId());
            } else {
                logger.debug("addSession({}) -\"{}\" in Replicated DataSource", new Object[]{session.getSessionId(), session});
                scd.create();
                scd.setSession(session);
            }
            this.localDataSource.removeSession(session.getSessionId());
        } else if (scd.exists()) {
            logger.debug("addSession({}) in Local DataSource, skipping, since replicable DS has this session.", (Object)session.getSessionId());
        } else {
            logger.debug("addSession({}) in Local DataSource", (Object)session.getSessionId());
            this.localDataSource.addSession(session);
        }
    }

    public BaseSession getSession(String sessionId) {
        BaseSession session = this.localDataSource.getSession(sessionId);
        if (session == null) {
            SessionClusteredData scd = new SessionClusteredData(sessionId, (MobicentsCluster)this.mobicentsCluster);
            if (!scd.exists()) {
                logger.debug("getSession({}) in Replicated DataSource not found, returning null.", (Object)sessionId);
                return null;
            }
            logger.debug("getSession({}) in Replicated DataSource", (Object)sessionId);
            session = scd.getSession();
            logger.debug("getSession({}) in Replicated DataSource retrieved {}", (Object)sessionId, (Object)session);
            if (session != null && session.isAppSession()) {
                AppSessionImpl appSession = (AppSessionImpl)session;
                appSession.relink(this.container);
            }
        }
        return session;
    }

    public NetworkReqListener getSessionListener(String sessionId) {
        logger.debug("getSessionListener({}) in Local DataSource", (Object)sessionId);
        NetworkReqListener lst = this.localDataSource.getSessionListener(sessionId);
        if (lst == null) {
            logger.debug("getSessionListener({}) in Replicated DataSource", (Object)sessionId);
            SessionClusteredData scd = new SessionClusteredData(sessionId, (MobicentsCluster)this.mobicentsCluster);
            if (!scd.exists()) {
                logger.debug("getSessionListener({}) in Replicated DataSource not found. Returning null.", (Object)sessionId);
                return null;
            }
            lst = scd.getSessionListener();
            logger.debug("getSessionListener({}) in Replicated DataSource retrieved {}", (Object)sessionId, (Object)lst);
            if (lst != null && lst instanceof AppSessionImpl) {
                AppSessionImpl as = (AppSessionImpl)lst;
                as.relink(this.container);
            }
        }
        return lst;
    }

    public void removeSession(String sessionId) {
        logger.debug("removeSession({}) in Local DataSource", (Object)sessionId);
        this.localDataSource.removeSession(sessionId);
        SessionClusteredData scd = new SessionClusteredData(sessionId, (MobicentsCluster)this.mobicentsCluster);
        if (scd.exists()) {
            logger.debug("removeSession({}) in Replicated DataSource", (Object)sessionId);
            boolean removed = scd.remove();
            logger.debug("removeSession({}) in Replicated DataSource result: {}", (Object)sessionId, (Object)String.valueOf(removed));
        } else {
            logger.debug("removeSession({}) in Replicated DataSource. Not found.", (Object)sessionId);
        }
    }

    public NetworkReqListener removeSessionListener(String sessionId) {
        logger.debug("removeSessionListener({}) in Local DataSource", (Object)sessionId);
        NetworkReqListener lst = this.localDataSource.removeSessionListener(sessionId);
        if (lst == null) {
            SessionClusteredData scd = new SessionClusteredData(sessionId, (MobicentsCluster)this.mobicentsCluster);
            if (scd.exists()) {
                logger.debug("removeSessionListener({}) in Replicated DataSource", (Object)sessionId);
                lst = scd.getSessionListener();
                scd.setSessionListener(null);
            } else {
                logger.debug("removeSessionListener({}) in Replicated DataSource. Not found.", (Object)sessionId);
            }
        }
        return lst;
    }

    public void setSessionListener(String sessionId, NetworkReqListener data) {
        if (this.localDataSource.getSession(sessionId) != null) {
            logger.debug("setSessionListener({}, {}) in Local DataSource", (Object)sessionId, (Object)data);
            this.localDataSource.setSessionListener(sessionId, data);
        } else {
            logger.debug("setSessionListener({}, {}) in Replicated DataSource", (Object)sessionId, (Object)data);
            SessionClusteredData scd = new SessionClusteredData(sessionId, (MobicentsCluster)this.mobicentsCluster);
            if (scd.exists()) {
                scd.setSessionListener(data);
            } else {
                logger.warn("setSessionListener({}, {}) in Replicated DataSource. Session not found.", (Object)sessionId, (Object)data);
            }
        }
    }

    public void updateSession(BaseSession session) {
        SessionClusteredData scd = new SessionClusteredData(session.getSessionId(), (MobicentsCluster)this.mobicentsCluster);
        if (scd.exists()) {
            logger.debug("Update called on existing session: {}, Session: {}", new Object[]{session.getSessionId(), session});
            scd.setSession(session);
        } else {
            logger.warn("Update called on non existing session: {}", (Object)session.getSessionId());
        }
    }

    public void start() {
        this.getJBossCache().start();
        if (this.getJBossCache().getConfiguration().getCacheMode() == Configuration.CacheMode.LOCAL) {
            this.localMode = true;
        }
    }

    public void stop() {
        this.getJBossCache().stop();
    }

    public boolean isClustered() {
        return !this.localMode;
    }

    public Cache getJBossCache() {
        return this.mobicentsCluster.getMobicentsCache().getJBossCache();
    }

    public void dataRemoved(Fqn sessionFqn) {
        String sessionId = (String)sessionFqn.getLastElement();
        this.localDataSource.removeSession(sessionId);
    }

    public Fqn getBaseFqn() {
        return SESSIONS;
    }
}

