/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap.asn;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.tcap.asn.DialogPortion;
import org.mobicents.protocols.ss7.tcap.asn.EncodeException;
import org.mobicents.protocols.ss7.tcap.asn.ParseException;
import org.mobicents.protocols.ss7.tcap.asn.TcapFactory;
import org.mobicents.protocols.ss7.tcap.asn.comp.Component;
import org.mobicents.protocols.ss7.tcap.asn.comp.PAbortCauseType;
import org.mobicents.protocols.ss7.tcap.asn.comp.TCUniMessage;

public class TCUniMessageImpl
implements TCUniMessage {
    private DialogPortion dp;
    private Component[] component;

    public Component[] getComponent() {
        return this.component;
    }

    public DialogPortion getDialogPortion() {
        return this.dp;
    }

    public void setComponent(Component[] c) {
        this.component = c;
    }

    public void setDialogPortion(DialogPortion dp) {
        this.dp = dp;
    }

    public void decode(AsnInputStream ais) throws ParseException {
        try {
            int tag;
            AsnInputStream localAis = ais.readSequenceStream();
            block7: while (true) {
                if (localAis.available() == 0) {
                    return;
                }
                tag = localAis.readTag();
                if (localAis.isTagPrimitive() || localAis.getTagClass() != 1) {
                    throw new ParseException(PAbortCauseType.IncorrectTxPortion, null, "Error decoding TC-Uni: DialogPortion and Component portion must be constructive and has tag class CLASS_APPLICATION");
                }
                switch (tag) {
                    case 11: {
                        this.dp = TcapFactory.createDialogPortion(localAis);
                        continue block7;
                    }
                    case 12: {
                        Component c;
                        AsnInputStream compAis = localAis.readSequenceStream();
                        ArrayList<Component> cps = new ArrayList<Component>();
                        while (compAis.available() > 0 && (c = TcapFactory.createComponent(compAis)) != null) {
                            cps.add(c);
                        }
                        this.component = new Component[cps.size()];
                        this.component = cps.toArray(this.component);
                        continue block7;
                    }
                }
                break;
            }
            throw new ParseException(PAbortCauseType.IncorrectTxPortion, null, "Error decoding TC-Uni: DialogPortion and Componebt parsing: bad tag - " + tag);
        }
        catch (IOException e) {
            throw new ParseException(PAbortCauseType.BadlyFormattedTxPortion, null, "IOException while decoding TC-Uni: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new ParseException(PAbortCauseType.BadlyFormattedTxPortion, null, "AsnException while decoding TC-Uni: " + e.getMessage(), (Throwable)e);
        }
    }

    public void encode(AsnOutputStream aos) throws EncodeException {
        if (this.component == null || this.component.length == 0) {
            throw new EncodeException("Error encoding TC-Uni: Component portion is mandatory but not defined");
        }
        try {
            aos.writeTag(1, false, 1);
            int pos = aos.StartContentDefiniteLength();
            if (this.dp != null) {
                this.dp.encode(aos);
            }
            aos.writeTag(1, false, 12);
            int pos2 = aos.StartContentDefiniteLength();
            for (Component c : this.component) {
                c.encode(aos);
            }
            aos.FinalizeContent(pos2);
            aos.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new EncodeException("AsnException while encoding TC-Uni: " + e.getMessage(), (Throwable)e);
        }
    }
}

