/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap.asn;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.tcap.asn.EncodeException;
import org.mobicents.protocols.ss7.tcap.asn.ParseException;
import org.mobicents.protocols.ss7.tcap.asn.TcapFactory;
import org.mobicents.protocols.ss7.tcap.asn.comp.ComponentType;
import org.mobicents.protocols.ss7.tcap.asn.comp.GeneralProblemType;
import org.mobicents.protocols.ss7.tcap.asn.comp.OperationCode;
import org.mobicents.protocols.ss7.tcap.asn.comp.Parameter;
import org.mobicents.protocols.ss7.tcap.asn.comp.ReturnResultLast;

public class ReturnResultLastImpl
implements ReturnResultLast {
    private Long invokeId;
    private OperationCode operationCode;
    private Parameter parameter;

    public Long getInvokeId() {
        return this.invokeId;
    }

    public OperationCode getOperationCode() {
        return this.operationCode;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public void setInvokeId(Long i) {
        if (i == null || i < -128L || i > 127L) {
            throw new IllegalArgumentException("Invoke ID our of range: <-128,127>: " + i);
        }
        this.invokeId = i;
    }

    public void setOperationCode(OperationCode oc) {
        this.operationCode = oc;
    }

    public void setParameter(Parameter p) {
        this.parameter = p;
    }

    public ComponentType getType() {
        return ComponentType.ReturnResultLast;
    }

    public String toString() {
        return "ReturnResultLast[invokeId=" + this.invokeId + ", operationCode=" + this.operationCode + ", parameter=" + this.parameter + "]";
    }

    public void decode(AsnInputStream ais) throws ParseException {
        try {
            AsnInputStream localAis = ais.readSequenceStream();
            int tag = localAis.readTag();
            if (tag != 2 || localAis.getTagClass() != 0) {
                throw new ParseException(null, GeneralProblemType.MistypedComponent, "Error while decoding ReturnResultLast: bad tag or tag class for InvokeID: tag=" + tag + ", tagClass = " + localAis.getTagClass());
            }
            this.invokeId = localAis.readInteger();
            if (localAis.available() <= 0) {
                return;
            }
            tag = localAis.readTag();
            if (tag != 16 || localAis.getTagClass() != 0) {
                throw new ParseException(null, GeneralProblemType.MistypedComponent, "Error while decoding ReturnResultLast: bad tag or tag class for sequence: tag=" + tag + ", tagClass = " + localAis.getTagClass());
            }
            AsnInputStream sequenceStream = localAis.readSequenceStream();
            tag = sequenceStream.readTag();
            if (tag != 6 && tag != 2 || localAis.getTagClass() != 0) {
                throw new ParseException(null, GeneralProblemType.MistypedComponent, "Error while decoding ReturnResultLast: bad tag or tag class for operationCode: tag=" + tag + ", tagClass = " + localAis.getTagClass());
            }
            this.operationCode = TcapFactory.createOperationCode(tag, sequenceStream);
            tag = sequenceStream.readTag();
            this.parameter = TcapFactory.createParameter(tag, sequenceStream, true);
        }
        catch (IOException e) {
            throw new ParseException(null, GeneralProblemType.BadlyStructuredComponent, "IOException while decoding ReturnResultLast: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new ParseException(null, GeneralProblemType.BadlyStructuredComponent, "AsnException while decoding ReturnResultLast: " + e.getMessage(), (Throwable)e);
        }
        catch (ParseException e) {
            e.setInvokeId(this.invokeId);
            throw e;
        }
    }

    public void encode(AsnOutputStream aos) throws EncodeException {
        if (this.invokeId == null) {
            throw new EncodeException("No Invoke ID set.");
        }
        try {
            aos.writeTag(2, false, 2);
            int pos = aos.StartContentDefiniteLength();
            aos.writeInteger(this.invokeId.longValue());
            if (this.operationCode != null && this.parameter != null) {
                aos.writeTag(0, false, 16);
                int pos2 = aos.StartContentDefiniteLength();
                this.operationCode.encode(aos);
                this.parameter.encode(aos);
                aos.FinalizeContent(pos2);
            }
            aos.FinalizeContent(pos);
        }
        catch (IOException e) {
            throw new EncodeException("IOException while encoding ReturnResultLast: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new EncodeException("AsnException while encoding ReturnResultLast: " + e.getMessage(), (Throwable)e);
        }
    }
}

