/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap.asn;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.tcap.asn.DialogServiceProviderType;
import org.mobicents.protocols.ss7.tcap.asn.DialogServiceUserType;
import org.mobicents.protocols.ss7.tcap.asn.EncodeException;
import org.mobicents.protocols.ss7.tcap.asn.ParseException;
import org.mobicents.protocols.ss7.tcap.asn.ResultSourceDiagnostic;
import org.mobicents.protocols.ss7.tcap.asn.comp.PAbortCauseType;

public class ResultSourceDiagnosticImpl
implements ResultSourceDiagnostic {
    private DialogServiceProviderType providerType;
    private DialogServiceUserType userType;

    public DialogServiceProviderType getDialogServiceProviderType() {
        return this.providerType;
    }

    public DialogServiceUserType getDialogServiceUserType() {
        return this.userType;
    }

    public void setDialogServiceProviderType(DialogServiceProviderType t) {
        this.providerType = t;
        this.userType = null;
    }

    public void setDialogServiceUserType(DialogServiceUserType t) {
        this.userType = t;
        this.providerType = null;
    }

    public String toString() {
        return "ResultSourceDiagnostic[providerType=" + this.providerType + ", userType=" + this.userType + "]";
    }

    public void decode(AsnInputStream ais) throws ParseException {
        try {
            AsnInputStream localAis = ais.readSequenceStream();
            int tag = localAis.readTag();
            if (localAis.getTagClass() != 2) {
                throw new ParseException(PAbortCauseType.IncorrectTxPortion, null, "Error while decoding AARE-apdu.result-dource-diagnostic sequence part: bad tag class: tagClass=" + localAis.getTagClass());
            }
            switch (tag) {
                case 1: {
                    AsnInputStream localAis2 = localAis.readSequenceStream();
                    tag = localAis2.readTag();
                    if (tag != 2 || localAis2.getTagClass() != 0) {
                        throw new ParseException(PAbortCauseType.IncorrectTxPortion, null, "Error while decoding AARE-apdu.result-dource-diagnostic integer part: bad tag or tag class class: tagClass=" + localAis.getTagClass() + ", tag=" + tag);
                    }
                    long t = localAis2.readInteger();
                    this.userType = DialogServiceUserType.getFromInt((long)t);
                    break;
                }
                case 2: {
                    AsnInputStream localAis2 = localAis.readSequenceStream();
                    tag = localAis2.readTag();
                    if (tag != 2 || localAis2.getTagClass() != 0) {
                        throw new ParseException(PAbortCauseType.IncorrectTxPortion, null, "Error while decoding AARE-apdu.result-dource-diagnostic integer part: bad tag or tag class class: tagClass=" + localAis.getTagClass() + ", tag=" + tag);
                    }
                    long t = localAis2.readInteger();
                    this.providerType = DialogServiceProviderType.getFromInt((long)t);
                    break;
                }
                default: {
                    throw new ParseException(PAbortCauseType.IncorrectTxPortion, null, "Error while decoding AARE-apdu.result-dource-diagnostic sequence part: bad tag: tag=" + tag);
                }
            }
        }
        catch (IOException e) {
            throw new ParseException(PAbortCauseType.BadlyFormattedTxPortion, null, "IOException while decoding ResultSourceDiagnostic: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new ParseException(PAbortCauseType.BadlyFormattedTxPortion, null, "AsnException while decoding ResultSourceDiagnostic: " + e.getMessage(), (Throwable)e);
        }
    }

    public void encode(AsnOutputStream aos) throws EncodeException {
        if (this.userType == null && this.providerType == null) {
            throw new EncodeException("Error encoding ResultSourceDiagnostic: Value not set");
        }
        try {
            aos.writeTag(2, false, 3);
            int pos = aos.StartContentDefiniteLength();
            if (this.userType != null) {
                aos.writeTag(2, false, 1);
                int pos2 = aos.StartContentDefiniteLength();
                aos.writeInteger(this.userType.getType());
                aos.FinalizeContent(pos2);
            } else {
                aos.writeTag(2, false, 2);
                int pos2 = aos.StartContentDefiniteLength();
                aos.writeInteger(this.providerType.getType());
                aos.FinalizeContent(pos2);
            }
            aos.FinalizeContent(pos);
        }
        catch (IOException e) {
            throw new EncodeException("IOException while encoding ResultSourceDiagnostic: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new EncodeException("AsnException while encoding ResultSourceDiagnostic: " + e.getMessage(), (Throwable)e);
        }
    }
}

