/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap.asn;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.tcap.asn.EncodeException;
import org.mobicents.protocols.ss7.tcap.asn.ParseException;
import org.mobicents.protocols.ss7.tcap.asn.TcapFactory;
import org.mobicents.protocols.ss7.tcap.asn.comp.ComponentType;
import org.mobicents.protocols.ss7.tcap.asn.comp.GeneralProblemType;
import org.mobicents.protocols.ss7.tcap.asn.comp.Problem;
import org.mobicents.protocols.ss7.tcap.asn.comp.ProblemType;
import org.mobicents.protocols.ss7.tcap.asn.comp.Reject;

public class RejectImpl
implements Reject {
    private Long invokeId;
    private boolean localOriginated = false;
    private Problem problem;

    public Long getInvokeId() {
        return this.invokeId;
    }

    public Problem getProblem() {
        return this.problem;
    }

    public void setInvokeId(Long i) {
        if (i != null && (i < -128L || i > 127L)) {
            throw new IllegalArgumentException("Invoke ID our of range: <-128,127>: " + i);
        }
        this.invokeId = i;
    }

    public void setProblem(Problem p) {
        this.problem = p;
    }

    public ComponentType getType() {
        return ComponentType.Reject;
    }

    public boolean isLocalOriginated() {
        return this.localOriginated;
    }

    public void setLocalOriginated(boolean p) {
        this.localOriginated = p;
    }

    public String toString() {
        return "Reject[invokeId=" + this.invokeId + (this.isLocalOriginated() ? ", localOriginated" : ", remoteOriginated") + ", problem=" + this.problem + "]";
    }

    public void decode(AsnInputStream ais) throws ParseException {
        try {
            this.setLocalOriginated(false);
            AsnInputStream localAis = ais.readSequenceStream();
            int tag = localAis.readTag();
            if (localAis.getTagClass() != 0) {
                throw new ParseException(null, GeneralProblemType.MistypedComponent, "Error while decoding Reject: bad tag class for InvokeID or NULL: tagClass = " + localAis.getTagClass());
            }
            switch (tag) {
                case 2: {
                    this.invokeId = localAis.readInteger();
                    break;
                }
                case 5: {
                    localAis.readNull();
                }
            }
            tag = localAis.readTag();
            if (localAis.getTagClass() != 2) {
                throw new ParseException(null, GeneralProblemType.MistypedComponent, "Error while decoding Reject: bad tag class for a problem: tagClass = " + localAis.getTagClass());
            }
            ProblemType pt = ProblemType.getFromInt((long)tag);
            if (pt == null) {
                throw new ParseException(null, GeneralProblemType.MistypedComponent, "Error while decoding Reject: ProblemType not found");
            }
            this.problem = TcapFactory.createProblem(pt, localAis);
        }
        catch (IOException e) {
            throw new ParseException(null, GeneralProblemType.BadlyStructuredComponent, "IOException while decoding Reject: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new ParseException(null, GeneralProblemType.BadlyStructuredComponent, "AsnException while decoding Reject: " + e.getMessage(), (Throwable)e);
        }
    }

    public void encode(AsnOutputStream aos) throws EncodeException {
        if (this.problem == null) {
            throw new EncodeException("Problem not set!");
        }
        try {
            aos.writeTag(2, false, 4);
            int pos = aos.StartContentDefiniteLength();
            if (this.invokeId == null) {
                aos.writeNull();
            } else {
                aos.writeInteger(this.invokeId.longValue());
            }
            this.problem.encode(aos);
            aos.FinalizeContent(pos);
        }
        catch (IOException e) {
            throw new EncodeException("IOException while encoding Reject: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new EncodeException("AsnException while encoding Reject: " + e.getMessage(), (Throwable)e);
        }
    }
}

