/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap.asn;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.asn.BitSetStrictLength;
import org.mobicents.protocols.ss7.tcap.asn.EncodeException;
import org.mobicents.protocols.ss7.tcap.asn.ParseException;
import org.mobicents.protocols.ss7.tcap.asn.ProtocolVersion;
import org.mobicents.protocols.ss7.tcap.asn.comp.PAbortCauseType;

public class ProtocolVersionImpl
implements ProtocolVersion {
    private boolean supportedVersion = true;

    public boolean isSupportedVersion() {
        return this.supportedVersion;
    }

    public void decode(AsnInputStream ais) throws ParseException {
        try {
            BitSetStrictLength readV = ais.readBitString();
            if (readV.getStrictLength() < 1 || !readV.get(0)) {
                this.supportedVersion = false;
            }
        }
        catch (IOException e) {
            throw new ParseException(PAbortCauseType.BadlyFormattedTxPortion, null, "IOException while decoding ProtocolVersion: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new ParseException(PAbortCauseType.BadlyFormattedTxPortion, null, "AsnException while decoding ProtocolVersion: " + e.getMessage(), (Throwable)e);
        }
    }

    public void encode(AsnOutputStream aos) throws EncodeException {
        aos.write(128);
        aos.write(2);
        aos.write(7);
        aos.write(128);
    }
}

