/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap.asn;

import java.io.IOException;
import java.util.Arrays;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.asn.BitSetStrictLength;
import org.mobicents.protocols.asn.External;
import org.mobicents.protocols.ss7.tcap.asn.DialogAPDU;
import org.mobicents.protocols.ss7.tcap.asn.DialogPortion;
import org.mobicents.protocols.ss7.tcap.asn.EncodeException;
import org.mobicents.protocols.ss7.tcap.asn.ParseException;
import org.mobicents.protocols.ss7.tcap.asn.TcapFactory;
import org.mobicents.protocols.ss7.tcap.asn.comp.PAbortCauseType;

public class DialogPortionImpl
implements DialogPortion {
    private static final long[] _DIALG_UNI = new long[]{0L, 0L, 17L, 773L, 1L, 2L, 1L};
    private static final long[] _DIALG_STRUCTURED = new long[]{0L, 0L, 17L, 773L, 1L, 1L, 1L};
    private DialogAPDU dialogAPDU;
    private boolean uniDirectional;
    private External ext = new External();

    public DialogPortionImpl() {
        this.setOid(true);
        this.setAsn(true);
    }

    public boolean isUnidirectional() {
        return this.uniDirectional;
    }

    public void setUnidirectional(boolean flag) {
        if (flag) {
            this.ext.setOidValue(_DIALG_UNI);
        } else {
            this.ext.setOidValue(_DIALG_STRUCTURED);
        }
        this.uniDirectional = flag;
    }

    public DialogAPDU getDialogAPDU() {
        return this.dialogAPDU;
    }

    public void setDialogAPDU(DialogAPDU dialogAPDU) {
        this.dialogAPDU = dialogAPDU;
    }

    public String toString() {
        return "DialogPortion[dialogAPDU=" + this.dialogAPDU + ", uniDirectional=" + this.uniDirectional + "]";
    }

    public void encode(AsnOutputStream aos) throws EncodeException {
        try {
            aos.writeTag(1, false, 11);
            int pos = aos.StartContentDefiniteLength();
            if (this.dialogAPDU == null) {
                throw new EncodeException("No APDU in DialogPortion is defined when encoding DialogPortion");
            }
            if (this.getOidValue() == null) {
                throw new EncodeException("No setUnidirectional() for DialogPortion is defined when encoding DialogPortion");
            }
            AsnOutputStream aos2 = new AsnOutputStream();
            this.dialogAPDU.encode(aos2);
            this.ext.setEncodeType(aos2.toByteArray());
            this.ext.encode(aos);
            aos.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new EncodeException("AsnException when encoding DialogPortion: " + e.getMessage(), (Throwable)e);
        }
    }

    public void decode(AsnInputStream aisA) throws ParseException {
        try {
            AsnInputStream ais = aisA.readSequenceStream();
            int tag = ais.readTag();
            if (tag != 8) {
                throw new ParseException(PAbortCauseType.IncorrectTxPortion, null, "Error decoding DialogPortion: wrong value of tag, expected EXTERNAL, found: " + tag);
            }
            this.ext.decode(ais);
            if (!this.isAsn() || !this.isOid()) {
                throw new ParseException(PAbortCauseType.IncorrectTxPortion, null, "Error decoding DialogPortion: Oid and Asd parts not found");
            }
            if (Arrays.equals(_DIALG_UNI, this.getOidValue())) {
                this.uniDirectional = true;
            } else if (Arrays.equals(_DIALG_STRUCTURED, this.getOidValue())) {
                this.uniDirectional = false;
            } else {
                throw new ParseException(PAbortCauseType.IncorrectTxPortion, null, "Error decoding DialogPortion: bad Oid value");
            }
            AsnInputStream loaclAsnIS = new AsnInputStream(this.ext.getEncodeType());
            tag = loaclAsnIS.readTag();
            this.dialogAPDU = TcapFactory.createDialogAPDU(loaclAsnIS, tag, this.isUnidirectional());
        }
        catch (IOException e) {
            throw new ParseException(PAbortCauseType.BadlyFormattedTxPortion, null, "IOException when decoding DialogPortion: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new ParseException(PAbortCauseType.BadlyFormattedTxPortion, null, "AsnException when decoding DialogPortion: " + e.getMessage(), (Throwable)e);
        }
    }

    public byte[] getEncodeType() throws AsnException {
        return this.ext.getEncodeType();
    }

    public void setEncodeType(byte[] data) {
        this.ext.setEncodeType(data);
    }

    public BitSetStrictLength getEncodeBitStringType() throws AsnException {
        return this.ext.getEncodeBitStringType();
    }

    public void setEncodeBitStringType(BitSetStrictLength data) {
        this.ext.setEncodeBitStringType(data);
    }

    public boolean isOid() {
        return this.ext.isOid();
    }

    public void setOid(boolean oid) {
        this.ext.setOid(oid);
    }

    public boolean isInteger() {
        return this.ext.isInteger();
    }

    public void setInteger(boolean integer) {
        this.ext.setInteger(integer);
    }

    public boolean isObjDescriptor() {
        return this.ext.isObjDescriptor();
    }

    public void setObjDescriptor(boolean objDescriptor) {
        this.ext.setObjDescriptor(objDescriptor);
    }

    public long[] getOidValue() {
        return this.ext.getOidValue();
    }

    public void setOidValue(long[] oidValue) {
        this.ext.setOidValue(oidValue);
    }

    public long getIndirectReference() {
        return this.ext.getIndirectReference();
    }

    public void setIndirectReference(long indirectReference) {
        this.ext.setIndirectReference(indirectReference);
    }

    public boolean isAsn() {
        return this.ext.isAsn();
    }

    public void setAsn(boolean asn) {
        this.ext.setAsn(asn);
    }

    public boolean isOctet() {
        return this.ext.isOctet();
    }

    public void setOctet(boolean octet) {
        this.ext.setOctet(octet);
    }

    public boolean isArbitrary() {
        return this.ext.isArbitrary();
    }

    public void setArbitrary(boolean arbitrary) {
        this.ext.setArbitrary(arbitrary);
    }
}

