/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap.asn;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.tcap.asn.AbortSource;
import org.mobicents.protocols.ss7.tcap.asn.DialogAPDUType;
import org.mobicents.protocols.ss7.tcap.asn.DialogAbortAPDU;
import org.mobicents.protocols.ss7.tcap.asn.EncodeException;
import org.mobicents.protocols.ss7.tcap.asn.ParseException;
import org.mobicents.protocols.ss7.tcap.asn.TcapFactory;
import org.mobicents.protocols.ss7.tcap.asn.UserInformation;
import org.mobicents.protocols.ss7.tcap.asn.comp.PAbortCauseType;

public class DialogAbortAPDUImpl
implements DialogAbortAPDU {
    private AbortSource abortSource;
    private UserInformation userInformation;

    public AbortSource getAbortSource() {
        return this.abortSource;
    }

    public void setAbortSource(AbortSource abortSource) {
        this.abortSource = abortSource;
    }

    public UserInformation getUserInformation() {
        return this.userInformation;
    }

    public void setUserInformation(UserInformation userInformation) {
        this.userInformation = userInformation;
    }

    public DialogAPDUType getType() {
        return DialogAPDUType.Abort;
    }

    public boolean isUniDirectional() {
        return false;
    }

    public String toString() {
        return "DialogAbortAPDU[abortSource=" + this.abortSource + ", userInformation=" + this.userInformation + "]";
    }

    public void decode(AsnInputStream ais) throws ParseException {
        try {
            AsnInputStream localAis = ais.readSequenceStream();
            int tag = localAis.readTag();
            if (tag != 0 || localAis.getTagClass() != 2) {
                throw new ParseException(PAbortCauseType.IncorrectTxPortion, null, "Error decoding DialogAbortAPDU.abort-source: bad tag or tagClass, found tag=" + tag + ", tagClass=" + localAis.getTagClass());
            }
            this.abortSource = TcapFactory.createAbortSource(localAis);
            if (localAis.available() == 0) {
                return;
            }
            tag = localAis.readTag();
            if (tag != 30 || localAis.getTagClass() != 2) {
                throw new ParseException(PAbortCauseType.IncorrectTxPortion, null, "Error decoding DialogAbortAPDU.user-information: bad tag or tagClass, found tag=" + tag + ", tagClass=" + localAis.getTagClass());
            }
            this.userInformation = TcapFactory.createUserInformation(localAis);
        }
        catch (IOException e) {
            throw new ParseException(PAbortCauseType.BadlyFormattedTxPortion, null, "IOException while decoding DialogAbortAPDU: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new ParseException(PAbortCauseType.BadlyFormattedTxPortion, null, "AsnException while decoding DialogAbortAPDU: " + e.getMessage(), (Throwable)e);
        }
    }

    public void encode(AsnOutputStream aos) throws EncodeException {
        if (this.abortSource == null) {
            throw new EncodeException("Error encoding DialogAbortAPDU: Abort Source Name must not be null");
        }
        try {
            aos.writeTag(1, false, 4);
            int pos = aos.StartContentDefiniteLength();
            this.abortSource.encode(aos);
            if (this.userInformation != null) {
                this.userInformation.encode(aos);
            }
            aos.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new EncodeException("AsnException while encoding DialogAbortAPDU: " + e.getMessage(), (Throwable)e);
        }
    }
}

