/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javolution.text.TextBuilder;
import javolution.util.FastList;
import javolution.xml.XMLBinding;
import javolution.xml.XMLObjectReader;
import javolution.xml.XMLObjectWriter;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.sccp.SccpProvider;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;
import org.mobicents.protocols.ss7.tcap.SlsRangeType;
import org.mobicents.protocols.ss7.tcap.TCAPCounterProviderImpl;
import org.mobicents.protocols.ss7.tcap.TCAPProviderImpl;
import org.mobicents.protocols.ss7.tcap.api.TCAPCounterEventsListener;
import org.mobicents.protocols.ss7.tcap.api.TCAPCounterProvider;
import org.mobicents.protocols.ss7.tcap.api.TCAPProvider;
import org.mobicents.protocols.ss7.tcap.api.TCAPStack;

public class TCAPStackImpl
implements TCAPStack {
    private final Logger logger;
    protected static final String TCAP_MANAGEMENT_PERSIST_DIR_KEY = "tcapmanagement.persist.dir";
    protected static final String USER_DIR_KEY = "user.dir";
    protected static final String PERSIST_FILE_NAME = "management.xml";
    private static final String TAB_INDENT = "\t";
    private static final String CLASS_ATTRIBUTE = "type";
    private static final String DIALOG_IDLE_TIMEOUT = "dialogidletimeout";
    private static final String INVOKE_TIMEOUT = "invoketimeout";
    private static final String MAX_DIALOGS = "maxdialogs";
    private static final String DIALOG_ID_RANGE_START = "dialogidrangestart";
    private static final String DIALOG_ID_RANGE_END = "dialogidrangeend";
    private static final String PREVIEW_MODE = "previewmode";
    private static final String DO_NOT_SEND_PROTOCOL_VERSION = "donotsendprotocolversion";
    private static final String STATISTICS_ENABLED = "statisticsenabled";
    private static final String SLS_RANGE = "slsrange";
    private static final String CONG_CONTROL_BLOCKING_INCOMING_TCAP_MESSAGES = "congControl_blockingIncomingTcapMessages";
    private static final String CONG_CONTROL_EXECUTOR_DELAY_THRESHOLD_1 = "congControl_ExecutorDelayThreshold_1";
    private static final String CONG_CONTROL_EXECUTOR_DELAY_THRESHOLD_2 = "congControl_ExecutorDelayThreshold_2";
    private static final String CONG_CONTROL_EXECUTOR_DELAY_THRESHOLD_3 = "congControl_ExecutorDelayThreshold_3";
    private static final String CONG_CONTROL_EXECUTOR_BACK_TO_NORMAL_DELAY_THRESHOLD_1 = "congControl_ExecutorBackToNormalDelayThreshold_1";
    private static final String CONG_CONTROL_EXECUTOR_BACK_TO_NORMAL_DELAY_THRESHOLD_2 = "congControl_ExecutorBackToNormalDelayThreshold_2";
    private static final String CONG_CONTROL_EXECUTOR_BACK_TO_NORMAL_DELAY_THRESHOLD_3 = "congControl_ExecutorBackToNormalDelayThreshold_3";
    private static final String CONG_CONTROL_MEMORY_THRESHOLD_1 = "congControl_MemoryThreshold_1";
    private static final String CONG_CONTROL_MEMORY_THRESHOLD_2 = "congControl_MemoryThreshold_2";
    private static final String CONG_CONTROL_MEMORY_THRESHOLD_3 = "congControl_MemoryThreshold_3";
    private static final String CONG_CONTROL_BACK_TO_NORMAL_MEMORY_THRESHOLD_1 = "congControl_BackToNormalMemoryThreshold_1";
    private static final String CONG_CONTROL_BACK_TO_NORMAL_MEMORY_THRESHOLD_2 = "congControl_BackToNormalMemoryThreshold_2";
    private static final String CONG_CONTROL_BACK_TO_NORMAL_MEMORY_THRESHOLD_3 = "congControl_BackToNormalMemoryThreshold_3";
    private static final XMLBinding binding = new XMLBinding();
    public static final long _DIALOG_TIMEOUT = 60000L;
    public static final long _INVOKE_TIMEOUT = 30000L;
    public static final int _MAX_DIALOGS = 5000;
    public static final long _EMPTY_INVOKE_TIMEOUT = -1L;
    protected TCAPProviderImpl tcapProvider;
    protected TCAPCounterProviderImpl tcapCounterProvider;
    protected TCAPCounterEventsListener tcapCounterEventsListener;
    private SccpProvider sccpProvider;
    private SccpAddress address;
    private final String name;
    protected final TextBuilder persistFile = TextBuilder.newInstance();
    protected String persistDir = null;
    private volatile boolean started = false;
    private long dialogTimeout = 60000L;
    private long invokeTimeout = 30000L;
    protected int maxDialogs = 5000;
    private long dialogIdRangeStart = 1L;
    private long dialogIdRangeEnd = Integer.MAX_VALUE;
    private boolean previewMode = false;
    private List<Integer> extraSsns = new FastList();
    private boolean doNotSendProtocolVersion = false;
    private boolean statisticsEnabled = false;
    private boolean congControl_blockingIncomingTcapMessages = false;
    private double[] congControl_ExecutorDelayThreshold = new double[]{1.0, 6.0, 12.0};
    private double[] congControl_ExecutorBackToNormalDelayThreshold = new double[]{0.5, 3.0, 8.0};
    private double[] congControl_MemoryThreshold = new double[]{77.0, 87.0, 97.0};
    private double[] congControl_BackToNormalMemoryThreshold = new double[]{72.0, 82.0, 92.0};
    private int ssn = -1;
    private SlsRangeType slsRange = SlsRangeType.All;

    public TCAPStackImpl(String name) {
        this.name = name;
        this.logger = Logger.getLogger((String)(TCAPStackImpl.class.getCanonicalName() + "-" + this.name));
        binding.setClassAttribute(CLASS_ATTRIBUTE);
        this.setPersistFile();
    }

    public TCAPStackImpl(String name, SccpProvider sccpProvider, int ssn) {
        this(name);
        this.sccpProvider = sccpProvider;
        this.tcapProvider = new TCAPProviderImpl(sccpProvider, this, ssn);
        this.tcapCounterProvider = new TCAPCounterProviderImpl(this.tcapProvider);
        this.ssn = ssn;
    }

    public String getName() {
        return this.name;
    }

    public String getPersistDir() {
        return this.persistDir;
    }

    public int getSubSystemNumber() {
        return this.ssn;
    }

    public void setPersistDir(String persistDir) {
        this.persistDir = persistDir;
        this.setPersistFile();
    }

    private void setPersistFile() {
        this.persistFile.clear();
        if (this.persistDir != null) {
            this.persistFile.append(this.persistDir).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
        } else {
            this.persistFile.append(System.getProperty(TCAP_MANAGEMENT_PERSIST_DIR_KEY, System.getProperty(USER_DIR_KEY))).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
        }
    }

    public void start() throws Exception {
        this.logger.info((Object)("Starting ..." + this.tcapProvider));
        this.logger.info((Object)String.format("TCAP Management configuration file path %s", this.persistFile.toString()));
        try {
            this.load();
        }
        catch (FileNotFoundException e) {
            this.logger.warn((Object)String.format("Failed to load the TCAP Management configuration file. \n%s", e.getMessage()));
        }
        if (this.dialogTimeout < 0L) {
            throw new IllegalArgumentException("DialogIdleTimeout value must be greater or equal to zero.");
        }
        if (this.dialogTimeout < this.invokeTimeout) {
            throw new IllegalArgumentException("DialogIdleTimeout value must be greater or equal to invoke timeout.");
        }
        if (this.invokeTimeout < 0L) {
            throw new IllegalArgumentException("InvokeTimeout value must be greater or equal to zero.");
        }
        this.tcapCounterProvider = new TCAPCounterProviderImpl(this.tcapProvider);
        this.tcapProvider.start();
        this.started = true;
    }

    private void checkDialogIdRangeValues(long rangeStart, long rangeEnd) {
        if (rangeStart >= rangeEnd) {
            throw new IllegalArgumentException("Range start value cannot be equal/greater than Range end value");
        }
        if (rangeStart < 1L) {
            throw new IllegalArgumentException("Range start value must be greater or equal 1");
        }
        if (rangeEnd > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Range end value must be less or equal 2147483647");
        }
        if (rangeEnd - rangeStart < 10000L) {
            throw new IllegalArgumentException("Range \"end - start\" must has at least 10000 possible dialogs");
        }
        if (rangeEnd - rangeStart <= (long)this.maxDialogs) {
            throw new IllegalArgumentException("MaxDialog must be less than DialogIdRange");
        }
    }

    public void stop() {
        this.tcapProvider.stop();
        this.started = false;
        this.store();
    }

    public boolean isStarted() {
        return this.started;
    }

    public TCAPProvider getProvider() {
        return this.tcapProvider;
    }

    public TCAPCounterProvider getCounterProvider() {
        return this.tcapCounterProvider;
    }

    public TCAPCounterProviderImpl getCounterProviderImpl() {
        return this.tcapCounterProvider;
    }

    public void setDialogIdleTimeout(long v) throws Exception {
        if (!this.started) {
            throw new Exception("DialogIdleTimeout parameter can be updated only when TCAP stack is running");
        }
        if (v < 0L) {
            throw new IllegalArgumentException("DialogIdleTimeout value must be greater or equal to zero.");
        }
        if (v < this.invokeTimeout) {
            throw new IllegalArgumentException("DialogIdleTimeout value must be greater or equal to invoke timeout.");
        }
        this.dialogTimeout = v;
        this.store();
    }

    public long getDialogIdleTimeout() {
        return this.dialogTimeout;
    }

    public void setInvokeTimeout(long v) throws Exception {
        if (!this.started) {
            throw new Exception("InvokeTimeout parameter can be updated only when TCAP stack is running");
        }
        if (v < 0L) {
            throw new IllegalArgumentException("InvokeTimeout value must be greater or equal to zero.");
        }
        if (v > this.dialogTimeout) {
            throw new IllegalArgumentException("InvokeTimeout value must be smaller or equal to dialog timeout.");
        }
        this.invokeTimeout = v;
        this.store();
    }

    public long getInvokeTimeout() {
        return this.invokeTimeout;
    }

    public void setMaxDialogs(int v) throws Exception {
        if (!this.started) {
            throw new Exception("MaxDialogs parameter can be updated only when TCAP stack is running");
        }
        if (v < 1) {
            throw new IllegalArgumentException("At least one Dialog must be accepted");
        }
        if ((long)v >= this.dialogIdRangeEnd - this.dialogIdRangeStart) {
            throw new IllegalArgumentException("MaxDialog must be less than DialogIdRange");
        }
        this.maxDialogs = v;
        this.store();
    }

    public int getMaxDialogs() {
        return this.maxDialogs;
    }

    public void setDialogIdRangeStart(long val) throws Exception {
        if (!this.started) {
            throw new Exception("DialogIdRangeStart parameter can be updated only when TCAP stack is running");
        }
        this.checkDialogIdRangeValues(val, this.getDialogIdRangeEnd());
        this.dialogIdRangeStart = val;
        this.tcapProvider.resetDialogIdValueAfterRangeChange();
        this.store();
    }

    public void setDialogIdRangeEnd(long val) throws Exception {
        if (!this.started) {
            throw new Exception("DialogIdRangeEnd parameter can be updated only when TCAP stack is running");
        }
        this.checkDialogIdRangeValues(this.getDialogIdRangeStart(), val);
        this.dialogIdRangeEnd = val;
        this.tcapProvider.resetDialogIdValueAfterRangeChange();
        this.store();
    }

    public long getDialogIdRangeStart() {
        return this.dialogIdRangeStart;
    }

    public long getDialogIdRangeEnd() {
        return this.dialogIdRangeEnd;
    }

    public void setPreviewMode(boolean val) throws Exception {
        if (this.started) {
            throw new Exception("PreviewMode parameter can be updated only when TCAP stack is NOT running");
        }
        this.previewMode = val;
    }

    public boolean getPreviewMode() {
        return this.previewMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExtraSsns(List<Integer> extraSsnsNew) throws Exception {
        if (this.started) {
            throw new Exception("ExtraSsns parameter can be updated only when TCAP stack is NOT running");
        }
        if (extraSsnsNew != null) {
            TCAPStackImpl tCAPStackImpl = this;
            synchronized (tCAPStackImpl) {
                FastList extraSsnsTemp = new FastList();
                extraSsnsTemp.addAll(extraSsnsNew);
                this.extraSsns = extraSsnsTemp;
            }
        }
    }

    public List<Integer> getExtraSsns() {
        return this.extraSsns;
    }

    public boolean isExtraSsnPresent(int ssn) {
        if (this.ssn == ssn) {
            return true;
        }
        return this.extraSsns != null && this.extraSsns.contains(ssn);
    }

    public String getSubSystemNumberList() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.ssn);
        if (this.extraSsns != null) {
            for (Integer iSsn : this.extraSsns) {
                sb.append(", ");
                sb.append(iSsn);
            }
        }
        return sb.toString();
    }

    public void setSlsRange(String val) throws Exception {
        if (val.equals(SlsRangeType.All.toString())) {
            this.slsRange = SlsRangeType.All;
        } else if (val.equals(SlsRangeType.Odd.toString())) {
            this.slsRange = SlsRangeType.Odd;
        } else if (val.equals(SlsRangeType.Even.toString())) {
            this.slsRange = SlsRangeType.Even;
        } else {
            throw new Exception("SlsRange value is invalid");
        }
        this.store();
    }

    public String getSlsRange() {
        return this.slsRange.toString();
    }

    public SlsRangeType getSlsRangeType() {
        return this.slsRange;
    }

    public void setDoNotSendProtocolVersion(boolean val) throws Exception {
        if (!this.started) {
            throw new Exception("DoNotSendProtocolVersion parameter can be updated only when TCAP stack is running");
        }
        this.doNotSendProtocolVersion = val;
        this.store();
    }

    public boolean getDoNotSendProtocolVersion() {
        return this.doNotSendProtocolVersion;
    }

    public void setStatisticsEnabled(boolean val) throws Exception {
        if (!this.started) {
            throw new Exception("StatisticsEnabled parameter can be updated only when TCAP stack is running");
        }
        this.tcapCounterProvider = new TCAPCounterProviderImpl(this.tcapProvider);
        this.statisticsEnabled = val;
        this.store();
    }

    public boolean getStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public boolean isCongControl_blockingIncomingTcapMessages() {
        return this.congControl_blockingIncomingTcapMessages;
    }

    public void setCongControl_blockingIncomingTcapMessages(boolean value) throws Exception {
        if (!this.started) {
            throw new Exception("CongControl_blockingIncomingTcapMessages parameter can be updated only when TCAP stack is running");
        }
        this.congControl_blockingIncomingTcapMessages = value;
        this.store();
    }

    public double getCongControl_ExecutorDelayThreshold_1() {
        return this.congControl_ExecutorDelayThreshold[0];
    }

    public double getCongControl_ExecutorDelayThreshold_2() {
        return this.congControl_ExecutorDelayThreshold[1];
    }

    public double getCongControl_ExecutorDelayThreshold_3() {
        return this.congControl_ExecutorDelayThreshold[2];
    }

    public void setCongControl_ExecutorDelayThreshold_1(double value) throws Exception {
        if (!this.started) {
            throw new Exception("CongControl_ExecutorDelayThreshold_1 parameter can be updated only when TCAP stack is running");
        }
        this.congControl_ExecutorDelayThreshold[0] = value;
        this.store();
    }

    public void setCongControl_ExecutorDelayThreshold_2(double value) throws Exception {
        if (!this.started) {
            throw new Exception("CongControl_ExecutorDelayThreshold_2 parameter can be updated only when TCAP stack is running");
        }
        this.congControl_ExecutorDelayThreshold[1] = value;
        this.store();
    }

    public void setCongControl_ExecutorDelayThreshold_3(double value) throws Exception {
        if (!this.started) {
            throw new Exception("CongControl_ExecutorDelayThreshold_3 parameter can be updated only when TCAP stack is running");
        }
        this.congControl_ExecutorDelayThreshold[2] = value;
        this.store();
    }

    public double getCongControl_ExecutorBackToNormalDelayThreshold_1() {
        return this.congControl_ExecutorBackToNormalDelayThreshold[0];
    }

    public double getCongControl_ExecutorBackToNormalDelayThreshold_2() {
        return this.congControl_ExecutorBackToNormalDelayThreshold[1];
    }

    public double getCongControl_ExecutorBackToNormalDelayThreshold_3() {
        return this.congControl_ExecutorBackToNormalDelayThreshold[2];
    }

    public void setCongControl_ExecutorBackToNormalDelayThreshold_1(double value) throws Exception {
        if (!this.started) {
            throw new Exception("ExecutorBackToNormalDelayThreshold_1 parameter can be updated only when TCAP stack is running");
        }
        this.congControl_ExecutorBackToNormalDelayThreshold[0] = value;
        this.store();
    }

    public void setCongControl_ExecutorBackToNormalDelayThreshold_2(double value) throws Exception {
        if (!this.started) {
            throw new Exception("ExecutorBackToNormalDelayThreshold_2 parameter can be updated only when TCAP stack is running");
        }
        this.congControl_ExecutorBackToNormalDelayThreshold[1] = value;
        this.store();
    }

    public void setCongControl_ExecutorBackToNormalDelayThreshold_3(double value) throws Exception {
        if (!this.started) {
            throw new Exception("ExecutorBackToNormalDelayThreshold_3 parameter can be updated only when TCAP stack is running");
        }
        this.congControl_ExecutorBackToNormalDelayThreshold[2] = value;
        this.store();
    }

    public double getCongControl_MemoryThreshold_1() {
        return this.congControl_MemoryThreshold[0];
    }

    public double getCongControl_MemoryThreshold_2() {
        return this.congControl_MemoryThreshold[1];
    }

    public double getCongControl_MemoryThreshold_3() {
        return this.congControl_MemoryThreshold[2];
    }

    public void setCongControl_MemoryThreshold_1(double value) throws Exception {
        if (!this.started) {
            throw new Exception("CongControl_MemoryThreshold_1 parameter can be updated only when TCAP stack is running");
        }
        this.congControl_MemoryThreshold[0] = value;
        this.store();
    }

    public void setCongControl_MemoryThreshold_2(double value) throws Exception {
        if (!this.started) {
            throw new Exception("CongControl_MemoryThreshold_2 parameter can be updated only when TCAP stack is running");
        }
        this.congControl_MemoryThreshold[1] = value;
        this.store();
    }

    public void setCongControl_MemoryThreshold_3(double value) throws Exception {
        if (!this.started) {
            throw new Exception("CongControl_MemoryThreshold_3 parameter can be updated only when TCAP stack is running");
        }
        this.congControl_MemoryThreshold[2] = value;
        this.store();
    }

    public double getCongControl_BackToNormalMemoryThreshold_1() {
        return this.congControl_BackToNormalMemoryThreshold[0];
    }

    public double getCongControl_BackToNormalMemoryThreshold_2() {
        return this.congControl_BackToNormalMemoryThreshold[1];
    }

    public double getCongControl_BackToNormalMemoryThreshold_3() {
        return this.congControl_BackToNormalMemoryThreshold[2];
    }

    public void setCongControl_BackToNormalMemoryThreshold_1(double value) throws Exception {
        if (!this.started) {
            throw new Exception("BackToNormalMemoryThreshold_1 parameter can be updated only when TCAP stack is running");
        }
        this.congControl_BackToNormalMemoryThreshold[0] = value;
        this.store();
    }

    public void setCongControl_BackToNormalMemoryThreshold_2(double value) throws Exception {
        if (!this.started) {
            throw new Exception("BackToNormalMemoryThreshold_2 parameter can be updated only when TCAP stack is running");
        }
        this.congControl_BackToNormalMemoryThreshold[1] = value;
        this.store();
    }

    public void setCongControl_BackToNormalMemoryThreshold_3(double value) throws Exception {
        if (!this.started) {
            throw new Exception("BackToNormalMemoryThreshold_3 parameter can be updated only when TCAP stack is running");
        }
        this.congControl_BackToNormalMemoryThreshold[2] = value;
        this.store();
    }

    public void store() {
        try {
            XMLObjectWriter writer = XMLObjectWriter.newInstance((OutputStream)new FileOutputStream(this.persistFile.toString()));
            writer.setBinding(binding);
            writer.setIndentation(TAB_INDENT);
            writer.write((Object)this.dialogTimeout, DIALOG_IDLE_TIMEOUT, Long.class);
            writer.write((Object)this.invokeTimeout, INVOKE_TIMEOUT, Long.class);
            writer.write((Object)this.maxDialogs, MAX_DIALOGS, Integer.class);
            writer.write((Object)this.dialogIdRangeStart, DIALOG_ID_RANGE_START, Long.class);
            writer.write((Object)this.dialogIdRangeEnd, DIALOG_ID_RANGE_END, Long.class);
            writer.write((Object)this.doNotSendProtocolVersion, DO_NOT_SEND_PROTOCOL_VERSION, Boolean.class);
            writer.write((Object)this.congControl_blockingIncomingTcapMessages, CONG_CONTROL_BLOCKING_INCOMING_TCAP_MESSAGES, Boolean.class);
            if (this.congControl_ExecutorDelayThreshold != null && this.congControl_ExecutorDelayThreshold.length == 3) {
                writer.write((Object)this.congControl_ExecutorDelayThreshold[0], CONG_CONTROL_EXECUTOR_DELAY_THRESHOLD_1, Double.class);
                writer.write((Object)this.congControl_ExecutorDelayThreshold[1], CONG_CONTROL_EXECUTOR_DELAY_THRESHOLD_2, Double.class);
                writer.write((Object)this.congControl_ExecutorDelayThreshold[2], CONG_CONTROL_EXECUTOR_DELAY_THRESHOLD_3, Double.class);
            }
            if (this.congControl_ExecutorBackToNormalDelayThreshold != null && this.congControl_ExecutorBackToNormalDelayThreshold.length == 3) {
                writer.write((Object)this.congControl_ExecutorBackToNormalDelayThreshold[0], CONG_CONTROL_EXECUTOR_BACK_TO_NORMAL_DELAY_THRESHOLD_1, Double.class);
                writer.write((Object)this.congControl_ExecutorBackToNormalDelayThreshold[1], CONG_CONTROL_EXECUTOR_BACK_TO_NORMAL_DELAY_THRESHOLD_2, Double.class);
                writer.write((Object)this.congControl_ExecutorBackToNormalDelayThreshold[2], CONG_CONTROL_EXECUTOR_BACK_TO_NORMAL_DELAY_THRESHOLD_3, Double.class);
            }
            if (this.congControl_MemoryThreshold != null && this.congControl_MemoryThreshold.length == 3) {
                writer.write((Object)this.congControl_MemoryThreshold[0], CONG_CONTROL_MEMORY_THRESHOLD_1, Double.class);
                writer.write((Object)this.congControl_MemoryThreshold[1], CONG_CONTROL_MEMORY_THRESHOLD_2, Double.class);
                writer.write((Object)this.congControl_MemoryThreshold[2], CONG_CONTROL_MEMORY_THRESHOLD_3, Double.class);
            }
            if (this.congControl_BackToNormalMemoryThreshold != null && this.congControl_BackToNormalMemoryThreshold.length == 3) {
                writer.write((Object)this.congControl_BackToNormalMemoryThreshold[0], CONG_CONTROL_BACK_TO_NORMAL_MEMORY_THRESHOLD_1, Double.class);
                writer.write((Object)this.congControl_BackToNormalMemoryThreshold[1], CONG_CONTROL_BACK_TO_NORMAL_MEMORY_THRESHOLD_2, Double.class);
                writer.write((Object)this.congControl_BackToNormalMemoryThreshold[2], CONG_CONTROL_BACK_TO_NORMAL_MEMORY_THRESHOLD_3, Double.class);
            }
            writer.write((Object)this.statisticsEnabled, STATISTICS_ENABLED, Boolean.class);
            writer.write((Object)this.slsRange.toString(), SLS_RANGE, String.class);
            writer.write((Object)this.statisticsEnabled, STATISTICS_ENABLED, Boolean.class);
            writer.close();
        }
        catch (Exception e) {
            this.logger.error((Object)String.format("Error while persisting the TCAP Resource state in file=%s", this.persistFile.toString()), (Throwable)e);
        }
    }

    protected void load() throws FileNotFoundException {
        XMLObjectReader reader = null;
        try {
            String vals;
            Boolean valb;
            Integer vali;
            reader = XMLObjectReader.newInstance((InputStream)new FileInputStream(this.persistFile.toString()));
            reader.setBinding(binding);
            Long vall = (Long)reader.read(DIALOG_IDLE_TIMEOUT, Long.class);
            if (vall != null) {
                this.dialogTimeout = vall;
            }
            if ((vall = (Long)reader.read(INVOKE_TIMEOUT, Long.class)) != null) {
                this.invokeTimeout = vall;
            }
            if ((vali = (Integer)reader.read(MAX_DIALOGS, Integer.class)) != null) {
                this.maxDialogs = vali;
            }
            if ((vall = (Long)reader.read(DIALOG_ID_RANGE_START, Long.class)) != null) {
                this.dialogIdRangeStart = vall;
            }
            if ((vall = (Long)reader.read(DIALOG_ID_RANGE_END, Long.class)) != null) {
                this.dialogIdRangeEnd = vall;
            }
            Boolean volb = (Boolean)reader.read(PREVIEW_MODE, Boolean.class);
            volb = (Boolean)reader.read(DO_NOT_SEND_PROTOCOL_VERSION, Boolean.class);
            if (volb != null) {
                this.doNotSendProtocolVersion = volb;
            }
            if ((valb = (Boolean)reader.read(CONG_CONTROL_BLOCKING_INCOMING_TCAP_MESSAGES, Boolean.class)) != null) {
                this.congControl_blockingIncomingTcapMessages = valb;
            }
            Double valTH1 = (Double)reader.read(CONG_CONTROL_EXECUTOR_DELAY_THRESHOLD_1, Double.class);
            Double valTH2 = (Double)reader.read(CONG_CONTROL_EXECUTOR_DELAY_THRESHOLD_2, Double.class);
            Double valTH3 = (Double)reader.read(CONG_CONTROL_EXECUTOR_DELAY_THRESHOLD_3, Double.class);
            Double valTB1 = (Double)reader.read(CONG_CONTROL_EXECUTOR_BACK_TO_NORMAL_DELAY_THRESHOLD_1, Double.class);
            Double valTB2 = (Double)reader.read(CONG_CONTROL_EXECUTOR_BACK_TO_NORMAL_DELAY_THRESHOLD_2, Double.class);
            Double valTB3 = (Double)reader.read(CONG_CONTROL_EXECUTOR_BACK_TO_NORMAL_DELAY_THRESHOLD_3, Double.class);
            if (valTH1 != null && valTH2 != null && valTH3 != null && valTB1 != null && valTB2 != null && valTB3 != null) {
                this.congControl_ExecutorDelayThreshold = new double[3];
                this.congControl_ExecutorDelayThreshold[0] = valTH1;
                this.congControl_ExecutorDelayThreshold[1] = valTH2;
                this.congControl_ExecutorDelayThreshold[2] = valTH3;
                this.congControl_ExecutorBackToNormalDelayThreshold = new double[3];
                this.congControl_ExecutorBackToNormalDelayThreshold[0] = valTB1;
                this.congControl_ExecutorBackToNormalDelayThreshold[1] = valTB2;
                this.congControl_ExecutorBackToNormalDelayThreshold[2] = valTB3;
            }
            valTH1 = (Double)reader.read(CONG_CONTROL_MEMORY_THRESHOLD_1, Double.class);
            valTH2 = (Double)reader.read(CONG_CONTROL_MEMORY_THRESHOLD_2, Double.class);
            valTH3 = (Double)reader.read(CONG_CONTROL_MEMORY_THRESHOLD_3, Double.class);
            valTB1 = (Double)reader.read(CONG_CONTROL_BACK_TO_NORMAL_MEMORY_THRESHOLD_1, Double.class);
            valTB2 = (Double)reader.read(CONG_CONTROL_BACK_TO_NORMAL_MEMORY_THRESHOLD_2, Double.class);
            valTB3 = (Double)reader.read(CONG_CONTROL_BACK_TO_NORMAL_MEMORY_THRESHOLD_3, Double.class);
            if (valTH1 != null && valTH2 != null && valTH3 != null && valTB1 != null && valTB2 != null && valTB3 != null) {
                this.congControl_MemoryThreshold = new double[3];
                this.congControl_MemoryThreshold[0] = valTH1;
                this.congControl_MemoryThreshold[1] = valTH2;
                this.congControl_MemoryThreshold[2] = valTH3;
                this.congControl_BackToNormalMemoryThreshold = new double[3];
                this.congControl_BackToNormalMemoryThreshold[0] = valTB1;
                this.congControl_BackToNormalMemoryThreshold[1] = valTB2;
                this.congControl_BackToNormalMemoryThreshold[2] = valTB3;
            }
            if ((volb = (Boolean)reader.read(STATISTICS_ENABLED, Boolean.class)) != null) {
                this.statisticsEnabled = volb;
            }
            if ((vals = (String)reader.read(SLS_RANGE, String.class)) != null) {
                this.slsRange = Enum.valueOf(SlsRangeType.class, vals);
            }
            if ((volb = (Boolean)reader.read(STATISTICS_ENABLED, Boolean.class)) != null) {
                this.statisticsEnabled = volb;
            }
            reader.close();
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    public TCAPCounterEventsListener getTCAPCounterEventsListener() {
        return this.tcapCounterEventsListener;
    }

    public void setTCAPCounterEventsListener(TCAPCounterEventsListener tcapCounterEventsListener) {
        this.tcapCounterEventsListener = tcapCounterEventsListener;
    }
}

