/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.mobicents.protocols.ss7.statistics.StatDataCollectionImpl;
import org.mobicents.protocols.ss7.statistics.api.LongValue;
import org.mobicents.protocols.ss7.statistics.api.StatDataCollection;
import org.mobicents.protocols.ss7.statistics.api.StatDataCollectorType;
import org.mobicents.protocols.ss7.statistics.api.StatResult;
import org.mobicents.protocols.ss7.tcap.TCAPProviderImpl;
import org.mobicents.protocols.ss7.tcap.api.TCAPCounterEventsListener;
import org.mobicents.protocols.ss7.tcap.api.TCAPCounterProvider;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.Dialog;
import org.mobicents.protocols.ss7.tcap.asn.comp.Invoke;
import org.mobicents.protocols.ss7.tcap.asn.comp.PAbortCauseType;

public class TCAPCounterProviderImpl
implements TCAPCounterProvider {
    private UUID sessionId = UUID.randomUUID();
    private TCAPProviderImpl provider;
    private StatDataCollection statDataCollection = new StatDataCollectionImpl();
    private AtomicLong tcUniReceivedCount = new AtomicLong();
    private AtomicLong tcUniSentCount = new AtomicLong();
    private AtomicLong tcBeginReceivedCount = new AtomicLong();
    private AtomicLong tcBeginSentCount = new AtomicLong();
    private AtomicLong tcContinueReceivedCount = new AtomicLong();
    private AtomicLong tcContinueSentCount = new AtomicLong();
    private AtomicLong tcEndReceivedCount = new AtomicLong();
    private AtomicLong tcEndSentCount = new AtomicLong();
    private AtomicLong tcPAbortReceivedCount = new AtomicLong();
    private AtomicLong tcPAbortSentCount = new AtomicLong();
    private AtomicLong tcUserAbortReceivedCount = new AtomicLong();
    private AtomicLong tcUserAbortSentCount = new AtomicLong();
    private AtomicLong invokeReceivedCount = new AtomicLong();
    private AtomicLong invokeSentCount = new AtomicLong();
    private AtomicLong returnResultReceivedCount = new AtomicLong();
    private AtomicLong returnResultSentCount = new AtomicLong();
    private AtomicLong returnResultLastReceivedCount = new AtomicLong();
    private AtomicLong returnResultLastSentCount = new AtomicLong();
    private AtomicLong returnErrorReceivedCount = new AtomicLong();
    private AtomicLong returnErrorSentCount = new AtomicLong();
    private AtomicLong rejectReceivedCount = new AtomicLong();
    private AtomicLong rejectSentCount = new AtomicLong();
    private AtomicLong dialogTimeoutCount = new AtomicLong();
    private AtomicLong dialogReleaseCount = new AtomicLong();
    private AtomicLong allEstablishedDialogsCount = new AtomicLong();
    private AtomicLong allLocalEstablishedDialogsCount = new AtomicLong();
    private AtomicLong allRemoteEstablishedDialogsCount = new AtomicLong();
    private AtomicLong allDialogsDuration = new AtomicLong();
    private static String OUTGOING_DIALOGS_PER_APPLICATION_CONTEXT_NAME = "outgoingDialogsPerApplicationContextName";
    private static String INCOMING_DIALOGS_PER_APPLICATION_CONTEXT_NAME = "incomingDialogsPerApplicationContextName";
    private static String OUTGOING_INVOKES_PER_OPERATION_CODE = "outgoingInvokesPerOperationCode";
    private static String INCOMING_INVOKES_PER_OPERATION_CODE = "incomingInvokesPerOperationCode";
    private static String OUTGOING_ERRORS_PER_ERROR_CODE = "outgoingErrorsPerErrorCode";
    private static String INCOMING_ERRORS_PER_ERROR_CODE = "incomingErrorsPerErrorCode";
    private static String OUTGOING_REJECT_PER_PROBLEM = "outgoingRejectPerProblem";
    private static String INCOMING_REJECT_PER_PROBLEM = "incomingRejectPerProblem";
    private static String MIN_DIALOGS_COUNT = "MinDialogsCount";
    private static String MAX_DIALOGS_COUNT = "MaxDialogsCount";
    private static String MAX_NETWORK_ID_AREAS_NOT_AVAILABLE = "MaxNetworkIdAreasNotAvailable";
    private static String MAX_NETWORK_ID_AREAS_CONGLEVEL_1 = "MaxNetworkIdAreasCongLevel_1";
    private static String MAX_NETWORK_ID_AREAS_CONGLEVEL_2 = "MaxNetworkIdAreasCongLevel_2";
    private static String MAX_NETWORK_ID_AREAS_CONGLEVEL_3 = "MaxNetworkIdAreasCongLevel_3";
    private static String MAX_EXECUTORS_CONG_LEVEL_1 = "MaxExecutorsCongLevel_1";
    private static String MAX_EXECUTORS_CONG_LEVEL_2 = "MaxExecutorsCongLevel_2";
    private static String MAX_EXECUTORS_CONG_LEVEL_3 = "MaxExecutorsCongLevel_3";
    private static String MAX_MEMORY_CONG_LEVEL = "MaxMemoryCongLevel";
    private static String MAX_USER_PARTS_CONG_LEVEL_1 = "MaxUserPartsCongLevel_1";
    private static String MAX_USER_PARTS_CONG_LEVEL_2 = "MaxUserPartsCongLevel_2";
    private static String MAX_USER_PARTS_CONG_LEVEL_3 = "MaxUserPartsCongLevel_3";

    public TCAPCounterProviderImpl(TCAPProviderImpl provider) {
        this.provider = provider;
        this.statDataCollection.registerStatCounterCollector(MIN_DIALOGS_COUNT, StatDataCollectorType.MIN);
        this.statDataCollection.registerStatCounterCollector(MAX_DIALOGS_COUNT, StatDataCollectorType.MAX);
        this.statDataCollection.registerStatCounterCollector(OUTGOING_DIALOGS_PER_APPLICATION_CONTEXT_NAME, StatDataCollectorType.StringLongMap);
        this.statDataCollection.registerStatCounterCollector(INCOMING_DIALOGS_PER_APPLICATION_CONTEXT_NAME, StatDataCollectorType.StringLongMap);
        this.statDataCollection.registerStatCounterCollector(OUTGOING_INVOKES_PER_OPERATION_CODE, StatDataCollectorType.StringLongMap);
        this.statDataCollection.registerStatCounterCollector(INCOMING_INVOKES_PER_OPERATION_CODE, StatDataCollectorType.StringLongMap);
        this.statDataCollection.registerStatCounterCollector(OUTGOING_ERRORS_PER_ERROR_CODE, StatDataCollectorType.StringLongMap);
        this.statDataCollection.registerStatCounterCollector(INCOMING_ERRORS_PER_ERROR_CODE, StatDataCollectorType.StringLongMap);
        this.statDataCollection.registerStatCounterCollector(OUTGOING_REJECT_PER_PROBLEM, StatDataCollectorType.StringLongMap);
        this.statDataCollection.registerStatCounterCollector(INCOMING_REJECT_PER_PROBLEM, StatDataCollectorType.StringLongMap);
        this.statDataCollection.registerStatCounterCollector(MAX_NETWORK_ID_AREAS_NOT_AVAILABLE, StatDataCollectorType.MAX);
        this.statDataCollection.registerStatCounterCollector(MAX_NETWORK_ID_AREAS_CONGLEVEL_1, StatDataCollectorType.MAX);
        this.statDataCollection.registerStatCounterCollector(MAX_NETWORK_ID_AREAS_CONGLEVEL_2, StatDataCollectorType.MAX);
        this.statDataCollection.registerStatCounterCollector(MAX_NETWORK_ID_AREAS_CONGLEVEL_3, StatDataCollectorType.MAX);
        this.statDataCollection.registerStatCounterCollector(MAX_EXECUTORS_CONG_LEVEL_1, StatDataCollectorType.MAX);
        this.statDataCollection.registerStatCounterCollector(MAX_EXECUTORS_CONG_LEVEL_2, StatDataCollectorType.MAX);
        this.statDataCollection.registerStatCounterCollector(MAX_EXECUTORS_CONG_LEVEL_3, StatDataCollectorType.MAX);
        this.statDataCollection.registerStatCounterCollector(MAX_MEMORY_CONG_LEVEL, StatDataCollectorType.MAX);
        this.statDataCollection.registerStatCounterCollector(MAX_USER_PARTS_CONG_LEVEL_1, StatDataCollectorType.MAX);
        this.statDataCollection.registerStatCounterCollector(MAX_USER_PARTS_CONG_LEVEL_2, StatDataCollectorType.MAX);
        this.statDataCollection.registerStatCounterCollector(MAX_USER_PARTS_CONG_LEVEL_3, StatDataCollectorType.MAX);
    }

    public UUID getSessionId() {
        return this.sessionId;
    }

    public long getTcUniReceivedCount() {
        return this.tcUniReceivedCount.get();
    }

    public void updateTcUniReceivedCount(Dialog dialog) {
        this.tcUniReceivedCount.addAndGet(1L);
        TCAPCounterEventsListener listener = this.provider.getStack().getTCAPCounterEventsListener();
        if (listener != null) {
            listener.updateTcUniReceivedCount(dialog);
        }
    }

    public long getTcUniSentCount() {
        return this.tcUniSentCount.get();
    }

    public void updateTcUniSentCount(Dialog dialog) {
        this.tcUniSentCount.addAndGet(1L);
        TCAPCounterEventsListener listener = this.provider.getStack().getTCAPCounterEventsListener();
        if (listener != null) {
            listener.updateTcUniSentCount(dialog);
        }
    }

    public long getTcBeginReceivedCount() {
        return this.tcBeginReceivedCount.get();
    }

    public void updateTcBeginReceivedCount(Dialog dialog) {
        this.tcBeginReceivedCount.addAndGet(1L);
        TCAPCounterEventsListener listener = this.provider.getStack().getTCAPCounterEventsListener();
        if (listener != null) {
            listener.updateTcBeginReceivedCount(dialog);
        }
    }

    public long getTcBeginSentCount() {
        return this.tcBeginSentCount.get();
    }

    public void updateTcBeginSentCount(Dialog dialog) {
        this.tcBeginSentCount.addAndGet(1L);
        TCAPCounterEventsListener listener = this.provider.getStack().getTCAPCounterEventsListener();
        if (listener != null) {
            listener.updateTcBeginSentCount(dialog);
        }
    }

    public long getTcContinueReceivedCount() {
        return this.tcContinueReceivedCount.get();
    }

    public void updateTcContinueReceivedCount(Dialog dialog) {
        this.tcContinueReceivedCount.addAndGet(1L);
        TCAPCounterEventsListener listener = this.provider.getStack().getTCAPCounterEventsListener();
        if (listener != null) {
            listener.updateTcContinueReceivedCount(dialog);
        }
    }

    public long getTcContinueSentCount() {
        return this.tcContinueSentCount.get();
    }

    public void updateTcContinueSentCount(Dialog dialog) {
        this.tcContinueSentCount.addAndGet(1L);
        TCAPCounterEventsListener listener = this.provider.getStack().getTCAPCounterEventsListener();
        if (listener != null) {
            listener.updateTcContinueSentCount(dialog);
        }
    }

    public long getTcEndReceivedCount() {
        return this.tcEndReceivedCount.get();
    }

    public void updateTcEndReceivedCount(Dialog dialog) {
        this.tcEndReceivedCount.addAndGet(1L);
        TCAPCounterEventsListener listener = this.provider.getStack().getTCAPCounterEventsListener();
        if (listener != null) {
            listener.updateTcContinueSentCount(dialog);
        }
    }

    public long getTcEndSentCount() {
        return this.tcEndSentCount.get();
    }

    public void updateTcEndSentCount(Dialog dialog) {
        this.tcEndSentCount.addAndGet(1L);
        TCAPCounterEventsListener listener = this.provider.getStack().getTCAPCounterEventsListener();
        if (listener != null) {
            listener.updateTcEndSentCount(dialog);
        }
    }

    public long getTcPAbortReceivedCount() {
        return this.tcPAbortReceivedCount.get();
    }

    public void updateTcPAbortReceivedCount(Dialog dialog, PAbortCauseType cause) {
        this.tcPAbortReceivedCount.addAndGet(1L);
        TCAPCounterEventsListener listener = this.provider.getStack().getTCAPCounterEventsListener();
        if (listener != null) {
            listener.updateTcPAbortReceivedCount(dialog, cause);
        }
    }

    public long getTcPAbortSentCount() {
        return this.tcPAbortSentCount.get();
    }

    public void updateTcPAbortSentCount(byte[] originatingTransactionId, PAbortCauseType cause) {
        this.tcPAbortSentCount.addAndGet(1L);
        TCAPCounterEventsListener listener = this.provider.getStack().getTCAPCounterEventsListener();
        if (listener != null) {
            listener.updateTcPAbortSentCount(originatingTransactionId, cause);
        }
    }

    public long getTcUserAbortReceivedCount() {
        return this.tcUserAbortReceivedCount.get();
    }

    public void updateTcUserAbortReceivedCount(Dialog dialog) {
        this.tcUserAbortReceivedCount.addAndGet(1L);
        TCAPCounterEventsListener listener = this.provider.getStack().getTCAPCounterEventsListener();
        if (listener != null) {
            listener.updateTcUserAbortReceivedCount(dialog);
        }
    }

    public long getTcUserAbortSentCount() {
        return this.tcUserAbortSentCount.get();
    }

    public void updateTcUserAbortSentCount(Dialog dialog) {
        this.tcUserAbortSentCount.addAndGet(1L);
        TCAPCounterEventsListener listener = this.provider.getStack().getTCAPCounterEventsListener();
        if (listener != null) {
            listener.updateTcUserAbortSentCount(dialog);
        }
    }

    public long getInvokeReceivedCount() {
        return this.invokeReceivedCount.get();
    }

    public void updateInvokeReceivedCount(Dialog dialog, Invoke invoke) {
        this.invokeReceivedCount.addAndGet(1L);
        TCAPCounterEventsListener listener = this.provider.getStack().getTCAPCounterEventsListener();
        if (listener != null) {
            listener.updateInvokeReceivedCount(dialog, invoke);
        }
    }

    public long getInvokeSentCount() {
        return this.invokeSentCount.get();
    }

    public void updateInvokeSentCount(Dialog dialog, Invoke invoke) {
        this.invokeSentCount.addAndGet(1L);
        TCAPCounterEventsListener listener = this.provider.getStack().getTCAPCounterEventsListener();
        if (listener != null) {
            listener.updateInvokeSentCount(dialog, invoke);
        }
    }

    public long getReturnResultReceivedCount() {
        return this.returnResultReceivedCount.get();
    }

    public void updateReturnResultReceivedCount(Dialog dialog) {
        this.returnResultReceivedCount.addAndGet(1L);
        TCAPCounterEventsListener listener = this.provider.getStack().getTCAPCounterEventsListener();
        if (listener != null) {
            listener.updateReturnResultReceivedCount(dialog);
        }
    }

    public long getReturnResultSentCount() {
        return this.returnResultSentCount.get();
    }

    public void updateReturnResultSentCount(Dialog dialog) {
        this.returnResultSentCount.addAndGet(1L);
        TCAPCounterEventsListener listener = this.provider.getStack().getTCAPCounterEventsListener();
        if (listener != null) {
            listener.updateReturnResultSentCount(dialog);
        }
    }

    public long getReturnResultLastReceivedCount() {
        return this.returnResultLastReceivedCount.get();
    }

    public void updateReturnResultLastReceivedCount(Dialog dialog) {
        this.returnResultLastReceivedCount.addAndGet(1L);
        TCAPCounterEventsListener listener = this.provider.getStack().getTCAPCounterEventsListener();
        if (listener != null) {
            listener.updateReturnResultLastReceivedCount(dialog);
        }
    }

    public long getReturnResultLastSentCount() {
        return this.returnResultLastSentCount.get();
    }

    public void updateReturnResultLastSentCount(Dialog dialog) {
        this.returnResultLastSentCount.addAndGet(1L);
        TCAPCounterEventsListener listener = this.provider.getStack().getTCAPCounterEventsListener();
        if (listener != null) {
            listener.updateReturnResultLastSentCount(dialog);
        }
    }

    public long getReturnErrorReceivedCount() {
        return this.returnErrorReceivedCount.get();
    }

    public void updateReturnErrorReceivedCount(Dialog dialog) {
        this.returnErrorReceivedCount.addAndGet(1L);
        TCAPCounterEventsListener listener = this.provider.getStack().getTCAPCounterEventsListener();
        if (listener != null) {
            listener.updateReturnErrorReceivedCount(dialog);
        }
    }

    public long getReturnErrorSentCount() {
        return this.returnErrorSentCount.get();
    }

    public void updateReturnErrorSentCount(Dialog dialog) {
        this.returnErrorSentCount.addAndGet(1L);
        TCAPCounterEventsListener listener = this.provider.getStack().getTCAPCounterEventsListener();
        if (listener != null) {
            listener.updateReturnErrorSentCount(dialog);
        }
    }

    public long getRejectReceivedCount() {
        return this.rejectReceivedCount.get();
    }

    public void updateRejectReceivedCount(Dialog dialog) {
        this.rejectReceivedCount.addAndGet(1L);
        TCAPCounterEventsListener listener = this.provider.getStack().getTCAPCounterEventsListener();
        if (listener != null) {
            listener.updateRejectReceivedCount(dialog);
        }
    }

    public long getRejectSentCount() {
        return this.rejectSentCount.get();
    }

    public void updateRejectSentCount(Dialog dialog) {
        this.rejectSentCount.addAndGet(1L);
        TCAPCounterEventsListener listener = this.provider.getStack().getTCAPCounterEventsListener();
        if (listener != null) {
            listener.updateRejectSentCount(dialog);
        }
    }

    public long getDialogTimeoutCount() {
        return this.dialogTimeoutCount.get();
    }

    public void updateDialogTimeoutCount(Dialog dialog) {
        this.dialogTimeoutCount.addAndGet(1L);
        TCAPCounterEventsListener listener = this.provider.getStack().getTCAPCounterEventsListener();
        if (listener != null) {
            listener.updateDialogTimeoutCount(dialog);
        }
    }

    public long getDialogReleaseCount() {
        return this.dialogReleaseCount.get();
    }

    public void updateDialogReleaseCount(Dialog dialog) {
        this.dialogReleaseCount.addAndGet(1L);
        TCAPCounterEventsListener listener = this.provider.getStack().getTCAPCounterEventsListener();
        if (listener != null) {
            listener.updateDialogReleaseCount(dialog);
        }
    }

    public long getCurrentDialogsCount() {
        return this.provider.getCurrentDialogsCount();
    }

    public long getAllEstablishedDialogsCount() {
        return this.allEstablishedDialogsCount.get();
    }

    public void updateAllEstablishedDialogsCount() {
        this.allEstablishedDialogsCount.addAndGet(1L);
    }

    public long getAllLocalEstablishedDialogsCount() {
        return this.allLocalEstablishedDialogsCount.get();
    }

    public void updateAllLocalEstablishedDialogsCount() {
        this.allLocalEstablishedDialogsCount.addAndGet(1L);
    }

    public long getAllRemoteEstablishedDialogsCount() {
        return this.allRemoteEstablishedDialogsCount.get();
    }

    public void updateAllRemoteEstablishedDialogsCount() {
        this.allRemoteEstablishedDialogsCount.addAndGet(1L);
    }

    public Long getMinDialogsCount(String compainName) {
        StatResult res = this.statDataCollection.restartAndGet(MIN_DIALOGS_COUNT, compainName);
        this.statDataCollection.updateData(MIN_DIALOGS_COUNT, (long)this.provider.getCurrentDialogsCount());
        if (res != null) {
            return res.getLongValue();
        }
        return null;
    }

    public void updateMinDialogsCount(long newVal) {
        this.statDataCollection.updateData(MIN_DIALOGS_COUNT, newVal);
    }

    public Long getMaxDialogsCount(String compainName) {
        StatResult res = this.statDataCollection.restartAndGet(MAX_DIALOGS_COUNT, compainName);
        this.statDataCollection.updateData(MAX_DIALOGS_COUNT, (long)this.provider.getCurrentDialogsCount());
        if (res != null) {
            return res.getLongValue();
        }
        return null;
    }

    public void updateMaxDialogsCount(long newVal) {
        this.statDataCollection.updateData(MAX_DIALOGS_COUNT, newVal);
    }

    public long getAllDialogsDuration() {
        return this.allDialogsDuration.get();
    }

    public void updateAllDialogsDuration(long diff) {
        this.allDialogsDuration.addAndGet(diff);
    }

    public Map<String, LongValue> getOutgoingDialogsPerApplicatioContextName(String compainName) {
        StatResult res = this.statDataCollection.restartAndGet(OUTGOING_DIALOGS_PER_APPLICATION_CONTEXT_NAME, compainName);
        this.statDataCollection.updateData(OUTGOING_DIALOGS_PER_APPLICATION_CONTEXT_NAME, (long)this.provider.getCurrentDialogsCount());
        if (res != null) {
            return res.getStringLongValue();
        }
        return null;
    }

    public void updateOutgoingDialogsPerApplicatioContextName(String name) {
        this.statDataCollection.updateData(OUTGOING_DIALOGS_PER_APPLICATION_CONTEXT_NAME, name);
    }

    public Map<String, LongValue> getIncomingDialogsPerApplicatioContextName(String compainName) {
        StatResult res = this.statDataCollection.restartAndGet(INCOMING_DIALOGS_PER_APPLICATION_CONTEXT_NAME, compainName);
        this.statDataCollection.updateData(INCOMING_DIALOGS_PER_APPLICATION_CONTEXT_NAME, (long)this.provider.getCurrentDialogsCount());
        if (res != null) {
            return res.getStringLongValue();
        }
        return null;
    }

    public void updateIncomingDialogsPerApplicatioContextName(String name) {
        this.statDataCollection.updateData(INCOMING_DIALOGS_PER_APPLICATION_CONTEXT_NAME, name);
    }

    public Map<String, LongValue> getOutgoingInvokesPerOperationCode(String compainName) {
        StatResult res = this.statDataCollection.restartAndGet(OUTGOING_INVOKES_PER_OPERATION_CODE, compainName);
        this.statDataCollection.updateData(OUTGOING_INVOKES_PER_OPERATION_CODE, (long)this.provider.getCurrentDialogsCount());
        if (res != null) {
            return res.getStringLongValue();
        }
        return null;
    }

    public void updateOutgoingInvokesPerOperationCode(String name) {
        this.statDataCollection.updateData(OUTGOING_INVOKES_PER_OPERATION_CODE, name);
    }

    public Map<String, LongValue> getIncomingInvokesPerOperationCode(String compainName) {
        StatResult res = this.statDataCollection.restartAndGet(INCOMING_INVOKES_PER_OPERATION_CODE, compainName);
        this.statDataCollection.updateData(INCOMING_INVOKES_PER_OPERATION_CODE, (long)this.provider.getCurrentDialogsCount());
        if (res != null) {
            return res.getStringLongValue();
        }
        return null;
    }

    public void updateIncomingInvokesPerOperationCode(String name) {
        this.statDataCollection.updateData(INCOMING_INVOKES_PER_OPERATION_CODE, name);
    }

    public Map<String, LongValue> getOutgoingErrorsPerErrorCode(String compainName) {
        StatResult res = this.statDataCollection.restartAndGet(OUTGOING_ERRORS_PER_ERROR_CODE, compainName);
        this.statDataCollection.updateData(OUTGOING_ERRORS_PER_ERROR_CODE, (long)this.provider.getCurrentDialogsCount());
        if (res != null) {
            return res.getStringLongValue();
        }
        return null;
    }

    public void updateOutgoingErrorsPerErrorCode(String name) {
        this.statDataCollection.updateData(OUTGOING_ERRORS_PER_ERROR_CODE, name);
    }

    public Map<String, LongValue> getIncomingErrorsPerErrorCode(String compainName) {
        StatResult res = this.statDataCollection.restartAndGet(INCOMING_ERRORS_PER_ERROR_CODE, compainName);
        this.statDataCollection.updateData(INCOMING_ERRORS_PER_ERROR_CODE, (long)this.provider.getCurrentDialogsCount());
        if (res != null) {
            return res.getStringLongValue();
        }
        return null;
    }

    public void updateIncomingErrorsPerErrorCode(String name) {
        this.statDataCollection.updateData(INCOMING_ERRORS_PER_ERROR_CODE, name);
    }

    public Map<String, LongValue> getOutgoingRejectPerProblem(String compainName) {
        StatResult res = this.statDataCollection.restartAndGet(OUTGOING_REJECT_PER_PROBLEM, compainName);
        this.statDataCollection.updateData(OUTGOING_REJECT_PER_PROBLEM, (long)this.provider.getCurrentDialogsCount());
        if (res != null) {
            return res.getStringLongValue();
        }
        return null;
    }

    public void updateOutgoingRejectPerProblem(String name) {
        this.statDataCollection.updateData(OUTGOING_REJECT_PER_PROBLEM, name);
    }

    public Map<String, LongValue> getIncomingRejectPerProblem(String compainName) {
        StatResult res = this.statDataCollection.restartAndGet(INCOMING_REJECT_PER_PROBLEM, compainName);
        this.statDataCollection.updateData(INCOMING_REJECT_PER_PROBLEM, (long)this.provider.getCurrentDialogsCount());
        if (res != null) {
            return res.getStringLongValue();
        }
        return null;
    }

    public void updateIncomingRejectPerProblem(String name) {
        this.statDataCollection.updateData(INCOMING_REJECT_PER_PROBLEM, name);
    }

    public Long getMaxNetworkIdAreasNotAvailable(String compainName) {
        StatResult res = this.statDataCollection.restartAndGet(MAX_NETWORK_ID_AREAS_NOT_AVAILABLE, compainName);
        this.statDataCollection.updateData(MAX_NETWORK_ID_AREAS_NOT_AVAILABLE, (long)this.provider.getNetworkIdAreasNotAvailableCount());
        if (res != null) {
            return res.getLongValue();
        }
        return null;
    }

    public void updateMaxNetworkIdAreasNotAvailable(long newVal) {
        this.statDataCollection.updateData(MAX_NETWORK_ID_AREAS_NOT_AVAILABLE, newVal);
    }

    public Long getMaxNetworkIdAreasCongLevel_1(String compainName) {
        StatResult res = this.statDataCollection.restartAndGet(MAX_NETWORK_ID_AREAS_CONGLEVEL_1, compainName);
        this.statDataCollection.updateData(MAX_NETWORK_ID_AREAS_CONGLEVEL_1, (long)this.provider.getNetworkIdAreasCongLevel_1_Count());
        if (res != null) {
            return res.getLongValue();
        }
        return null;
    }

    public void updateMaxNetworkIdAreasCongLevel_1(long newVal) {
        this.statDataCollection.updateData(MAX_NETWORK_ID_AREAS_CONGLEVEL_1, newVal);
    }

    public Long getMaxNetworkIdAreasCongLevel_2(String compainName) {
        StatResult res = this.statDataCollection.restartAndGet(MAX_NETWORK_ID_AREAS_CONGLEVEL_2, compainName);
        this.statDataCollection.updateData(MAX_NETWORK_ID_AREAS_CONGLEVEL_2, (long)this.provider.getNetworkIdAreasCongLevel_2_Count());
        if (res != null) {
            return res.getLongValue();
        }
        return null;
    }

    public void updateMaxNetworkIdAreasCongLevel_2(long newVal) {
        this.statDataCollection.updateData(MAX_NETWORK_ID_AREAS_CONGLEVEL_2, newVal);
    }

    public Long getMaxNetworkIdAreasCongLevel_3(String compainName) {
        StatResult res = this.statDataCollection.restartAndGet(MAX_NETWORK_ID_AREAS_CONGLEVEL_3, compainName);
        this.statDataCollection.updateData(MAX_NETWORK_ID_AREAS_CONGLEVEL_3, (long)this.provider.getNetworkIdAreasCongLevel_3_Count());
        if (res != null) {
            return res.getLongValue();
        }
        return null;
    }

    public void updateMaxNetworkIdAreasCongLevel_3(long newVal) {
        this.statDataCollection.updateData(MAX_NETWORK_ID_AREAS_CONGLEVEL_3, newVal);
    }

    public Long getMaxExecutorsCongLevel_1(String compainName) {
        StatResult res = this.statDataCollection.restartAndGet(MAX_EXECUTORS_CONG_LEVEL_1, compainName);
        this.statDataCollection.updateData(MAX_EXECUTORS_CONG_LEVEL_1, (long)this.provider.getExecutorCountWithCongestionLevel_1());
        if (res != null) {
            return res.getLongValue();
        }
        return null;
    }

    public void updateMaxExecutorsCongLevel_1(long newVal) {
        this.statDataCollection.updateData(MAX_EXECUTORS_CONG_LEVEL_1, newVal);
    }

    public Long getMaxExecutorsCongLevel_2(String compainName) {
        StatResult res = this.statDataCollection.restartAndGet(MAX_EXECUTORS_CONG_LEVEL_2, compainName);
        this.statDataCollection.updateData(MAX_EXECUTORS_CONG_LEVEL_2, (long)this.provider.getExecutorCountWithCongestionLevel_2());
        if (res != null) {
            return res.getLongValue();
        }
        return null;
    }

    public void updateMaxExecutorsCongLevel_2(long newVal) {
        this.statDataCollection.updateData(MAX_EXECUTORS_CONG_LEVEL_2, newVal);
    }

    public Long getMaxExecutorsCongLevel_3(String compainName) {
        StatResult res = this.statDataCollection.restartAndGet(MAX_EXECUTORS_CONG_LEVEL_3, compainName);
        this.statDataCollection.updateData(MAX_EXECUTORS_CONG_LEVEL_3, (long)this.provider.getExecutorCountWithCongestionLevel_3());
        if (res != null) {
            return res.getLongValue();
        }
        return null;
    }

    public void updateMaxExecutorsCongLevel_3(long newVal) {
        this.statDataCollection.updateData(MAX_EXECUTORS_CONG_LEVEL_3, newVal);
    }

    public Long getMaxMemoryCongLevel(String compainName) {
        StatResult res = this.statDataCollection.restartAndGet(MAX_MEMORY_CONG_LEVEL, compainName);
        this.statDataCollection.updateData(MAX_MEMORY_CONG_LEVEL, (long)this.provider.getMemoryCongestionLevel());
        if (res != null) {
            return res.getLongValue();
        }
        return null;
    }

    public void updateMaxMemoryCongLevel(long newVal) {
        this.statDataCollection.updateData(MAX_MEMORY_CONG_LEVEL, newVal);
    }

    public Long getMaxUserPartsCongLevel_1(String compainName) {
        StatResult res = this.statDataCollection.restartAndGet(MAX_USER_PARTS_CONG_LEVEL_1, compainName);
        this.statDataCollection.updateData(MAX_USER_PARTS_CONG_LEVEL_1, (long)this.provider.getUserPartCongestionLevel_1());
        if (res != null) {
            return res.getLongValue();
        }
        return null;
    }

    public void updateMaxUserPartsCongLevel_1(long newVal) {
        this.statDataCollection.updateData(MAX_USER_PARTS_CONG_LEVEL_1, newVal);
    }

    public Long getMaxUserPartsCongLevel_2(String compainName) {
        StatResult res = this.statDataCollection.restartAndGet(MAX_USER_PARTS_CONG_LEVEL_2, compainName);
        this.statDataCollection.updateData(MAX_USER_PARTS_CONG_LEVEL_2, (long)this.provider.getUserPartCongestionLevel_2());
        if (res != null) {
            return res.getLongValue();
        }
        return null;
    }

    public void updateMaxUserPartsCongLevel_2(long newVal) {
        this.statDataCollection.updateData(MAX_USER_PARTS_CONG_LEVEL_2, newVal);
    }

    public Long getMaxUserPartsCongLevel_3(String compainName) {
        StatResult res = this.statDataCollection.restartAndGet(MAX_USER_PARTS_CONG_LEVEL_3, compainName);
        this.statDataCollection.updateData(MAX_USER_PARTS_CONG_LEVEL_3, (long)this.provider.getUserPartCongestionLevel_3());
        if (res != null) {
            return res.getLongValue();
        }
        return null;
    }

    public void updateMaxUserPartsCongLevel_3(long newVal) {
        this.statDataCollection.updateData(MAX_USER_PARTS_CONG_LEVEL_3, newVal);
    }
}

