/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.impl.router;

import java.util.HashMap;
import java.util.Map;
import javolution.util.FastMap;
import javolution.xml.XMLFormat;
import javolution.xml.XMLSerializable;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.ss7.sccp.Mtp3Destination;
import org.mobicents.protocols.ss7.sccp.Mtp3ServiceAccessPoint;
import org.mobicents.protocols.ss7.sccp.impl.router.Mtp3DestinationImpl;
import org.mobicents.protocols.ss7.sccp.impl.router.Mtp3DestinationMap;

public class Mtp3ServiceAccessPointImpl
implements Mtp3ServiceAccessPoint,
XMLSerializable {
    private static final String MTP3_ID = "mtp3Id";
    private static final String OPC = "opc";
    private static final String NI = "ni";
    private static final String NETWORK_ID = "networkId";
    private int mtp3Id;
    private int opc;
    private int ni;
    private String stackName;
    private int networkId;
    private Mtp3DestinationMap<Integer, Mtp3Destination> dpcList = new Mtp3DestinationMap();
    protected static final XMLFormat<Mtp3ServiceAccessPointImpl> XML = new XMLFormat<Mtp3ServiceAccessPointImpl>(Mtp3ServiceAccessPointImpl.class){

        public void write(Mtp3ServiceAccessPointImpl sap, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(Mtp3ServiceAccessPointImpl.MTP3_ID, sap.mtp3Id);
            xml.setAttribute(Mtp3ServiceAccessPointImpl.OPC, sap.opc);
            xml.setAttribute(Mtp3ServiceAccessPointImpl.NI, sap.ni);
            xml.setAttribute(Mtp3ServiceAccessPointImpl.NETWORK_ID, sap.networkId);
            xml.add((Object)sap.dpcList);
        }

        public void read(XMLFormat.InputElement xml, Mtp3ServiceAccessPointImpl sap) throws XMLStreamException {
            sap.mtp3Id = xml.getAttribute(Mtp3ServiceAccessPointImpl.MTP3_ID).toInt();
            sap.opc = xml.getAttribute(Mtp3ServiceAccessPointImpl.OPC).toInt();
            sap.ni = xml.getAttribute(Mtp3ServiceAccessPointImpl.NI).toInt();
            sap.networkId = xml.getAttribute(Mtp3ServiceAccessPointImpl.NETWORK_ID, 0);
            sap.dpcList = (Mtp3DestinationMap)((Object)xml.getNext());
        }
    };

    public Mtp3ServiceAccessPointImpl() {
    }

    public Mtp3ServiceAccessPointImpl(int mtp3Id, int opc, int ni, String stackName, int networkId) {
        this.mtp3Id = mtp3Id;
        this.opc = opc;
        this.ni = ni;
        this.stackName = stackName;
        this.networkId = networkId;
    }

    protected void setStackName(String stackName) {
        this.stackName = stackName;
    }

    public int getMtp3Id() {
        return this.mtp3Id;
    }

    public int getOpc() {
        return this.opc;
    }

    public int getNi() {
        return this.ni;
    }

    public int getNetworkId() {
        return this.networkId;
    }

    public Mtp3Destination getMtp3Destination(int destId) {
        return (Mtp3Destination)this.dpcList.get(destId);
    }

    public Map<Integer, Mtp3Destination> getMtp3Destinations() {
        HashMap<Integer, Mtp3Destination> dpcListTmp = new HashMap<Integer, Mtp3Destination>();
        dpcListTmp.putAll((Map<Integer, Mtp3Destination>)((Object)this.dpcList));
        return dpcListTmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMtp3Destination(int destId, int firstDpc, int lastDpc, int firstSls, int lastSls, int slsMask) throws Exception {
        if (this.getMtp3Destination(destId) != null) {
            throw new Exception("Destination definition already exists");
        }
        Mtp3DestinationImpl dest = new Mtp3DestinationImpl(firstDpc, lastDpc, firstSls, lastSls, slsMask);
        Mtp3ServiceAccessPointImpl mtp3ServiceAccessPointImpl = this;
        synchronized (mtp3ServiceAccessPointImpl) {
            Mtp3DestinationMap newDpcList = new Mtp3DestinationMap();
            newDpcList.putAll((Map)((Object)this.dpcList));
            newDpcList.put(destId, dest);
            this.dpcList = newDpcList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyMtp3Destination(int destId, int firstDpc, int lastDpc, int firstSls, int lastSls, int slsMask) throws Exception {
        if (this.getMtp3Destination(destId) == null) {
            throw new Exception(String.format("Destination definition doesn't exist on stack=%s", this.stackName));
        }
        Mtp3DestinationImpl dest = new Mtp3DestinationImpl(firstDpc, lastDpc, firstSls, lastSls, slsMask);
        Mtp3ServiceAccessPointImpl mtp3ServiceAccessPointImpl = this;
        synchronized (mtp3ServiceAccessPointImpl) {
            Mtp3DestinationMap newDpcList = new Mtp3DestinationMap();
            newDpcList.putAll((Map)((Object)this.dpcList));
            newDpcList.put(destId, dest);
            this.dpcList = newDpcList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMtp3Destination(int destId) throws Exception {
        if (this.getMtp3Destination(destId) == null) {
            throw new Exception(String.format("Destination definition doesn't exist on stack=%s", this.stackName));
        }
        Mtp3ServiceAccessPointImpl mtp3ServiceAccessPointImpl = this;
        synchronized (mtp3ServiceAccessPointImpl) {
            Mtp3DestinationMap newDpcList = new Mtp3DestinationMap();
            newDpcList.putAll((Map)((Object)this.dpcList));
            newDpcList.remove(destId);
            this.dpcList = newDpcList;
        }
    }

    public boolean matches(int dpc, int sls) {
        FastMap.Entry e = this.dpcList.head();
        FastMap.Entry end = this.dpcList.tail();
        while ((e = e.getNext()) != end) {
            if (!((Mtp3Destination)e.getValue()).match(dpc, sls)) continue;
            return true;
        }
        return false;
    }

    public boolean matches(int dpc) {
        FastMap.Entry e = this.dpcList.head();
        FastMap.Entry end = this.dpcList.tail();
        while ((e = e.getNext()) != end) {
            if (!((Mtp3Destination)e.getValue()).match(dpc)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("mtp3Id=").append(this.mtp3Id).append(", opc=").append(this.opc).append(", ni=").append(this.ni).append(", networkId=").append(this.networkId).append(", dpcList=[");
        boolean isFirst = true;
        FastMap.Entry e = this.dpcList.head();
        FastMap.Entry end = this.dpcList.tail();
        while ((e = e.getNext()) != end) {
            Integer id = (Integer)e.getKey();
            Mtp3Destination dest = (Mtp3Destination)e.getValue();
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append("[key=");
            sb.append(id);
            sb.append(", ");
            sb.append(dest.toString());
            sb.append("], ");
        }
        sb.append("]");
        return sb.toString();
    }
}

