/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.impl.router;

import javolution.xml.XMLFormat;
import javolution.xml.XMLSerializable;
import javolution.xml.stream.XMLStreamException;

public class Mtp3Destination
implements XMLSerializable {
    private static final String FIRST_DPC = "firstDpc";
    private static final String LAST_DPC = "lastDpc";
    private static final String FIRST_SLS = "firstSls";
    private static final String LAST_SLS = "lastSls";
    private static final String SLS_MASK = "slsMask";
    private int firstDpc;
    private int lastDpc;
    private int firstSls;
    private int lastSls;
    private int slsMask;
    protected static final XMLFormat<Mtp3Destination> XML = new XMLFormat<Mtp3Destination>(Mtp3Destination.class){

        public void write(Mtp3Destination dest, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(Mtp3Destination.FIRST_DPC, dest.firstDpc);
            xml.setAttribute(Mtp3Destination.LAST_DPC, dest.lastDpc);
            xml.setAttribute(Mtp3Destination.FIRST_SLS, dest.firstSls);
            xml.setAttribute(Mtp3Destination.LAST_SLS, dest.lastSls);
            xml.setAttribute(Mtp3Destination.SLS_MASK, dest.slsMask);
        }

        public void read(XMLFormat.InputElement xml, Mtp3Destination dest) throws XMLStreamException {
            dest.firstDpc = xml.getAttribute(Mtp3Destination.FIRST_DPC).toInt();
            dest.lastDpc = xml.getAttribute(Mtp3Destination.LAST_DPC).toInt();
            dest.firstSls = xml.getAttribute(Mtp3Destination.FIRST_SLS).toInt();
            dest.lastSls = xml.getAttribute(Mtp3Destination.LAST_SLS).toInt();
            dest.slsMask = xml.getAttribute(Mtp3Destination.SLS_MASK).toInt();
        }
    };

    public Mtp3Destination() {
    }

    public Mtp3Destination(int firstDpc, int lastDpc, int firstSls, int lastSls, int slsMask) {
        this.firstDpc = firstDpc;
        this.lastDpc = lastDpc;
        this.firstSls = firstSls;
        this.lastSls = lastSls;
        this.slsMask = slsMask;
    }

    public int getFirstDpc() {
        return this.firstDpc;
    }

    public int getLastDpc() {
        return this.lastDpc;
    }

    public int getFirstSls() {
        return this.firstSls;
    }

    public int getLastSls() {
        return this.lastSls;
    }

    public int getSlsMask() {
        return this.slsMask;
    }

    public boolean match(int dpc, int sls) {
        return dpc >= this.firstDpc && dpc <= this.lastDpc && (sls &= this.slsMask) >= this.firstSls && sls <= this.lastSls;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("firstDpc=").append(this.firstDpc).append(", lastDpc=").append(this.lastDpc).append(", firstSls=").append(this.firstSls).append(", lastSls=").append(this.lastSls).append(", slsMask=").append(this.slsMask);
        return sb.toString();
    }
}

