/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.impl.parameter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mobicents.protocols.ss7.sccp.SccpProtocolVersion;
import org.mobicents.protocols.ss7.sccp.impl.parameter.AbstractParameter;
import org.mobicents.protocols.ss7.sccp.message.ParseException;
import org.mobicents.protocols.ss7.sccp.parameter.ParameterFactory;
import org.mobicents.protocols.ss7.sccp.parameter.SequencingSegmenting;

public class SequencingSegmentingImpl
extends AbstractParameter
implements SequencingSegmenting {
    private byte sendSequenceNumber;
    private byte receiveSequenceNumber;
    private boolean moreData;

    public SequencingSegmentingImpl() {
    }

    public SequencingSegmentingImpl(int sendSequenceNumber, int receiveSequenceNumber, boolean moreData) {
        this.sendSequenceNumber = (byte)sendSequenceNumber;
        this.receiveSequenceNumber = (byte)receiveSequenceNumber;
        this.moreData = moreData;
    }

    public int getSendSequenceNumber() {
        return this.sendSequenceNumber;
    }

    public int getReceiveSequenceNumber() {
        return this.receiveSequenceNumber;
    }

    public boolean isMoreData() {
        return false;
    }

    @Override
    public void decode(InputStream in, ParameterFactory factory, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            if (in.read() != 2) {
                throw new ParseException();
            }
            this.sendSequenceNumber = (byte)(in.read() >> 1 & 0x7F);
            int secondOctet = in.read();
            this.receiveSequenceNumber = (byte)(secondOctet >> 1 & 0x7F);
            this.moreData = (secondOctet & 1) == 1;
        }
        catch (IOException ioe) {
            throw new ParseException((Throwable)ioe);
        }
    }

    @Override
    public void encode(OutputStream os, boolean removeSpc, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            os.write(2);
            os.write(this.sendSequenceNumber << 1 & 0xFE);
            os.write(this.receiveSequenceNumber << 1 & 0xFE | (this.moreData ? 1 : 0));
        }
        catch (IOException ioe) {
            throw new ParseException((Throwable)ioe);
        }
    }

    @Override
    public void decode(byte[] b, ParameterFactory factory, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        if (b.length < 2) {
            throw new ParseException();
        }
        this.sendSequenceNumber = (byte)(b[0] >> 1 & 0x7F);
        this.receiveSequenceNumber = (byte)(b[1] >> 1 & 0x7F);
        this.moreData = (b[1] & 1) == 1;
    }

    @Override
    public byte[] encode(boolean removeSpc, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        return new byte[]{(byte)(this.sendSequenceNumber << 1 & 0xFE), (byte)(this.receiveSequenceNumber << 1 & 0xFE | (this.moreData ? 1 : 0))};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SequencingSegmentingImpl that = (SequencingSegmentingImpl)o;
        if (this.sendSequenceNumber != that.sendSequenceNumber) {
            return false;
        }
        if (this.receiveSequenceNumber != that.receiveSequenceNumber) {
            return false;
        }
        return this.moreData == that.moreData;
    }

    public int hashCode() {
        int result = this.sendSequenceNumber;
        result = 31 * result + this.receiveSequenceNumber;
        result = 31 * result + (this.moreData ? 1 : 0);
        return result;
    }
}

