/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.impl.parameter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mobicents.protocols.ss7.sccp.SccpProtocolVersion;
import org.mobicents.protocols.ss7.sccp.impl.parameter.AbstractParameter;
import org.mobicents.protocols.ss7.sccp.message.ParseException;
import org.mobicents.protocols.ss7.sccp.parameter.ParameterFactory;
import org.mobicents.protocols.ss7.sccp.parameter.ResetCause;
import org.mobicents.protocols.ss7.sccp.parameter.ResetCauseValue;

public class ResetCauseImpl
extends AbstractParameter
implements ResetCause {
    private ResetCauseValue value;
    private int digValue;

    public ResetCauseImpl() {
        this.value = ResetCauseValue.UNQUALIFIED;
        this.digValue = this.value.getValue();
    }

    public ResetCauseImpl(ResetCauseValue value) {
        this.value = value;
        if (value != null) {
            this.digValue = value.getValue();
        }
    }

    public ResetCauseImpl(int digValue) {
        this.digValue = digValue;
        this.value = ResetCauseValue.getInstance((int)digValue);
    }

    public ResetCauseValue getValue() {
        return this.value;
    }

    public int getDigitalValue() {
        return this.digValue;
    }

    @Override
    public void decode(InputStream in, ParameterFactory factory, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            if (in.read() != 1) {
                throw new ParseException();
            }
            this.digValue = in.read();
            this.value = ResetCauseValue.getInstance((int)this.digValue);
        }
        catch (IOException ioe) {
            throw new ParseException((Throwable)ioe);
        }
    }

    @Override
    public void encode(OutputStream os, boolean removeSpc, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            os.write(1);
            os.write(this.digValue);
        }
        catch (IOException ioe) {
            throw new ParseException((Throwable)ioe);
        }
    }

    @Override
    public void decode(byte[] b, ParameterFactory factory, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        if (b.length < 1) {
            throw new ParseException();
        }
        this.digValue = b[0];
        this.value = ResetCauseValue.getInstance((int)this.digValue);
    }

    @Override
    public byte[] encode(boolean removeSpc, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        return new byte[]{(byte)this.digValue};
    }

    public String toString() {
        if (this.value != null) {
            return this.value.toString();
        }
        return Integer.valueOf(this.digValue).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResetCauseImpl that = (ResetCauseImpl)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return this.digValue;
    }
}

