/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.impl.parameter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mobicents.protocols.ss7.sccp.SccpProtocolVersion;
import org.mobicents.protocols.ss7.sccp.impl.parameter.AbstractParameter;
import org.mobicents.protocols.ss7.sccp.message.ParseException;
import org.mobicents.protocols.ss7.sccp.parameter.ParameterFactory;
import org.mobicents.protocols.ss7.sccp.parameter.ProtocolClass;

public class ProtocolClassImpl
extends AbstractParameter
implements ProtocolClass {
    private int pClass;
    private int msgHandling;

    public ProtocolClassImpl() {
    }

    public ProtocolClassImpl(int pClass) {
        if (pClass != 2 && pClass != 3) {
            throw new IllegalStateException("This constructor is only for protocol class 2 or 3");
        }
        this.pClass = pClass;
    }

    public ProtocolClassImpl(int pClass, boolean returnMessageOnError) {
        this.pClass = pClass;
        this.msgHandling = pClass == 0 || pClass == 1 ? (returnMessageOnError ? 8 : 0) : 0;
    }

    public int getProtocolClass() {
        return this.pClass;
    }

    public boolean getReturnMessageOnError() {
        if (this.pClass != 0 && this.pClass != 1) {
            throw new IllegalArgumentException("Protocol class 0 or 1 is required");
        }
        return (this.msgHandling & 8) != 0;
    }

    public void clearReturnMessageOnError() {
        if (this.pClass != 0 && this.pClass != 1) {
            throw new IllegalArgumentException("Protocol class 0 or 1 is required");
        }
        int mask = -9;
        this.msgHandling &= mask;
    }

    @Override
    public void decode(InputStream in, ParameterFactory factory, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            if (in.read() != 1) {
                throw new ParseException();
            }
            int b = in.read() & 0xFF;
            this.pClass = b & 0xF;
            this.msgHandling = (b & 0xF0) >> 4;
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
    }

    @Override
    public void encode(OutputStream out, boolean removeSpc, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            byte b = (byte)(this.pClass | this.msgHandling << 4);
            out.write(1);
            out.write(b);
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
    }

    @Override
    public void decode(byte[] bb, ParameterFactory factory, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        int b = bb[0] & 0xFF;
        this.pClass = b & 0xF;
        this.msgHandling = (b & 0xF0) >> 4;
    }

    @Override
    public byte[] encode(boolean removeSpc, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        return new byte[]{(byte)(this.pClass | this.msgHandling << 4)};
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.msgHandling;
        result = 31 * result + this.pClass;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProtocolClassImpl other = (ProtocolClassImpl)obj;
        if (this.msgHandling != other.msgHandling) {
            return false;
        }
        return this.pClass == other.pClass;
    }

    public String toString() {
        return "ProtocolClass [msgHandling=" + this.msgHandling + ", pClass=" + this.pClass + "]";
    }
}

