/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.impl.oam;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javolution.util.FastMap;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.indicator.AddressIndicator;
import org.mobicents.protocols.ss7.indicator.NatureOfAddress;
import org.mobicents.protocols.ss7.indicator.NumberingPlan;
import org.mobicents.protocols.ss7.sccp.ConcernedSignalingPointCode;
import org.mobicents.protocols.ss7.sccp.LoadSharingAlgorithm;
import org.mobicents.protocols.ss7.sccp.LongMessageRule;
import org.mobicents.protocols.ss7.sccp.LongMessageRuleType;
import org.mobicents.protocols.ss7.sccp.Mtp3Destination;
import org.mobicents.protocols.ss7.sccp.Mtp3ServiceAccessPoint;
import org.mobicents.protocols.ss7.sccp.OriginationType;
import org.mobicents.protocols.ss7.sccp.RemoteSignalingPointCode;
import org.mobicents.protocols.ss7.sccp.RemoteSubSystem;
import org.mobicents.protocols.ss7.sccp.Rule;
import org.mobicents.protocols.ss7.sccp.RuleType;
import org.mobicents.protocols.ss7.sccp.SccpCongestionControlAlgo;
import org.mobicents.protocols.ss7.sccp.SccpProtocolVersion;
import org.mobicents.protocols.ss7.sccp.impl.SccpStackImpl;
import org.mobicents.protocols.ss7.sccp.impl.parameter.SccpAddressImpl;
import org.mobicents.protocols.ss7.sccp.parameter.GlobalTitle;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;
import org.mobicents.ss7.management.console.ShellExecutor;

public class SccpExecutor
implements ShellExecutor {
    private static final Logger logger = Logger.getLogger(SccpExecutor.class);
    private FastMap<String, SccpStackImpl> sccpStacks = new FastMap();
    private SccpStackImpl sccpStack = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSccpStacks(Map<String, SccpStackImpl> sccpStacksTemp) {
        if (sccpStacksTemp != null) {
            SccpExecutor sccpExecutor = this;
            synchronized (sccpExecutor) {
                FastMap newSccpStacks = new FastMap();
                newSccpStacks.putAll(sccpStacksTemp);
                this.sccpStacks = newSccpStacks;
            }
        }
    }

    private void setDefaultValue() {
        if (this.sccpStack == null) {
            Map.Entry sccpStacksTmp = (Map.Entry)this.sccpStacks.entrySet().iterator().next();
            this.sccpStack = (SccpStackImpl)sccpStacksTmp.getValue();
        }
    }

    public Map<String, SccpStackImpl> getSccpStacks() {
        return this.sccpStacks;
    }

    public String execute(String[] options) {
        if (this.sccpStacks.size() == 0) {
            logger.warn((Object)"SCCP stack not set. Command will not be executed ");
            return "Server Error";
        }
        if (options == null || options.length < 2) {
            return "Invalid Command";
        }
        String firstOption = options[1];
        if (firstOption == null) {
            return "Invalid Command";
        }
        try {
            if (firstOption.equals("rule")) {
                return this.manageRule(options);
            }
            if (firstOption.equals("address")) {
                return this.manageAddress(options);
            }
            if (firstOption.equals("rsp")) {
                return this.manageRsp(options);
            }
            if (firstOption.equals("rss")) {
                return this.manageRss(options);
            }
            if (firstOption.equals("lmr")) {
                return this.manageLmr(options);
            }
            if (firstOption.equals("sap")) {
                return this.manageSap(options);
            }
            if (firstOption.equals("dest")) {
                return this.manageDest(options);
            }
            if (firstOption.equals("csp")) {
                return this.manageConcernedSpc(options);
            }
            if (firstOption.equals("set")) {
                return this.manageSet(options);
            }
            if (firstOption.equals("get")) {
                return this.manageGet(options);
            }
        }
        catch (Throwable t) {
            logger.error((Object)String.format("Error while executing comand %s", Arrays.toString(options)), t);
            return t.getMessage();
        }
        return "Invalid Command";
    }

    private String manageRss(String[] options) throws Exception {
        if (options.length < 3) {
            return "Invalid Command";
        }
        String command = options[2];
        if (command == null) {
            return "Invalid Command";
        }
        if (command.equals("create")) {
            if (options.length < 7) {
                return "Invalid Command";
            }
            int remoteSsId = Integer.parseInt(options[3]);
            int remoteSpc = Integer.parseInt(options[4]);
            int remoteSs = Integer.parseInt(options[5]);
            int remoteSsFlag = Integer.parseInt(options[6]);
            boolean markProhibitedWhenSpcResuming = false;
            int count = 7;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = (SccpStackImpl)this.sccpStacks.get((Object)(m3uaStackName = options[count++]))) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                if (key.equals("prohibitedwhenspcresuming")) {
                    markProhibitedWhenSpcResuming = Boolean.parseBoolean(options[count++]);
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            this.sccpStack.getSccpResource().addRemoteSsn(remoteSsId, remoteSpc, remoteSs, remoteSsFlag, markProhibitedWhenSpcResuming);
            return String.format("Remote Subsystem successfully added on stack=%s", this.sccpStack.getName());
        }
        if (command.equals("modify")) {
            if (options.length < 7) {
                return "Invalid Command";
            }
            int remoteSsId = Integer.parseInt(options[3]);
            int remoteSpc = Integer.parseInt(options[4]);
            int remoteSs = Integer.parseInt(options[5]);
            int remoteSsFlag = Integer.parseInt(options[6]);
            boolean markProhibitedWhenSpcResuming = false;
            int count = 7;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = (SccpStackImpl)this.sccpStacks.get((Object)(m3uaStackName = options[count++]))) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                if (key.equals("prohibitedwhenspcresuming")) {
                    markProhibitedWhenSpcResuming = Boolean.parseBoolean(options[count++]);
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            this.sccpStack.getSccpResource().modifyRemoteSsn(remoteSsId, remoteSpc, remoteSs, remoteSsFlag, markProhibitedWhenSpcResuming);
            return String.format("Remote Subsystem successfully modified on stack=%s", this.sccpStack.getName());
        }
        if (command.equals("delete")) {
            if (options.length < 4) {
                return "Invalid Command";
            }
            int remoteSsId = Integer.parseInt(options[3]);
            int count = 4;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = (SccpStackImpl)this.sccpStacks.get((Object)(m3uaStackName = options[count++]))) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            this.sccpStack.getSccpResource().removeRemoteSsn(remoteSsId);
            return String.format("Remote Subsystem successfully deleted from stack=%s", this.sccpStack.getName());
        }
        if (command.equals("show")) {
            int count = 3;
            int remoteSsId = -1;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = (SccpStackImpl)this.sccpStacks.get((Object)(m3uaStackName = options[count++]))) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                if (key.equals("id")) {
                    remoteSsId = Integer.parseInt(options[count++]);
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            if (remoteSsId != -1) {
                RemoteSubSystem rss = this.sccpStack.getSccpResource().getRemoteSsn(remoteSsId);
                if (rss == null) {
                    return String.format("Remote Subsystem doesn't exist on stack=%s", this.sccpStack.getName());
                }
                return rss.toString();
            }
            if (this.sccpStack.getSccpResource().getRemoteSsns().size() == 0) {
                return String.format("Remote Subsystem doesn't exist on stack=%s", this.sccpStack.getName());
            }
            Map idVsRemoteSsn = this.sccpStack.getSccpResource().getRemoteSsns();
            StringBuffer sb = new StringBuffer();
            for (Integer e : idVsRemoteSsn.keySet()) {
                RemoteSubSystem rss = (RemoteSubSystem)idVsRemoteSsn.get(e);
                sb.append("key=");
                sb.append(e);
                sb.append("  ");
                sb.append(rss);
                sb.append("\n");
            }
            return sb.toString();
        }
        return "Invalid Command";
    }

    private String manageRsp(String[] options) throws Exception {
        if (options.length < 3) {
            return "Invalid Command";
        }
        String command = options[2];
        if (command == null) {
            return "Invalid Command";
        }
        if (command.equals("create")) {
            if (options.length < 7) {
                return "Invalid Command";
            }
            int remoteSpcId = Integer.parseInt(options[3]);
            int remoteSpc = Integer.parseInt(options[4]);
            int remoteSpcFlag = Integer.parseInt(options[5]);
            int mask = Integer.parseInt(options[6]);
            int count = 7;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = (SccpStackImpl)this.sccpStacks.get((Object)(m3uaStackName = options[count++]))) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            this.sccpStack.getSccpResource().addRemoteSpc(remoteSpcId, remoteSpc, remoteSpcFlag, mask);
            return String.format("Remote Signaling Pointcode successfully added on stack=%s", this.sccpStack.getName());
        }
        if (command.equals("modify")) {
            if (options.length < 7) {
                return "Invalid Command";
            }
            int remoteSpcId = Integer.parseInt(options[3]);
            int remoteSpc = Integer.parseInt(options[4]);
            int remoteSpcFlag = Integer.parseInt(options[5]);
            int mask = Integer.parseInt(options[6]);
            int count = 7;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = (SccpStackImpl)this.sccpStacks.get((Object)(m3uaStackName = options[count++]))) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            this.sccpStack.getSccpResource().modifyRemoteSpc(remoteSpcId, remoteSpc, remoteSpcFlag, mask);
            return String.format("Remote Signaling Pointcode successfully modified on stack=%s", this.sccpStack.getName());
        }
        if (command.equals("delete")) {
            if (options.length < 4) {
                return "Invalid Command";
            }
            int remoteSpcId = Integer.parseInt(options[3]);
            int count = 4;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = (SccpStackImpl)this.sccpStacks.get((Object)(m3uaStackName = options[count++]))) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            this.sccpStack.getSccpResource().removeRemoteSpc(remoteSpcId);
            return String.format("Remote Signaling Pointcode successfully deleted from stack=%s", this.sccpStack.getName());
        }
        if (command.equals("show")) {
            int count = 3;
            int remoteSpcId = -1;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = (SccpStackImpl)this.sccpStacks.get((Object)(m3uaStackName = options[count++]))) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                if (key.equals("id")) {
                    remoteSpcId = Integer.parseInt(options[count++]);
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            if (remoteSpcId != -1) {
                RemoteSignalingPointCode rspc = this.sccpStack.getSccpResource().getRemoteSpc(remoteSpcId);
                if (rspc == null) {
                    return String.format("Remote Signaling Pointcode doesn't exist on stack=%s", this.sccpStack.getName());
                }
                return rspc.toString();
            }
            if (this.sccpStack.getSccpResource().getRemoteSpcs().size() == 0) {
                return String.format("Remote Signaling Pointcode doesn't exist on stack=%s", this.sccpStack.getName());
            }
            StringBuffer sb = new StringBuffer();
            Map idVsRspc = this.sccpStack.getSccpResource().getRemoteSpcs();
            Set rspIds = idVsRspc.keySet();
            for (Integer e : rspIds) {
                RemoteSignalingPointCode rsp = (RemoteSignalingPointCode)idVsRspc.get(e);
                sb.append("key=");
                sb.append(e);
                sb.append("  ");
                sb.append(rsp);
                sb.append("\n");
            }
            return sb.toString();
        }
        return "Invalid Command";
    }

    private String manageAddress(String[] options) throws Exception {
        if (options.length < 3) {
            return "Invalid Command";
        }
        String command = options[2];
        if (command == null) {
            return "Invalid Command";
        }
        if (command.equals("create")) {
            if (options.length < 4) {
                return "Invalid Command";
            }
            int addressId = Integer.parseInt(options[3]);
            int count = 11;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = (SccpStackImpl)this.sccpStacks.get((Object)(m3uaStackName = options[count++]))) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            SccpAddress address = this.createAddress(options, 4, false);
            this.sccpStack.getRouter().addRoutingAddress(addressId, address);
            return String.format("Address successfully added on stack=%s", this.sccpStack.getName());
        }
        if (command.equals("modify")) {
            if (options.length < 4) {
                return "Invalid Command";
            }
            int addressId = Integer.parseInt(options[3]);
            int count = 11;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = (SccpStackImpl)this.sccpStacks.get((Object)(m3uaStackName = options[count++]))) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            SccpAddress address = this.createAddress(options, 4, false);
            this.sccpStack.getRouter().modifyRoutingAddress(addressId, address);
            return String.format("Address successfully modified on stack=%s", this.sccpStack.getName());
        }
        if (command.equals("delete")) {
            if (options.length < 4) {
                return "Invalid Command";
            }
            int addressId = Integer.parseInt(options[3]);
            int count = 4;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = (SccpStackImpl)this.sccpStacks.get((Object)(m3uaStackName = options[count++]))) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            this.sccpStack.getRouter().removeRoutingAddress(addressId);
            return String.format("Address successfully deleted from stack=%s", this.sccpStack.getName());
        }
        if (command.equals("show")) {
            int count = 3;
            int addressId = -1;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = (SccpStackImpl)this.sccpStacks.get((Object)(m3uaStackName = options[count++]))) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                if (key.equals("id")) {
                    addressId = Integer.parseInt(options[count++]);
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            if (addressId != -1) {
                SccpAddress pa = this.sccpStack.getRouter().getRoutingAddress(addressId);
                if (pa == null) {
                    return String.format("Address doesn't exist on stack=%s", this.sccpStack.getName());
                }
                return pa.toString();
            }
            if (this.sccpStack.getRouter().getRoutingAddresses().size() == 0) {
                return String.format("Address doesn't exist on stack=%s", this.sccpStack.getName());
            }
            StringBuffer sb = new StringBuffer();
            Map idVsPrimAdd = this.sccpStack.getRouter().getRoutingAddresses();
            for (Integer e : idVsPrimAdd.keySet()) {
                SccpAddress address = (SccpAddress)idVsPrimAdd.get(e);
                sb.append("key=");
                sb.append(e);
                sb.append("  ");
                sb.append(address);
                sb.append("\n");
            }
            return sb.toString();
        }
        return "Invalid Command";
    }

    private String manageRule(String[] options) throws Exception {
        if (options.length < 3) {
            return "Invalid Command";
        }
        String command = options[2];
        if (command == null) {
            return "Invalid Command";
        }
        if (command.equals("create")) {
            return this.createRule(options);
        }
        if (command.equals("modify")) {
            return this.modifyRule(options);
        }
        if (command.equals("delete")) {
            return this.deleteRule(options);
        }
        if (command.equals("show")) {
            return this.showRule(options);
        }
        return "Invalid Command";
    }

    private String createRule(String[] options) throws Exception {
        RuleType ruleType;
        if (options.length < 14 || options.length > 40) {
            return "Invalid Command";
        }
        int ruleId = Integer.parseInt(options[3]);
        String mask = options[4];
        if (mask == null) {
            return "Invalid Mask";
        }
        String s1 = options[12].toLowerCase();
        if (s1.equalsIgnoreCase(RuleType.SOLITARY.getValue())) {
            ruleType = RuleType.SOLITARY;
        } else if (s1.equalsIgnoreCase(RuleType.DOMINANT.getValue())) {
            ruleType = RuleType.DOMINANT;
        } else if (s1.equalsIgnoreCase(RuleType.LOADSHARED.getValue())) {
            ruleType = RuleType.LOADSHARED;
        } else if (s1.equals("broadcast")) {
            ruleType = RuleType.BROADCAST;
        } else {
            return "Invalid Command";
        }
        int pAddressId = Integer.parseInt(options[13]);
        int count = 14;
        int sAddressId = -1;
        Integer newcgpartyAddressId = null;
        LoadSharingAlgorithm algo = LoadSharingAlgorithm.Undefined;
        OriginationType originationType = OriginationType.ALL;
        int networkId = 0;
        int callingAI = -1;
        int callingPC = -1;
        int callingSSN = -1;
        int callingTT = -1;
        int callingNP = -1;
        int callingNAI = -1;
        String callingDigits = null;
        while (count < options.length) {
            String key;
            if ((key = options[count++]) == null) {
                return "Invalid Command";
            }
            if (key.equals("loadsharing-algo")) {
                algo = LoadSharingAlgorithm.getInstance((String)options[count++]);
                continue;
            }
            if (key.equals("backup-addressid")) {
                sAddressId = Integer.parseInt(options[count++]);
                continue;
            }
            if (key.equals("newcgparty-addressid")) {
                newcgpartyAddressId = Integer.parseInt(options[count++]);
                continue;
            }
            if (key.equals("origination-type")) {
                originationType = OriginationType.getInstance((String)options[count++]);
                continue;
            }
            if (key.equals("stackname")) {
                String m3uaStackName;
                SccpStackImpl sccpStaclImpl;
                if ((sccpStaclImpl = (SccpStackImpl)this.sccpStacks.get((Object)(m3uaStackName = options[count++]))) == null) {
                    return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                }
                this.sccpStack = sccpStaclImpl;
                continue;
            }
            if (key.equals("networkid")) {
                String networkIdS = options[count++];
                networkId = Integer.parseInt(networkIdS);
                continue;
            }
            if (key.equals("calling-ai")) {
                callingAI = Integer.parseInt(options[count++]);
                continue;
            }
            if (key.equals("calling-pc")) {
                callingPC = Integer.parseInt(options[count++]);
                continue;
            }
            if (key.equals("calling-ssn")) {
                callingSSN = Integer.parseInt(options[count++]);
                continue;
            }
            if (key.equals("calling-tt")) {
                callingTT = Integer.parseInt(options[count++]);
                continue;
            }
            if (key.equals("calling-np")) {
                callingNP = Integer.parseInt(options[count++]);
                continue;
            }
            if (key.equals("calling-nai")) {
                callingNAI = Integer.parseInt(options[count++]);
                continue;
            }
            if (key.equals("calling-digits-pattern")) {
                callingDigits = options[count++];
                continue;
            }
            return "Invalid Command";
        }
        this.setDefaultValue();
        SccpAddress pattern = this.createAddress(options, 5, true);
        SccpAddress callingPattern = null;
        if (callingDigits != null && !callingDigits.isEmpty()) {
            callingPattern = this.createAddress(callingAI, callingPC, callingSSN, callingTT, callingNP, callingNAI, callingDigits, true);
        }
        this.sccpStack.getRouter().addRule(ruleId, ruleType, algo, originationType, pattern, mask, pAddressId, sAddressId, newcgpartyAddressId, networkId, callingPattern);
        return String.format("Rule successfully added on stack=%s", this.sccpStack.getName());
    }

    private String modifyRule(String[] options) throws Exception {
        RuleType ruleType;
        if (options.length < 14 || options.length > 40) {
            return "Invalid Command";
        }
        int ruleId = Integer.parseInt(options[3]);
        String mask = options[4];
        if (mask == null) {
            return "Invalid Mask";
        }
        String s1 = options[12].toLowerCase();
        if (s1.equals("solitary")) {
            ruleType = RuleType.SOLITARY;
        } else if (s1.equals("dominant")) {
            ruleType = RuleType.DOMINANT;
        } else if (s1.equals("loadshared")) {
            ruleType = RuleType.LOADSHARED;
        } else if (s1.equals("broadcast")) {
            ruleType = RuleType.BROADCAST;
        } else {
            return "Invalid Command";
        }
        int pAddressId = Integer.parseInt(options[13]);
        int count = 14;
        int sAddressId = -1;
        Integer newcgpartyAddressId = null;
        LoadSharingAlgorithm algo = LoadSharingAlgorithm.Undefined;
        OriginationType originationType = OriginationType.ALL;
        int networkId = 0;
        int callingAI = -1;
        int callingPC = -1;
        int callingSSN = -1;
        int callingTT = -1;
        int callingNP = -1;
        int callingNAI = -1;
        String callingDigits = null;
        while (count < options.length) {
            String key;
            if ((key = options[count++]) == null) {
                return "Invalid Command";
            }
            if (key.equals("loadsharing-algo")) {
                algo = LoadSharingAlgorithm.getInstance((String)options[count++]);
                continue;
            }
            if (key.equals("backup-addressid")) {
                sAddressId = Integer.parseInt(options[count++]);
                continue;
            }
            if (key.equals("newcgparty-addressid")) {
                newcgpartyAddressId = Integer.parseInt(options[count++]);
                continue;
            }
            if (key.equals("origination-type")) {
                originationType = OriginationType.getInstance((String)options[count++]);
                continue;
            }
            if (key.equals("stackname")) {
                String m3uaStackName;
                SccpStackImpl sccpStaclImpl;
                if ((sccpStaclImpl = (SccpStackImpl)this.sccpStacks.get((Object)(m3uaStackName = options[count++]))) == null) {
                    return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                }
                this.sccpStack = sccpStaclImpl;
                continue;
            }
            if (key.equals("networkid")) {
                String networkIdS = options[count++];
                networkId = Integer.parseInt(networkIdS);
                continue;
            }
            if (key.equals("calling-ai")) {
                callingAI = Integer.parseInt(options[count++]);
                continue;
            }
            if (key.equals("calling-pc")) {
                callingPC = Integer.parseInt(options[count++]);
                continue;
            }
            if (key.equals("calling-ssn")) {
                callingSSN = Integer.parseInt(options[count++]);
                continue;
            }
            if (key.equals("calling-tt")) {
                callingTT = Integer.parseInt(options[count++]);
                continue;
            }
            if (key.equals("calling-np")) {
                callingNP = Integer.parseInt(options[count++]);
                continue;
            }
            if (key.equals("calling-nai")) {
                callingNAI = Integer.parseInt(options[count++]);
                continue;
            }
            if (key.equals("calling-digits-pattern")) {
                callingDigits = options[count++];
                continue;
            }
            return "Invalid Command";
        }
        this.setDefaultValue();
        SccpAddress pattern = this.createAddress(options, 5, true);
        SccpAddress callingPattern = null;
        if (callingDigits != null && !callingDigits.isEmpty()) {
            callingPattern = this.createAddress(callingAI, callingPC, callingSSN, callingTT, callingNP, callingNAI, callingDigits, true);
        }
        this.sccpStack.getRouter().modifyRule(ruleId, ruleType, algo, originationType, pattern, mask, pAddressId, sAddressId, newcgpartyAddressId, networkId, callingPattern);
        return String.format("Rule successfully modified on stack=%s", this.sccpStack.getName());
    }

    private String deleteRule(String[] options) throws Exception {
        if (options.length < 4) {
            return "Invalid Command";
        }
        int ruleId = Integer.parseInt(options[3]);
        int count = 4;
        while (count < options.length) {
            String key;
            if ((key = options[count++]) == null) {
                return "Invalid Command";
            }
            if (key.equals("stackname")) {
                String m3uaStackName;
                SccpStackImpl sccpStaclImpl;
                if ((sccpStaclImpl = (SccpStackImpl)this.sccpStacks.get((Object)(m3uaStackName = options[count++]))) == null) {
                    return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                }
                this.sccpStack = sccpStaclImpl;
                continue;
            }
            return "Invalid Command";
        }
        this.setDefaultValue();
        this.sccpStack.getRouter().removeRule(ruleId);
        return String.format("Rule successfully removed from stack=%s", this.sccpStack.getName());
    }

    private String showRule(String[] options) throws Exception {
        if (options.length < 3) {
            return "Invalid Command";
        }
        int count = 3;
        int ruleId = -1;
        while (count < options.length) {
            String key;
            if ((key = options[count++]) == null) {
                return "Invalid Command";
            }
            if (key.equals("stackname")) {
                String m3uaStackName;
                SccpStackImpl sccpStaclImpl;
                if ((sccpStaclImpl = (SccpStackImpl)this.sccpStacks.get((Object)(m3uaStackName = options[count++]))) == null) {
                    return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                }
                this.sccpStack = sccpStaclImpl;
                continue;
            }
            if (key.equals("id")) {
                ruleId = Integer.parseInt(options[count++]);
                continue;
            }
            return "Invalid Command";
        }
        this.setDefaultValue();
        if (ruleId != -1) {
            Rule rule = this.sccpStack.getRouter().getRule(ruleId);
            if (rule == null) {
                return String.format("Rule doesn't exist on stack=%s", this.sccpStack.getName());
            }
            return rule.toString();
        }
        if (this.sccpStack.getRouter().getRules().size() == 0) {
            return String.format("Rule doesn't exist on stack=%s", this.sccpStack.getName());
        }
        Map idVsRule = this.sccpStack.getRouter().getRules();
        StringBuffer sb = new StringBuffer();
        for (Integer e : idVsRule.keySet()) {
            Rule rule = (Rule)idVsRule.get(e);
            sb.append("key=");
            sb.append(e);
            sb.append("  Rule=");
            sb.append(rule);
            sb.append("\n");
        }
        return sb.toString();
    }

    private SccpAddress createAddress(String[] options, int index, boolean isRule) throws Exception {
        return this.createAddress(Integer.parseInt(options[index++]), Integer.parseInt(options[index++]), Integer.parseInt(options[index++]), Integer.parseInt(options[index++]), Integer.parseInt(options[index++]), Integer.parseInt(options[index++]), options[index++], isRule);
    }

    private SccpAddress createAddress(int ai, int pc, int ssn, int tt, int npValue, int naiValue, String digits, boolean isRule) throws Exception {
        SccpAddressImpl sccpAddress = null;
        AddressIndicator aiObj = new AddressIndicator((byte)ai, SccpProtocolVersion.ITU);
        if (!isRule && pc <= 0) {
            throw new Exception(String.format("Point code parameter is mandatory and must be > 0", new Object[0]));
        }
        if (aiObj.getGlobalTitleIndicator() == null) {
            throw new Exception(String.format("GlobalTitle type is not recognizes, possible bad AddressIndicator value", new Object[0]));
        }
        NumberingPlan np = NumberingPlan.valueOf((int)npValue);
        NatureOfAddress nai = NatureOfAddress.valueOf((int)naiValue);
        GlobalTitle gt = null;
        switch (aiObj.getGlobalTitleIndicator()) {
            case GLOBAL_TITLE_INCLUDES_NATURE_OF_ADDRESS_INDICATOR_ONLY: {
                gt = this.sccpStack.getSccpProvider().getParameterFactory().createGlobalTitle(digits, nai);
                break;
            }
            case GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_ONLY: {
                gt = this.sccpStack.getSccpProvider().getParameterFactory().createGlobalTitle(digits, tt);
                break;
            }
            case GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_NUMBERING_PLAN_AND_ENCODING_SCHEME: {
                gt = this.sccpStack.getSccpProvider().getParameterFactory().createGlobalTitle(digits, tt, np, null);
                break;
            }
            case GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_NUMBERING_PLAN_ENCODING_SCHEME_AND_NATURE_OF_ADDRESS: {
                gt = this.sccpStack.getSccpProvider().getParameterFactory().createGlobalTitle(digits, tt, np, null, nai);
                break;
            }
            case NO_GLOBAL_TITLE_INCLUDED: {
                gt = this.sccpStack.getSccpProvider().getParameterFactory().createGlobalTitle(digits);
            }
        }
        sccpAddress = new SccpAddressImpl(aiObj.getRoutingIndicator(), gt, pc, ssn);
        return sccpAddress;
    }

    private String manageLmr(String[] options) throws Exception {
        if (options.length < 3) {
            return "Invalid Command";
        }
        String command = options[2];
        if (command == null) {
            return "Invalid Command";
        }
        if (command.equals("create")) {
            LongMessageRuleType ruleType;
            if (options.length < 7) {
                return "Invalid Command";
            }
            int lmrId = Integer.parseInt(options[3]);
            int firstSpc = Integer.parseInt(options[4]);
            int lastSpc = Integer.parseInt(options[5]);
            String s1 = options[6].toLowerCase();
            if (s1.equals("udt")) {
                ruleType = LongMessageRuleType.LONG_MESSAGE_FORBBIDEN;
            } else if (s1.equals("xudt")) {
                ruleType = LongMessageRuleType.XUDT_ENABLED;
            } else if (s1.equals("ludt")) {
                ruleType = LongMessageRuleType.LUDT_ENABLED;
            } else if (s1.equals("ludt_segm")) {
                ruleType = LongMessageRuleType.LUDT_ENABLED_WITH_SEGMENTATION;
            } else {
                return "Invalid Command";
            }
            int count = 7;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = (SccpStackImpl)this.sccpStacks.get((Object)(m3uaStackName = options[count++]))) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            this.sccpStack.getRouter().addLongMessageRule(lmrId, firstSpc, lastSpc, ruleType);
            return String.format("Long message rule successfully added on stack=%s", this.sccpStack.getName());
        }
        if (command.equals("modify")) {
            LongMessageRuleType ruleType;
            if (options.length < 7) {
                return "Invalid Command";
            }
            int lmrId = Integer.parseInt(options[3]);
            int firstSpc = Integer.parseInt(options[4]);
            int lastSpc = Integer.parseInt(options[5]);
            String s1 = options[6].toLowerCase();
            if (s1.equals("udt")) {
                ruleType = LongMessageRuleType.LONG_MESSAGE_FORBBIDEN;
            } else if (s1.equals("xudt")) {
                ruleType = LongMessageRuleType.XUDT_ENABLED;
            } else if (s1.equals("ludt")) {
                ruleType = LongMessageRuleType.LUDT_ENABLED;
            } else if (s1.equals("ludt_segm")) {
                ruleType = LongMessageRuleType.LUDT_ENABLED_WITH_SEGMENTATION;
            } else {
                return "Invalid Command";
            }
            int count = 7;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = (SccpStackImpl)this.sccpStacks.get((Object)(m3uaStackName = options[count++]))) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            this.sccpStack.getRouter().modifyLongMessageRule(lmrId, firstSpc, lastSpc, ruleType);
            return String.format("Long message rule successfully modified on stack=%s", this.sccpStack.getName());
        }
        if (command.equals("delete")) {
            if (options.length < 4) {
                return "Invalid Command";
            }
            int lmrId = Integer.parseInt(options[3]);
            int count = 4;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = (SccpStackImpl)this.sccpStacks.get((Object)(m3uaStackName = options[count++]))) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            this.sccpStack.getRouter().removeLongMessageRule(lmrId);
            return String.format("Long message rule successfully deleted from stack=%s", this.sccpStack.getName());
        }
        if (command.equals("show")) {
            int count = 3;
            int lmrId = -1;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = (SccpStackImpl)this.sccpStacks.get((Object)(m3uaStackName = options[count++]))) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                if (key.equals("id")) {
                    lmrId = Integer.parseInt(options[count++]);
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            if (lmrId != -1) {
                LongMessageRule lmr = this.sccpStack.getRouter().getLongMessageRule(lmrId);
                if (lmr == null) {
                    return String.format("Long message rule doesn't exist on stack=%s", this.sccpStack.getName());
                }
                return lmr.toString();
            }
            if (this.sccpStack.getRouter().getLongMessageRules().size() == 0) {
                return String.format("Long message rule doesn't exist on stack=%s", this.sccpStack.getName());
            }
            Map idVsLngmsgRule = this.sccpStack.getRouter().getLongMessageRules();
            StringBuffer sb = new StringBuffer();
            for (Integer e : idVsLngmsgRule.keySet()) {
                LongMessageRule lmr = (LongMessageRule)idVsLngmsgRule.get(e);
                sb.append("key=");
                sb.append(e);
                sb.append("  ");
                sb.append(lmr);
                sb.append("\n");
            }
            return sb.toString();
        }
        return "Invalid Command";
    }

    private String manageSap(String[] options) throws Exception {
        if (options.length < 3) {
            return "Invalid Command";
        }
        String command = options[2];
        if (command == null) {
            return "Invalid Command";
        }
        if (command.equals("create")) {
            if (options.length < 7) {
                return "Invalid Command";
            }
            int sapId = Integer.parseInt(options[3]);
            int mtp3Id = Integer.parseInt(options[4]);
            int opc = Integer.parseInt(options[5]);
            int ni = Integer.parseInt(options[6]);
            int count = 7;
            int networkId = 0;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = (SccpStackImpl)this.sccpStacks.get((Object)(m3uaStackName = options[count++]))) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                if (key.equals("networkid")) {
                    String networkIdS = options[count++];
                    networkId = Integer.parseInt(networkIdS);
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            this.sccpStack.getRouter().addMtp3ServiceAccessPoint(sapId, mtp3Id, opc, ni, networkId);
            return String.format("Service access point successfully added on stack=%s", this.sccpStack.getName());
        }
        if (command.equals("modify")) {
            if (options.length < 7) {
                return "Invalid Command";
            }
            int sapId = Integer.parseInt(options[3]);
            int mtp3Id = Integer.parseInt(options[4]);
            int opc = Integer.parseInt(options[5]);
            int ni = Integer.parseInt(options[6]);
            int count = 7;
            int networkId = 0;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = (SccpStackImpl)this.sccpStacks.get((Object)(m3uaStackName = options[count++]))) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                if (key.equals("networkid")) {
                    String networkIdS = options[count++];
                    networkId = Integer.parseInt(networkIdS);
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            this.sccpStack.getRouter().modifyMtp3ServiceAccessPoint(sapId, mtp3Id, opc, ni, networkId);
            return String.format("Service access point successfully modified on stack=%s", this.sccpStack.getName());
        }
        if (command.equals("delete")) {
            if (options.length < 4) {
                return "Invalid Command";
            }
            int sapId = Integer.parseInt(options[3]);
            int count = 4;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = (SccpStackImpl)this.sccpStacks.get((Object)(m3uaStackName = options[count++]))) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            this.sccpStack.getRouter().removeMtp3ServiceAccessPoint(sapId);
            return String.format("Service access point successfully deleted from sack=%s", this.sccpStack.getName());
        }
        if (command.equals("show")) {
            int count = 3;
            int sapId = -1;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = (SccpStackImpl)this.sccpStacks.get((Object)(m3uaStackName = options[count++]))) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                if (key.equals("id")) {
                    sapId = Integer.parseInt(options[count++]);
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            if (sapId != -1) {
                Mtp3ServiceAccessPoint sap = this.sccpStack.getRouter().getMtp3ServiceAccessPoint(sapId);
                if (sap == null) {
                    return String.format("Service access point doesn't exist on stack=%s", this.sccpStack.getName());
                }
                return sap.toString();
            }
            if (this.sccpStack.getRouter().getMtp3ServiceAccessPoints().size() == 0) {
                return String.format("Service access point doesn't exist on stack=%s", this.sccpStack.getName());
            }
            Map idVsMtp3SerAccPt = this.sccpStack.getRouter().getMtp3ServiceAccessPoints();
            StringBuffer sb = new StringBuffer();
            for (Integer e : idVsMtp3SerAccPt.keySet()) {
                Mtp3ServiceAccessPoint sap = (Mtp3ServiceAccessPoint)idVsMtp3SerAccPt.get(e);
                sb.append("key=");
                sb.append(e);
                sb.append("  ");
                sb.append(sap);
                sb.append("\n");
            }
            return sb.toString();
        }
        return "Invalid Command";
    }

    private String manageDest(String[] options) throws Exception {
        if (options.length < 4) {
            return "Invalid Command";
        }
        String command = options[2];
        if (command == null) {
            return "Invalid Command";
        }
        if (command.equals("create")) {
            if (options.length < 10) {
                return "Invalid Command";
            }
            int sapId = Integer.parseInt(options[3]);
            int destId = Integer.parseInt(options[4]);
            int firstDpc = Integer.parseInt(options[5]);
            int lastDpc = Integer.parseInt(options[6]);
            int firstSls = Integer.parseInt(options[7]);
            int lastSls = Integer.parseInt(options[8]);
            int slsMask = Integer.parseInt(options[9]);
            int count = 10;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = (SccpStackImpl)this.sccpStacks.get((Object)(m3uaStackName = options[count++]))) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            this.sccpStack.getRouter().addMtp3Destination(sapId, destId, firstDpc, lastDpc, firstSls, lastSls, slsMask);
            return String.format("Destination definition successfully added on stack=%s", this.sccpStack.getName());
        }
        if (command.equals("modify")) {
            if (options.length < 10) {
                return "Invalid Command";
            }
            int sapId = Integer.parseInt(options[3]);
            int destId = Integer.parseInt(options[4]);
            int firstDpc = Integer.parseInt(options[5]);
            int lastDpc = Integer.parseInt(options[6]);
            int firstSls = Integer.parseInt(options[7]);
            int lastSls = Integer.parseInt(options[8]);
            int slsMask = Integer.parseInt(options[9]);
            int count = 10;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = (SccpStackImpl)this.sccpStacks.get((Object)(m3uaStackName = options[count++]))) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            this.sccpStack.getRouter().modifyMtp3Destination(sapId, destId, firstDpc, lastDpc, firstSls, lastSls, slsMask);
            return String.format("Destination definition successfully modified on stack=%s", this.sccpStack.getName());
        }
        if (command.equals("delete")) {
            if (options.length < 5) {
                return "Invalid Command";
            }
            int sapId = Integer.parseInt(options[3]);
            int destId = Integer.parseInt(options[4]);
            int count = 5;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = (SccpStackImpl)this.sccpStacks.get((Object)(m3uaStackName = options[count++]))) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            this.sccpStack.getRouter().removeMtp3Destination(sapId, destId);
            return String.format("Destination definition successfully deleted from stack=%s", this.sccpStack.getName());
        }
        if (command.equals("show")) {
            Mtp3ServiceAccessPoint sap;
            int sapId = Integer.parseInt(options[3]);
            int destId = -1;
            int count = 4;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = (SccpStackImpl)this.sccpStacks.get((Object)(m3uaStackName = options[count++]))) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                if (key.equals("id")) {
                    destId = Integer.parseInt(options[count++]);
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            if (destId != -1) {
                sap = this.sccpStack.getRouter().getMtp3ServiceAccessPoint(sapId);
                if (sap == null) {
                    return String.format("Service access point doesn't exist on stack=%s", this.sccpStack.getName());
                }
                Mtp3Destination dest = sap.getMtp3Destination(destId);
                if (dest == null) {
                    return String.format("Destination definition doesn't exist on stack=%s", this.sccpStack.getName());
                }
                return dest.toString();
            }
            sap = this.sccpStack.getRouter().getMtp3ServiceAccessPoint(sapId);
            if (sap == null) {
                return String.format("Service access point doesn't exist on stack=%s", this.sccpStack.getName());
            }
            return sap.toString();
        }
        return "Invalid Command";
    }

    private String manageConcernedSpc(String[] options) throws Exception {
        if (options.length < 3) {
            return "Invalid Command";
        }
        String command = options[2];
        if (command == null) {
            return "Invalid Command";
        }
        if (command.equals("create")) {
            if (options.length < 5) {
                return "Invalid Command";
            }
            int concernedSpcId = Integer.parseInt(options[3]);
            int conSpc = Integer.parseInt(options[4]);
            int count = 5;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = (SccpStackImpl)this.sccpStacks.get((Object)(m3uaStackName = options[count++]))) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            this.sccpStack.getSccpResource().addConcernedSpc(concernedSpcId, conSpc);
            return String.format("Concerned spc successfully added on stack=%s", this.sccpStack.getName());
        }
        if (command.equals("modify")) {
            if (options.length < 5) {
                return "Invalid Command";
            }
            int concernedSpcId = Integer.parseInt(options[3]);
            if (this.sccpStack.getSccpResource().getConcernedSpc(concernedSpcId) == null) {
                return String.format("Concerned spc doesn't exist on stack=%s", this.sccpStack.getName());
            }
            int conSpc = Integer.parseInt(options[4]);
            int count = 5;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = (SccpStackImpl)this.sccpStacks.get((Object)(m3uaStackName = options[count++]))) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            this.sccpStack.getSccpResource().modifyConcernedSpc(concernedSpcId, conSpc);
            return String.format("Concerned spc successfully modified on stack=%s", this.sccpStack.getName());
        }
        if (command.equals("delete")) {
            if (options.length < 4) {
                return "Invalid Command";
            }
            int concernedSpcId = Integer.parseInt(options[3]);
            int count = 4;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = (SccpStackImpl)this.sccpStacks.get((Object)(m3uaStackName = options[count++]))) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            this.sccpStack.getSccpResource().removeConcernedSpc(concernedSpcId);
            return String.format("Concerned spc successfully deleted from stack=%s", this.sccpStack.getName());
        }
        if (command.equals("show")) {
            int count = 3;
            int concernedSpcId = -1;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = (SccpStackImpl)this.sccpStacks.get((Object)(m3uaStackName = options[count++]))) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                if (key.equals("id")) {
                    concernedSpcId = Integer.parseInt(options[count++]);
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            if (concernedSpcId != -1) {
                ConcernedSignalingPointCode conSpc = this.sccpStack.getSccpResource().getConcernedSpc(concernedSpcId);
                if (conSpc == null) {
                    return String.format("Concerned spc doesn't exist on stack=%s", this.sccpStack.getName());
                }
                return conSpc.toString();
            }
            if (this.sccpStack.getSccpResource().getConcernedSpcs().size() == 0) {
                return String.format("Concerned spc doesn't exist on stack=%s", this.sccpStack.getName());
            }
            StringBuffer sb = new StringBuffer();
            Map idvsCsp = this.sccpStack.getSccpResource().getConcernedSpcs();
            for (Integer e : idvsCsp.keySet()) {
                ConcernedSignalingPointCode ConcSpc = (ConcernedSignalingPointCode)idvsCsp.get(e);
                sb.append("key=");
                sb.append(e);
                sb.append("  ");
                sb.append(ConcSpc);
                sb.append("\n");
            }
            return sb.toString();
        }
        return "Invalid Command";
    }

    private String manageSet(String[] options) throws Exception {
        if (options.length < 4) {
            return "Invalid Command";
        }
        int count = 4;
        while (count < options.length) {
            String key;
            if ((key = options[count++]) == null) {
                return "Invalid Command";
            }
            if (key.equals("stackname")) {
                String m3uaStackName;
                SccpStackImpl sccpStaclImpl;
                if ((sccpStaclImpl = (SccpStackImpl)this.sccpStacks.get((Object)(m3uaStackName = options[count++]))) == null) {
                    return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                }
                this.sccpStack = sccpStaclImpl;
                continue;
            }
            return "Invalid Command";
        }
        this.setDefaultValue();
        String parName = options[2].toLowerCase();
        if (parName.equals("zmarginxudtmessage")) {
            int val = Integer.parseInt(options[3]);
            this.sccpStack.setZMarginXudtMessage(val);
        } else if (parName.equals("reassemblytimerdelay")) {
            int val = Integer.parseInt(options[3]);
            this.sccpStack.setReassemblyTimerDelay(val);
        } else if (parName.equals("maxdatamessage")) {
            int val = Integer.parseInt(options[3]);
            this.sccpStack.setMaxDataMessage(val);
        } else if (parName.equals("removespc")) {
            boolean val = Boolean.parseBoolean(options[3]);
            this.sccpStack.setRemoveSpc(val);
        } else if (parName.equals("previewmode")) {
            boolean val = Boolean.parseBoolean(options[3]);
            this.sccpStack.setPreviewMode(val);
        } else if (parName.equals("ssttimerduration_min")) {
            int val = Integer.parseInt(options[3]);
            this.sccpStack.setSstTimerDuration_Min(val);
        } else if (parName.equals("ssttimerduration_max")) {
            int val = Integer.parseInt(options[3]);
            this.sccpStack.setSstTimerDuration_Max(val);
        } else if (parName.equals("ssttimerduration_increasefactor")) {
            double val = Double.parseDouble(options[3]);
            this.sccpStack.setSstTimerDuration_IncreaseFactor(val);
        } else if (parName.equals("sccpprotocolversion")) {
            SccpProtocolVersion spv = Enum.valueOf(SccpProtocolVersion.class, options[3]);
            if (spv != null) {
                this.sccpStack.setSccpProtocolVersion(spv);
            }
        } else if (parName.equals("cc_timer_a")) {
            int val = Integer.parseInt(options[3]);
            this.sccpStack.setCongControlTIMER_A(val);
        } else if (parName.equals("cc_timer_d")) {
            int val = Integer.parseInt(options[3]);
            this.sccpStack.setCongControlTIMER_D(val);
        } else if (parName.equals("cc_algo")) {
            String vals = options[3];
            SccpCongestionControlAlgo algo = Enum.valueOf(SccpCongestionControlAlgo.class, vals);
            this.sccpStack.setCongControl_Algo(algo);
        } else if (parName.equals("cc_blockingoutgoungsccpmessages")) {
            boolean valb = Boolean.parseBoolean(options[3]);
            this.sccpStack.setCongControl_blockingOutgoungSccpMessages(valb);
        } else {
            return "Invalid Command";
        }
        return String.format("Parameter has been successfully set on stack=%s", this.sccpStack.getName());
    }

    private String manageGet(String[] options) throws Exception {
        if (options.length < 2) {
            return "Invalid Command";
        }
        if (options.length == 3) {
            this.setDefaultValue();
            String parName = options[2].toLowerCase();
            StringBuilder sb = new StringBuilder();
            sb.append(options[2]);
            sb.append(" = ");
            if (parName.equals("zmarginxudtmessage")) {
                sb.append(this.sccpStack.getZMarginXudtMessage());
            } else if (parName.equals("reassemblytimerdelay")) {
                sb.append(this.sccpStack.getReassemblyTimerDelay());
            } else if (parName.equals("maxdatamessage")) {
                sb.append(this.sccpStack.getMaxDataMessage());
            } else if (parName.equals("removespc")) {
                sb.append(this.sccpStack.isRemoveSpc());
            } else if (parName.equals("previewmode")) {
                sb.append(this.sccpStack.isPreviewMode());
            } else if (parName.equals("ssttimerduration_min")) {
                sb.append(this.sccpStack.getSstTimerDuration_Min());
            } else if (parName.equals("ssttimerduration_max")) {
                sb.append(this.sccpStack.getSstTimerDuration_Max());
            } else if (parName.equals("ssttimerduration_increasefactor")) {
                sb.append(this.sccpStack.getSstTimerDuration_IncreaseFactor());
            } else if (parName.equals("sccpprotocolversion")) {
                sb.append(this.sccpStack.getSccpProtocolVersion());
            } else if (parName.equals("cc_timer_a")) {
                sb.append(this.sccpStack.getCongControlTIMER_A());
            } else if (parName.equals("cc_timer_d")) {
                sb.append(this.sccpStack.getCongControlTIMER_D());
            } else if (parName.equals("cc_algo")) {
                sb.append(this.sccpStack.getCongControl_Algo());
            } else if (parName.equals("cc_blockingoutgoungsccpmessages")) {
                sb.append(this.sccpStack.isCongControl_blockingOutgoungSccpMessages());
            } else {
                return "Invalid Command";
            }
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        FastMap.Entry e = this.sccpStacks.head();
        FastMap.Entry end = this.sccpStacks.tail();
        while ((e = e.getNext()) != end) {
            SccpStackImpl managementImplTmp = (SccpStackImpl)e.getValue();
            String stackname = (String)e.getKey();
            sb.append("Properties for ");
            sb.append(stackname);
            sb.append("\n");
            sb.append("*******************");
            sb.append("\n");
            sb.append("zMarginXudtMessage = ");
            sb.append(managementImplTmp.getZMarginXudtMessage());
            sb.append("\n");
            sb.append("reassemblyTimerDelay = ");
            sb.append(managementImplTmp.getReassemblyTimerDelay());
            sb.append("\n");
            sb.append("maxDataMessage = ");
            sb.append(managementImplTmp.getMaxDataMessage());
            sb.append("\n");
            sb.append("removeSpc = ");
            sb.append(managementImplTmp.isRemoveSpc());
            sb.append("\n");
            sb.append("previewMode = ");
            sb.append(managementImplTmp.isPreviewMode());
            sb.append("\n");
            sb.append("sstTimerDuration_Min = ");
            sb.append(managementImplTmp.getSstTimerDuration_Min());
            sb.append("\n");
            sb.append("sstTimerDuration_Max = ");
            sb.append(managementImplTmp.getSstTimerDuration_Max());
            sb.append("\n");
            sb.append("sstTimerDuration_IncreaseFactor = ");
            sb.append(managementImplTmp.getSstTimerDuration_IncreaseFactor());
            sb.append("\n");
            sb.append("sccpprotocolversion = ");
            sb.append(managementImplTmp.getSccpProtocolVersion());
            sb.append("\n");
            sb.append("cc_timer_a = ");
            sb.append(managementImplTmp.getCongControlTIMER_A());
            sb.append("\n");
            sb.append("cc_timer_d = ");
            sb.append(managementImplTmp.getCongControlTIMER_D());
            sb.append("\n");
            sb.append("cc_algo = ");
            sb.append(managementImplTmp.getCongControl_Algo());
            sb.append("\n");
            sb.append("cc_blockingoutgoungsccpmessages = ");
            sb.append(managementImplTmp.isCongControl_blockingOutgoungSccpMessages());
            sb.append("\n");
            sb.append("*******************");
            sb.append("\n");
            sb.append("\n");
        }
        return sb.toString();
    }

    public boolean handles(String command) {
        return command.startsWith("sccp");
    }
}

