/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.impl.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.sccp.LongMessageRuleType;
import org.mobicents.protocols.ss7.sccp.SccpProtocolVersion;
import org.mobicents.protocols.ss7.sccp.impl.SccpStackImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.EncodingResult;
import org.mobicents.protocols.ss7.sccp.impl.message.EncodingResultData;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpMessageImpl;
import org.mobicents.protocols.ss7.sccp.impl.parameter.CreditImpl;
import org.mobicents.protocols.ss7.sccp.impl.parameter.LocalReferenceImpl;
import org.mobicents.protocols.ss7.sccp.impl.parameter.ProtocolClassImpl;
import org.mobicents.protocols.ss7.sccp.impl.parameter.SequencingSegmentingImpl;
import org.mobicents.protocols.ss7.sccp.message.ParseException;
import org.mobicents.protocols.ss7.sccp.message.SccpConnItMessage;
import org.mobicents.protocols.ss7.sccp.parameter.Credit;
import org.mobicents.protocols.ss7.sccp.parameter.LocalReference;
import org.mobicents.protocols.ss7.sccp.parameter.ParameterFactory;
import org.mobicents.protocols.ss7.sccp.parameter.ProtocolClass;
import org.mobicents.protocols.ss7.sccp.parameter.SequencingSegmenting;

public class SccpConnItMessageImpl
extends SccpMessageImpl
implements SccpConnItMessage {
    protected LocalReference destinationLocalReferenceNumber;
    protected LocalReference sourceLocalReferenceNumber;
    protected ProtocolClass protocolClass;
    protected SequencingSegmenting sequencingSegmenting;
    protected Credit credit;

    protected SccpConnItMessageImpl(int sls, int localSsn) {
        super(0, 16, sls, localSsn);
    }

    protected SccpConnItMessageImpl(int incomingOpc, int incomingDpc, int incomingSls, int networkId) {
        super(0, 16, incomingOpc, incomingDpc, incomingSls, networkId);
    }

    public LocalReference getDestinationLocalReferenceNumber() {
        return this.destinationLocalReferenceNumber;
    }

    public void setDestinationLocalReferenceNumber(LocalReference number) {
        this.destinationLocalReferenceNumber = number;
    }

    public LocalReference getSourceLocalReferenceNumber() {
        return this.sourceLocalReferenceNumber;
    }

    public void setSourceLocalReferenceNumber(LocalReference number) {
        this.sourceLocalReferenceNumber = number;
    }

    public ProtocolClass getProtocolClass() {
        return this.protocolClass;
    }

    public void setProtocolClass(ProtocolClass value) {
        this.protocolClass = value;
    }

    public SequencingSegmenting getSequencingSegmenting() {
        return this.sequencingSegmenting;
    }

    public void setSequencingSegmenting(SequencingSegmenting value) {
        this.sequencingSegmenting = value;
    }

    public Credit getCredit() {
        return this.credit;
    }

    public void setCredit(Credit value) {
        this.credit = value;
    }

    @Override
    public void decode(InputStream in, ParameterFactory factory, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            byte[] buffer = new byte[3];
            in.read(buffer);
            LocalReferenceImpl ref = new LocalReferenceImpl();
            ref.decode(buffer, factory, sccpProtocolVersion);
            this.destinationLocalReferenceNumber = ref;
            in.read(buffer);
            ref = new LocalReferenceImpl();
            ref.decode(buffer, factory, sccpProtocolVersion);
            this.sourceLocalReferenceNumber = ref;
            buffer = new byte[1];
            in.read(buffer);
            ProtocolClassImpl protocol = new ProtocolClassImpl();
            protocol.decode(buffer, factory, sccpProtocolVersion);
            this.protocolClass = protocol;
            if (protocol.getProtocolClass() != 2) {
                buffer = new byte[2];
                in.read(buffer);
                SequencingSegmentingImpl sequencing = new SequencingSegmentingImpl();
                sequencing.decode(buffer, factory, sccpProtocolVersion);
                this.sequencingSegmenting = sequencing;
                buffer = new byte[1];
                in.read(buffer);
                CreditImpl cred = new CreditImpl();
                cred.decode(buffer, factory, sccpProtocolVersion);
                this.credit = cred;
            }
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
    }

    @Override
    public EncodingResultData encode(SccpStackImpl sccpStackImpl, LongMessageRuleType longMessageRuleType, int maxMtp3UserDataLength, Logger logger, boolean removeSPC, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            if (this.type == 0) {
                return new EncodingResultData(EncodingResult.MessageTypeMissing, null, null, null);
            }
            if (this.destinationLocalReferenceNumber == null) {
                return new EncodingResultData(EncodingResult.DestinationLocalReferenceNumberMissing, null, null, null);
            }
            if (this.sourceLocalReferenceNumber == null) {
                return new EncodingResultData(EncodingResult.SourceLocalReferenceNumberMissing, null, null, null);
            }
            if (this.protocolClass == null) {
                return new EncodingResultData(EncodingResult.ProtocolClassMissing, null, null, null);
            }
            if (this.sequencingSegmenting == null) {
                return new EncodingResultData(EncodingResult.SequencingSegmentingMissing, null, null, null);
            }
            if (this.credit == null) {
                return new EncodingResultData(EncodingResult.CreditMissing, null, null, null);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream(11);
            byte[] dlr = ((LocalReferenceImpl)this.destinationLocalReferenceNumber).encode(sccpStackImpl.isRemoveSpc(), sccpStackImpl.getSccpProtocolVersion());
            byte[] slr = ((LocalReferenceImpl)this.sourceLocalReferenceNumber).encode(sccpStackImpl.isRemoveSpc(), sccpStackImpl.getSccpProtocolVersion());
            byte[] proto = ((ProtocolClassImpl)this.protocolClass).encode(sccpStackImpl.isRemoveSpc(), sccpStackImpl.getSccpProtocolVersion());
            byte[] seq = ((SequencingSegmentingImpl)this.sequencingSegmenting).encode(sccpStackImpl.isRemoveSpc(), sccpStackImpl.getSccpProtocolVersion());
            byte[] cred = ((CreditImpl)this.credit).encode(sccpStackImpl.isRemoveSpc(), sccpStackImpl.getSccpProtocolVersion());
            out.write(this.type);
            out.write(dlr);
            out.write(slr);
            out.write(proto);
            out.write(seq);
            out.write(cred);
            return new EncodingResultData(EncodingResult.Success, out.toByteArray(), null, null);
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
    }
}

