/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.impl.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.sccp.LongMessageRuleType;
import org.mobicents.protocols.ss7.sccp.SccpProtocolVersion;
import org.mobicents.protocols.ss7.sccp.impl.SccpStackImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.EncodingResult;
import org.mobicents.protocols.ss7.sccp.impl.message.EncodingResultData;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpMessageImpl;
import org.mobicents.protocols.ss7.sccp.impl.parameter.ErrorCauseImpl;
import org.mobicents.protocols.ss7.sccp.impl.parameter.LocalReferenceImpl;
import org.mobicents.protocols.ss7.sccp.message.ParseException;
import org.mobicents.protocols.ss7.sccp.message.SccpConnErrMessage;
import org.mobicents.protocols.ss7.sccp.parameter.ErrorCause;
import org.mobicents.protocols.ss7.sccp.parameter.LocalReference;
import org.mobicents.protocols.ss7.sccp.parameter.ParameterFactory;

public class SccpConnErrMessageImpl
extends SccpMessageImpl
implements SccpConnErrMessage {
    protected LocalReference destinationLocalReferenceNumber;
    protected ErrorCause errorCause;

    protected SccpConnErrMessageImpl(int sls, int localSsn) {
        super(0, 15, sls, localSsn);
    }

    protected SccpConnErrMessageImpl(int incomingOpc, int incomingDpc, int incomingSls, int networkId) {
        super(0, 15, incomingOpc, incomingDpc, incomingSls, networkId);
    }

    public LocalReference getDestinationLocalReferenceNumber() {
        return this.destinationLocalReferenceNumber;
    }

    public void setDestinationLocalReferenceNumber(LocalReference number) {
        this.destinationLocalReferenceNumber = number;
    }

    public ErrorCause getErrorCause() {
        return this.errorCause;
    }

    public void setErrorCause(ErrorCause value) {
        this.errorCause = value;
    }

    @Override
    public void decode(InputStream in, ParameterFactory factory, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            byte[] buffer = new byte[3];
            in.read(buffer);
            LocalReferenceImpl ref = new LocalReferenceImpl();
            ref.decode(buffer, factory, sccpProtocolVersion);
            this.destinationLocalReferenceNumber = ref;
            buffer = new byte[1];
            in.read(buffer);
            ErrorCauseImpl cause = new ErrorCauseImpl();
            cause.decode(buffer, factory, sccpProtocolVersion);
            this.errorCause = cause;
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
    }

    @Override
    public EncodingResultData encode(SccpStackImpl sccpStackImpl, LongMessageRuleType longMessageRuleType, int maxMtp3UserDataLength, Logger logger, boolean removeSPC, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        if (this.type == 0) {
            return new EncodingResultData(EncodingResult.MessageTypeMissing, null, null, null);
        }
        try {
            if (this.destinationLocalReferenceNumber == null) {
                return new EncodingResultData(EncodingResult.DestinationLocalReferenceNumberMissing, null, null, null);
            }
            if (this.errorCause == null) {
                return new EncodingResultData(EncodingResult.ErrorCauseMissing, null, null, null);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream(5);
            byte[] dlr = ((LocalReferenceImpl)this.destinationLocalReferenceNumber).encode(sccpStackImpl.isRemoveSpc(), sccpStackImpl.getSccpProtocolVersion());
            byte[] cause = ((ErrorCauseImpl)this.errorCause).encode(sccpStackImpl.isRemoveSpc(), sccpStackImpl.getSccpProtocolVersion());
            out.write(this.type);
            out.write(dlr);
            out.write(cause);
            return new EncodingResultData(EncodingResult.Success, out.toByteArray(), null, null);
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
    }
}

