/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.impl.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.mobicents.protocols.ss7.sccp.LongMessageRuleType;
import org.mobicents.protocols.ss7.sccp.SccpProtocolVersion;
import org.mobicents.protocols.ss7.sccp.impl.SccpStackImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.EncodingResult;
import org.mobicents.protocols.ss7.sccp.impl.message.EncodingResultData;
import org.mobicents.protocols.ss7.sccp.impl.message.MessageUtil;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpMessageImpl;
import org.mobicents.protocols.ss7.sccp.impl.parameter.CreditImpl;
import org.mobicents.protocols.ss7.sccp.impl.parameter.ImportanceImpl;
import org.mobicents.protocols.ss7.sccp.impl.parameter.LocalReferenceImpl;
import org.mobicents.protocols.ss7.sccp.impl.parameter.ProtocolClassImpl;
import org.mobicents.protocols.ss7.sccp.impl.parameter.SccpAddressImpl;
import org.mobicents.protocols.ss7.sccp.message.ParseException;
import org.mobicents.protocols.ss7.sccp.message.SccpConnCcMessage;
import org.mobicents.protocols.ss7.sccp.parameter.Credit;
import org.mobicents.protocols.ss7.sccp.parameter.Importance;
import org.mobicents.protocols.ss7.sccp.parameter.LocalReference;
import org.mobicents.protocols.ss7.sccp.parameter.ParameterFactory;
import org.mobicents.protocols.ss7.sccp.parameter.ProtocolClass;
import org.mobicents.protocols.ss7.sccp.parameter.ReturnCauseValue;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;

public class SccpConnCcMessageImpl
extends SccpMessageImpl
implements SccpConnCcMessage {
    protected LocalReference destinationLocalReferenceNumber;
    protected LocalReference sourceLocalReferenceNumber;
    protected SccpAddress calledPartyAddress;
    protected ProtocolClass protocolClass;
    protected Credit credit;
    protected byte[] userData;
    protected Importance importance;

    protected SccpConnCcMessageImpl(int sls, int localSsn) {
        super(130, 2, sls, localSsn);
    }

    protected SccpConnCcMessageImpl(int incomingOpc, int incomingDpc, int incomingSls, int networkId) {
        super(130, 2, incomingOpc, incomingDpc, incomingSls, networkId);
    }

    public LocalReference getDestinationLocalReferenceNumber() {
        return this.destinationLocalReferenceNumber;
    }

    public void setDestinationLocalReferenceNumber(LocalReference destinationLocalReferenceNumber) {
        this.destinationLocalReferenceNumber = destinationLocalReferenceNumber;
    }

    public LocalReference getSourceLocalReferenceNumber() {
        return this.sourceLocalReferenceNumber;
    }

    public void setSourceLocalReferenceNumber(LocalReference sourceLocalReferenceNumber) {
        this.sourceLocalReferenceNumber = sourceLocalReferenceNumber;
    }

    public SccpAddress getCalledPartyAddress() {
        return this.calledPartyAddress;
    }

    public void setCalledPartyAddress(SccpAddress calledPartyAddress) {
        this.calledPartyAddress = calledPartyAddress;
    }

    public ProtocolClass getProtocolClass() {
        return this.protocolClass;
    }

    public void setProtocolClass(ProtocolClass protocolClass) {
        this.protocolClass = protocolClass;
    }

    public Credit getCredit() {
        return this.credit;
    }

    public void setCredit(Credit credit) {
        this.credit = credit;
    }

    public byte[] getUserData() {
        return this.userData;
    }

    public void setUserData(byte[] userData) {
        this.userData = userData;
    }

    public Importance getImportance() {
        return this.importance;
    }

    public void setImportance(Importance importance) {
        this.importance = importance;
    }

    @Override
    public void decode(InputStream in, ParameterFactory factory, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            byte[] buffer = new byte[3];
            in.read(buffer);
            LocalReferenceImpl ref = new LocalReferenceImpl();
            ref.decode(buffer, factory, sccpProtocolVersion);
            this.destinationLocalReferenceNumber = ref;
            in.read(buffer);
            ref = new LocalReferenceImpl();
            ref.decode(buffer, factory, sccpProtocolVersion);
            this.sourceLocalReferenceNumber = ref;
            buffer = new byte[1];
            in.read(buffer);
            ProtocolClassImpl protocol = new ProtocolClassImpl();
            protocol.decode(buffer, factory, sccpProtocolVersion);
            this.protocolClass = protocol;
            int pointer = in.read() & 0xFF;
            in.mark(in.available());
            if (pointer == 0) {
                return;
            }
            if ((long)(pointer - 1) != in.skip(pointer - 1)) {
                throw new IOException("Not enough data in buffer");
            }
            int paramCode = 0;
            while ((paramCode = in.read() & 0xFF) != 0) {
                if (paramCode != 9 && paramCode != 3 && paramCode != 15 && paramCode != 18) {
                    throw new ParseException(String.format("Code %d is not supported for CC message", paramCode));
                }
                int len = in.read() & 0xFF;
                buffer = new byte[len];
                in.read(buffer);
                this.decodeOptional(paramCode, buffer, sccpProtocolVersion);
            }
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
    }

    @Override
    public EncodingResultData encode(SccpStackImpl sccpStackImpl, LongMessageRuleType longMessageRuleType, int maxMtp3UserDataLength, Logger logger, boolean removeSPC, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            byte[] b;
            int fieldsLen;
            int availLen;
            if (this.type == 0) {
                return new EncodingResultData(EncodingResult.MessageTypeMissing, null, null, null);
            }
            if (this.destinationLocalReferenceNumber == null) {
                return new EncodingResultData(EncodingResult.DestinationLocalReferenceNumberMissing, null, null, null);
            }
            if (this.sourceLocalReferenceNumber == null) {
                return new EncodingResultData(EncodingResult.SourceLocalReferenceNumberMissing, null, null, null);
            }
            if (this.protocolClass == null) {
                return new EncodingResultData(EncodingResult.ProtocolClassMissing, null, null, null);
            }
            byte[] protocol = ((ProtocolClassImpl)this.protocolClass).encode(sccpStackImpl.isRemoveSpc(), sccpStackImpl.getSccpProtocolVersion());
            byte[] cdp = new byte[]{};
            if (this.calledPartyAddress != null) {
                cdp = ((SccpAddressImpl)this.calledPartyAddress).encode(sccpStackImpl.isRemoveSpc(), sccpStackImpl.getSccpProtocolVersion());
            }
            byte[] bf = new byte[]{};
            if (this.userData != null) {
                bf = this.userData;
            }
            if ((availLen = maxMtp3UserDataLength - (fieldsLen = MessageUtil.calculateCcFieldsLengthWithoutData(this.credit != null, cdp.length, this.userData != null, this.importance != null))) > 130) {
                availLen = 130;
            }
            if (bf.length > availLen) {
                if (logger.isEnabledFor((Priority)Level.WARN)) {
                    logger.warn((Object)String.format("Failure when sending a CC message: message is too long. SccpMessageSegment=%s", this));
                }
                return new EncodingResultData(EncodingResult.ReturnFailure, null, null, ReturnCauseValue.SEG_NOT_SUPPORTED);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream(fieldsLen + bf.length);
            byte[] dlr = ((LocalReferenceImpl)this.destinationLocalReferenceNumber).encode(sccpStackImpl.isRemoveSpc(), sccpStackImpl.getSccpProtocolVersion());
            byte[] slr = ((LocalReferenceImpl)this.sourceLocalReferenceNumber).encode(sccpStackImpl.isRemoveSpc(), sccpStackImpl.getSccpProtocolVersion());
            out.write(this.type);
            out.write(dlr);
            out.write(slr);
            out.write(protocol);
            int len = 1;
            boolean optionalPresent = false;
            if (this.credit != null || this.calledPartyAddress != null || this.userData != null || this.importance != null) {
                out.write(len);
                optionalPresent = true;
            } else {
                out.write(0);
            }
            if (this.calledPartyAddress != null) {
                out.write(3);
                out.write(cdp.length);
                out.write(cdp);
            }
            if (this.credit != null) {
                out.write(9);
                b = ((CreditImpl)this.credit).encode(removeSPC, sccpProtocolVersion);
                out.write(b.length);
                out.write(b);
            }
            if (this.userData != null) {
                out.write(15);
                out.write(this.userData.length);
                out.write(this.userData);
            }
            if (this.importance != null) {
                out.write(18);
                b = ((ImportanceImpl)this.importance).encode(removeSPC, sccpProtocolVersion);
                out.write(b.length);
                out.write(b);
            }
            if (optionalPresent) {
                out.write(0);
            }
            return new EncodingResultData(EncodingResult.Success, out.toByteArray(), null, null);
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
    }

    protected void decodeOptional(int code, byte[] buffer, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        switch (code) {
            case 9: {
                CreditImpl cred = new CreditImpl();
                cred.decode(buffer, null, sccpProtocolVersion);
                this.credit = cred;
                break;
            }
            case 3: {
                SccpAddressImpl address2 = new SccpAddressImpl();
                address2.decode(buffer, null, sccpProtocolVersion);
                this.calledPartyAddress = address2;
                break;
            }
            case 15: {
                this.userData = buffer;
                break;
            }
            case 18: {
                ImportanceImpl imp = new ImportanceImpl();
                imp.decode(buffer, null, sccpProtocolVersion);
                this.importance = imp;
                break;
            }
            default: {
                throw new ParseException("Unknown optional parameter code: " + code);
            }
        }
    }
}

