/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.impl.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.sccp.LongMessageRuleType;
import org.mobicents.protocols.ss7.sccp.SccpProtocolVersion;
import org.mobicents.protocols.ss7.sccp.impl.SccpStackImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.EncodingResult;
import org.mobicents.protocols.ss7.sccp.impl.message.EncodingResultData;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpMessageImpl;
import org.mobicents.protocols.ss7.sccp.impl.parameter.CreditImpl;
import org.mobicents.protocols.ss7.sccp.impl.parameter.LocalReferenceImpl;
import org.mobicents.protocols.ss7.sccp.impl.parameter.ReceiveSequenceNumberImpl;
import org.mobicents.protocols.ss7.sccp.message.ParseException;
import org.mobicents.protocols.ss7.sccp.message.SccpConnAkMessage;
import org.mobicents.protocols.ss7.sccp.parameter.Credit;
import org.mobicents.protocols.ss7.sccp.parameter.LocalReference;
import org.mobicents.protocols.ss7.sccp.parameter.ParameterFactory;
import org.mobicents.protocols.ss7.sccp.parameter.ReceiveSequenceNumber;

public class SccpConnAkMessageImpl
extends SccpMessageImpl
implements SccpConnAkMessage {
    protected LocalReference destinationLocalReferenceNumber;
    protected ReceiveSequenceNumber receiveSequenceNumber;
    protected Credit credit;

    protected SccpConnAkMessageImpl(int sls, int localSsn) {
        super(0, 8, sls, localSsn);
    }

    protected SccpConnAkMessageImpl(int incomingOpc, int incomingDpc, int incomingSls, int networkId) {
        super(0, 8, incomingOpc, incomingDpc, incomingSls, networkId);
    }

    public LocalReference getDestinationLocalReferenceNumber() {
        return this.destinationLocalReferenceNumber;
    }

    public void setDestinationLocalReferenceNumber(LocalReference number) {
        this.destinationLocalReferenceNumber = number;
    }

    public ReceiveSequenceNumber getReceiveSequenceNumber() {
        return this.receiveSequenceNumber;
    }

    public void setReceiveSequenceNumber(ReceiveSequenceNumber receiveSequenceNumber) {
        this.receiveSequenceNumber = receiveSequenceNumber;
    }

    public Credit getCredit() {
        return this.credit;
    }

    public void setCredit(Credit credit) {
        this.credit = credit;
    }

    @Override
    public void decode(InputStream in, ParameterFactory factory, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            byte[] buffer = new byte[3];
            in.read(buffer);
            LocalReferenceImpl ref = new LocalReferenceImpl();
            ref.decode(buffer, factory, sccpProtocolVersion);
            this.destinationLocalReferenceNumber = ref;
            buffer = new byte[1];
            in.read(buffer);
            ReceiveSequenceNumberImpl sequenceNumber = new ReceiveSequenceNumberImpl();
            sequenceNumber.decode(buffer, factory, sccpProtocolVersion);
            this.receiveSequenceNumber = sequenceNumber;
            in.read(buffer);
            CreditImpl cred = new CreditImpl();
            cred.decode(buffer, factory, sccpProtocolVersion);
            this.credit = cred;
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
    }

    @Override
    public EncodingResultData encode(SccpStackImpl sccpStackImpl, LongMessageRuleType longMessageRuleType, int maxMtp3UserDataLength, Logger logger, boolean removeSPC, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            if (this.type == 0) {
                return new EncodingResultData(EncodingResult.MessageTypeMissing, null, null, null);
            }
            if (this.destinationLocalReferenceNumber == null) {
                return new EncodingResultData(EncodingResult.DestinationLocalReferenceNumberMissing, null, null, null);
            }
            if (this.receiveSequenceNumber == null) {
                return new EncodingResultData(EncodingResult.ReceiveSequenceNumberMissing, null, null, null);
            }
            if (this.credit == null) {
                return new EncodingResultData(EncodingResult.CreditMissing, null, null, null);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream(6);
            byte[] dlr = ((LocalReferenceImpl)this.destinationLocalReferenceNumber).encode(sccpStackImpl.isRemoveSpc(), sccpStackImpl.getSccpProtocolVersion());
            byte[] sqn = ((ReceiveSequenceNumberImpl)this.receiveSequenceNumber).encode(sccpStackImpl.isRemoveSpc(), sccpStackImpl.getSccpProtocolVersion());
            byte[] crd = ((CreditImpl)this.credit).encode(sccpStackImpl.isRemoveSpc(), sccpStackImpl.getSccpProtocolVersion());
            out.write(this.type);
            out.write(dlr);
            out.write(sqn);
            out.write(crd);
            return new EncodingResultData(EncodingResult.Success, out.toByteArray(), null, null);
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
    }
}

