/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.impl.message;

import java.io.InputStream;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.mobicents.protocols.ss7.sccp.SccpProtocolVersion;
import org.mobicents.protocols.ss7.sccp.impl.SccpStackImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpConnAkMessageImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpConnCcMessageImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpConnCrMessageImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpConnCrefMessageImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpConnDt1MessageImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpConnDt2MessageImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpConnErrMessageImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpConnItMessageImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpConnRlcMessageImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpConnRlsdMessageImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpConnRscMessageImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpConnRsrMessageImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpDataMessageImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpMessageImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpNoticeMessageImpl;
import org.mobicents.protocols.ss7.sccp.impl.parameter.ProtocolClassImpl;
import org.mobicents.protocols.ss7.sccp.message.MessageFactory;
import org.mobicents.protocols.ss7.sccp.message.ParseException;
import org.mobicents.protocols.ss7.sccp.message.SccpConnCrMessage;
import org.mobicents.protocols.ss7.sccp.message.SccpDataMessage;
import org.mobicents.protocols.ss7.sccp.message.SccpNoticeMessage;
import org.mobicents.protocols.ss7.sccp.parameter.Credit;
import org.mobicents.protocols.ss7.sccp.parameter.HopCounter;
import org.mobicents.protocols.ss7.sccp.parameter.Importance;
import org.mobicents.protocols.ss7.sccp.parameter.ReturnCause;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;

public class MessageFactoryImpl
implements MessageFactory {
    private static final Logger logger = Logger.getLogger(MessageFactoryImpl.class);
    private transient SccpStackImpl sccpStackImpl;

    public MessageFactoryImpl(SccpStackImpl sccpStackImpl) {
        this.sccpStackImpl = sccpStackImpl;
    }

    public SccpDataMessage createDataMessageClass0(SccpAddress calledParty, SccpAddress callingParty, byte[] data, int localSsn, boolean returnMessageOnError, HopCounter hopCounter, Importance importance) {
        return new SccpDataMessageImpl(this.sccpStackImpl.getMaxDataMessage(), new ProtocolClassImpl(0, returnMessageOnError), this.sccpStackImpl.newSls(), localSsn, calledParty, callingParty, data, hopCounter, importance);
    }

    public SccpDataMessage createDataMessageClass1(SccpAddress calledParty, SccpAddress callingParty, byte[] data, int sls, int localSsn, boolean returnMessageOnError, HopCounter hopCounter, Importance importance) {
        return new SccpDataMessageImpl(this.sccpStackImpl.getMaxDataMessage(), new ProtocolClassImpl(1, returnMessageOnError), sls, localSsn, calledParty, callingParty, data, hopCounter, importance);
    }

    public SccpNoticeMessage createNoticeMessage(int origMsgType, ReturnCause returnCause, SccpAddress calledParty, SccpAddress callingParty, byte[] data, HopCounter hopCounter, Importance importance) {
        int type = -1;
        switch (origMsgType) {
            case 9: {
                type = 10;
                break;
            }
            case 17: {
                type = 18;
                break;
            }
            case 19: {
                type = 20;
            }
        }
        return new SccpNoticeMessageImpl(this.sccpStackImpl.getMaxDataMessage(), type, returnCause, calledParty, callingParty, data, hopCounter, importance);
    }

    public SccpConnCrMessage createConnectMessageClass2(int localSsn, SccpAddress calledAddress, SccpAddress callingAddress, byte[] data, Importance importance) {
        SccpConnCrMessageImpl message = new SccpConnCrMessageImpl(this.sccpStackImpl.newSls(), localSsn);
        message.setCalledPartyAddress(calledAddress);
        message.setCallingPartyAddress(callingAddress);
        message.setProtocolClass(new ProtocolClassImpl(2));
        message.setUserData(data);
        message.setImportance(importance);
        return message;
    }

    public SccpConnCrMessage createConnectMessageClass3(int localSsn, SccpAddress calledAddress, SccpAddress callingAddress, Credit credit, byte[] data, Importance importance) {
        SccpConnCrMessageImpl message = new SccpConnCrMessageImpl(this.sccpStackImpl.newSls(), localSsn);
        message.setCalledPartyAddress(calledAddress);
        message.setCallingPartyAddress(callingAddress);
        message.setProtocolClass(new ProtocolClassImpl(3));
        message.setCredit(credit);
        message.setUserData(data);
        message.setImportance(importance);
        return message;
    }

    public SccpMessageImpl createMessage(int type, int opc, int dpc, int sls, InputStream in, SccpProtocolVersion sccpProtocolVersion, int networkId) throws ParseException {
        SccpMessageImpl msg = null;
        switch (type) {
            case 9: 
            case 17: 
            case 19: {
                msg = new SccpDataMessageImpl(this.sccpStackImpl.getMaxDataMessage(), type, opc, dpc, sls, networkId);
                break;
            }
            case 10: 
            case 18: 
            case 20: {
                msg = new SccpNoticeMessageImpl(this.sccpStackImpl.getMaxDataMessage(), type, opc, dpc, sls, networkId);
                break;
            }
            case 1: {
                msg = new SccpConnCrMessageImpl(opc, dpc, sls, networkId);
                break;
            }
            case 2: {
                msg = new SccpConnCcMessageImpl(opc, dpc, sls, networkId);
                break;
            }
            case 3: {
                msg = new SccpConnCrefMessageImpl(opc, dpc, sls, networkId);
                break;
            }
            case 4: {
                msg = new SccpConnRlsdMessageImpl(opc, dpc, sls, networkId);
                break;
            }
            case 5: {
                msg = new SccpConnRlcMessageImpl(opc, dpc, sls, networkId);
                break;
            }
            case 6: {
                msg = new SccpConnDt1MessageImpl(this.sccpStackImpl.getMaxDataMessage(), opc, dpc, sls, networkId);
                break;
            }
            case 7: {
                msg = new SccpConnDt2MessageImpl(this.sccpStackImpl.getMaxDataMessage(), opc, dpc, sls, networkId);
                break;
            }
            case 8: {
                msg = new SccpConnAkMessageImpl(opc, dpc, sls, networkId);
                break;
            }
            case 13: {
                msg = new SccpConnRsrMessageImpl(opc, dpc, sls, networkId);
                break;
            }
            case 14: {
                msg = new SccpConnRscMessageImpl(opc, dpc, sls, networkId);
                break;
            }
            case 15: {
                msg = new SccpConnErrMessageImpl(opc, dpc, sls, networkId);
                break;
            }
            case 16: {
                msg = new SccpConnItMessageImpl(opc, dpc, sls, networkId);
            }
        }
        if (msg != null) {
            ((SccpMessageImpl)msg).decode(in, this.sccpStackImpl.getSccpProvider().getParameterFactory(), sccpProtocolVersion);
        } else if (logger.isEnabledFor((Priority)Level.WARN)) {
            logger.warn((Object)("No message implementation for MT: " + type));
        }
        return msg;
    }
}

