/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.impl.congestion;

import java.util.concurrent.TimeUnit;
import org.mobicents.protocols.ss7.sccp.SccpCongestionControlAlgo;
import org.mobicents.protocols.ss7.sccp.SccpStack;
import org.mobicents.protocols.ss7.sccp.impl.SccpManagement;
import org.mobicents.protocols.ss7.sccp.impl.SccpStackImpl;

public class SccpCongestionControl {
    private SccpManagement sccpManagement;
    private SccpStack sccpStack;

    public SccpCongestionControl(SccpManagement sccpManagement, SccpStack sccpStack) {
        this.sccpManagement = sccpManagement;
        this.sccpStack = sccpStack;
    }

    public void scheduleTimer(Runnable timer, int delay) {
        this.sccpManagement.getManagementExecutors().schedule(timer, (long)delay, TimeUnit.MILLISECONDS);
    }

    public void onRestrictionLevelChange(int affectedPc, int newLevel, boolean levelEncreased) {
        this.sccpManagement.onRestrictionLevelChange(affectedPc, newLevel, levelEncreased);
    }

    public int getCongControlTIMER_A() {
        return this.sccpStack.getCongControlTIMER_A();
    }

    public int getCongControlTIMER_D() {
        return this.sccpStack.getCongControlTIMER_D();
    }

    public int getCongControlN() {
        return ((SccpStackImpl)this.sccpStack).getCongControlN();
    }

    public int getCongControlM() {
        return ((SccpStackImpl)this.sccpStack).getCongControlM();
    }

    public SccpCongestionControlAlgo getCongControl_Algo() {
        return this.sccpStack.getCongControl_Algo();
    }

    public boolean isCongControl_blockingOutgoungScpMessages() {
        return this.sccpStack.isCongControl_blockingOutgoungSccpMessages();
    }

    public static int generateSccpUserCongLevel(int restrictionLevel) {
        if (restrictionLevel <= 1) {
            return 0;
        }
        if (restrictionLevel <= 3) {
            return 1;
        }
        if (restrictionLevel <= 5) {
            return 2;
        }
        return 3;
    }

    public static int getMaxRestrictionLevelForMtp3Level(int mtp3Level) {
        if (mtp3Level == 1) {
            return 3;
        }
        if (mtp3Level == 2) {
            return 5;
        }
        return 8;
    }
}

