/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.impl;

import java.io.IOException;
import java.util.Map;
import javolution.util.FastMap;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.mobicents.protocols.ss7.indicator.RoutingIndicator;
import org.mobicents.protocols.ss7.mtp.Mtp3TransferPrimitive;
import org.mobicents.protocols.ss7.mtp.Mtp3TransferPrimitiveFactory;
import org.mobicents.protocols.ss7.mtp.Mtp3UserPart;
import org.mobicents.protocols.ss7.sccp.LoadSharingAlgorithm;
import org.mobicents.protocols.ss7.sccp.LongMessageRule;
import org.mobicents.protocols.ss7.sccp.LongMessageRuleType;
import org.mobicents.protocols.ss7.sccp.Mtp3ServiceAccessPoint;
import org.mobicents.protocols.ss7.sccp.RemoteSignalingPointCode;
import org.mobicents.protocols.ss7.sccp.RemoteSubSystem;
import org.mobicents.protocols.ss7.sccp.Rule;
import org.mobicents.protocols.ss7.sccp.RuleType;
import org.mobicents.protocols.ss7.sccp.SccpListener;
import org.mobicents.protocols.ss7.sccp.impl.SccpManagement;
import org.mobicents.protocols.ss7.sccp.impl.SccpProviderImpl;
import org.mobicents.protocols.ss7.sccp.impl.SccpStackImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.EncodingResultData;
import org.mobicents.protocols.ss7.sccp.impl.message.MessageFactoryImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpAddressedMessageImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpDataMessageImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpMessageImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpNoticeMessageImpl;
import org.mobicents.protocols.ss7.sccp.impl.parameter.ParameterFactoryImpl;
import org.mobicents.protocols.ss7.sccp.message.SccpDataMessage;
import org.mobicents.protocols.ss7.sccp.message.SccpNoticeMessage;
import org.mobicents.protocols.ss7.sccp.parameter.GlobalTitle;
import org.mobicents.protocols.ss7.sccp.parameter.ReturnCause;
import org.mobicents.protocols.ss7.sccp.parameter.ReturnCauseValue;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;

public class SccpRoutingControl {
    private static final Logger logger = Logger.getLogger(SccpRoutingControl.class);
    private SccpStackImpl sccpStackImpl = null;
    private SccpProviderImpl sccpProviderImpl = null;
    private SccpManagement sccpManagement = null;
    private MessageFactoryImpl messageFactory;
    private long lastCongAnnounseTime;

    public SccpRoutingControl(SccpProviderImpl sccpProviderImpl, SccpStackImpl sccpStackImpl) {
        this.messageFactory = sccpStackImpl.messageFactory;
        this.sccpProviderImpl = sccpProviderImpl;
        this.sccpStackImpl = sccpStackImpl;
    }

    public SccpManagement getSccpManagement() {
        return this.sccpManagement;
    }

    public void setSccpManagement(SccpManagement sccpManagement) {
        this.sccpManagement = sccpManagement;
    }

    public void start() {
    }

    public void stop() {
    }

    protected void routeMssgFromMtp(SccpAddressedMessageImpl msg) throws Exception {
        if (this.sccpStackImpl.isPreviewMode()) {
            int ssn = msg.getCalledPartyAddress().getSubsystemNumber();
            if (ssn == 1) {
                return;
            }
            FastMap<Integer, SccpListener> lstListn = this.sccpProviderImpl.getAllSccpListeners();
            for (Map.Entry val : lstListn.entrySet()) {
                SccpListener listener = (SccpListener)val.getValue();
                if (!(msg instanceof SccpDataMessage)) continue;
                this.deliverMessageToSccpUser(listener, (SccpDataMessage)msg);
            }
            return;
        }
        SccpAddress calledPartyAddress = msg.getCalledPartyAddress();
        RoutingIndicator ri = calledPartyAddress.getAddressIndicator().getRoutingIndicator();
        switch (ri) {
            case ROUTING_BASED_ON_DPC_AND_SSN: {
                int ssn = msg.getCalledPartyAddress().getSubsystemNumber();
                if (ssn == 1) {
                    if (msg instanceof SccpDataMessage) {
                        this.sccpManagement.onManagementMessage((SccpDataMessage)msg);
                    }
                    return;
                }
                SccpListener listener = this.sccpProviderImpl.getSccpListener(ssn);
                if (listener == null) {
                    this.sccpManagement.recdMsgForProhibitedSsn(msg, ssn);
                    if (logger.isEnabledFor((Priority)Level.WARN)) {
                        logger.warn((Object)String.format("Received SccpMessage=%s from MTP but the SSN is not available for local routing", msg));
                    }
                    this.sendSccpError(msg, ReturnCauseValue.SUBSYSTEM_FAILURE);
                    return;
                }
                try {
                    if (msg instanceof SccpDataMessage) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)String.format("Local deliver : SCCP Data Message=%s", msg.toString()));
                        }
                        this.deliverMessageToSccpUser(listener, (SccpDataMessage)msg);
                        break;
                    }
                    if (!(msg instanceof SccpNoticeMessage)) break;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)String.format("Local deliver : SCCP Notice Message=%s", msg.toString()));
                    }
                    listener.onNotice((SccpNoticeMessage)msg);
                }
                catch (Exception e) {
                    if (!logger.isEnabledFor((Priority)Level.WARN)) break;
                    logger.warn((Object)String.format("Exception from the listener side when delivering SccpData to ssn=%d: Message=%s", msg.getOriginLocalSsn(), msg), (Throwable)e);
                }
                break;
            }
            case ROUTING_BASED_ON_GLOBAL_TITLE: {
                this.translationFunction(msg);
                break;
            }
            default: {
                logger.error((Object)String.format("Invalid Routing Indictaor received for message=%s from MTP3", msg));
            }
        }
    }

    protected void routeMssgFromSccpUser(SccpAddressedMessageImpl msg) throws Exception {
        if (this.sccpStackImpl.isPreviewMode()) {
            return;
        }
        this.route(msg);
    }

    protected ReturnCauseValue send(SccpMessageImpl message) throws Exception {
        int dpc = message.getOutgoingDpc();
        int sls = message.getSls();
        RemoteSignalingPointCode remoteSpc = this.sccpStackImpl.getSccpResource().getRemoteSpcByPC(dpc);
        int currentRestrictionLevel = remoteSpc.getCurrentRestrictionLevel();
        int msgImportance = 8;
        if (message instanceof SccpDataMessageImpl) {
            msgImportance = 5;
        }
        if (message instanceof SccpNoticeMessageImpl) {
            msgImportance = 3;
        }
        if (this.sccpManagement.getSccpCongestionControl().isCongControl_blockingOutgoungScpMessages() && msgImportance < currentRestrictionLevel) {
            long curTime = System.currentTimeMillis();
            if (this.lastCongAnnounseTime + 1000L < curTime) {
                this.lastCongAnnounseTime = curTime;
                logger.warn((Object)String.format("Outgoing congestion control: SCCP: SccpMessage for sending=%s was dropped because of congestion level %d to dpc %d", message, currentRestrictionLevel, dpc));
            }
            return ReturnCauseValue.NETWORK_CONGESTION;
        }
        Mtp3ServiceAccessPoint sap = this.sccpStackImpl.router.findMtp3ServiceAccessPoint(dpc, sls, message.getNetworkId());
        if (sap == null) {
            if (logger.isEnabledFor((Priority)Level.WARN)) {
                logger.warn((Object)String.format("SccpMessage for sending=%s but no matching dpc=%d & sls=%d SAP found", message, dpc, sls));
            }
            return ReturnCauseValue.SCCP_FAILURE;
        }
        Mtp3UserPart mup = this.sccpStackImpl.getMtp3UserPart(sap.getMtp3Id());
        if (mup == null) {
            if (logger.isEnabledFor((Priority)Level.WARN)) {
                logger.warn((Object)String.format("SccpMessage for sending=%s but no matching Mtp3UserPart found for Id=%d", message, sap.getMtp3Id()));
            }
            return ReturnCauseValue.SCCP_FAILURE;
        }
        LongMessageRule lmr = this.sccpStackImpl.router.findLongMessageRule(dpc);
        LongMessageRuleType lmrt = LongMessageRuleType.LONG_MESSAGE_FORBBIDEN;
        if (lmr != null) {
            lmrt = lmr.getLongMessageRuleType();
        }
        EncodingResultData erd = message.encode(this.sccpStackImpl, lmrt, mup.getMaxUserDataLength(dpc), logger, this.sccpStackImpl.isRemoveSpc(), this.sccpStackImpl.getSccpProtocolVersion());
        switch (erd.getEncodingResult()) {
            case Success: {
                Mtp3TransferPrimitiveFactory factory = mup.getMtp3TransferPrimitiveFactory();
                if (erd.getSolidData() != null) {
                    Mtp3TransferPrimitive msg = factory.createMtp3TransferPrimitive(3, sap.getNi(), 0, sap.getOpc(), dpc, sls, erd.getSolidData());
                    mup.sendMessage(msg);
                } else {
                    for (byte[] bf : erd.getSegementedData()) {
                        Mtp3TransferPrimitive msg = factory.createMtp3TransferPrimitive(3, sap.getNi(), 0, sap.getOpc(), dpc, sls, bf);
                        mup.sendMessage(msg);
                    }
                }
                return null;
            }
            case ReturnFailure: {
                return erd.getReturnCause();
            }
        }
        String em = String.format("Error %s when encoding a SccpMessage\n%s", erd.getEncodingResult().toString(), message.toString());
        if (logger.isEnabledFor((Priority)Level.WARN)) {
            logger.warn((Object)em);
        }
        throw new IOException(em);
    }

    protected ReturnCauseValue sendManagementMessage(SccpDataMessageImpl message) throws Exception {
        int dpc = message.getOutgoingDpc();
        Mtp3ServiceAccessPoint sap = this.sccpStackImpl.router.findMtp3ServiceAccessPoint(dpc, 0);
        if (sap == null) {
            if (logger.isEnabledFor((Priority)Level.WARN)) {
                logger.warn((Object)String.format("Sccp management message for sending=%s but no matching dpc=%d SAP found", message, dpc));
            }
            return ReturnCauseValue.SCCP_FAILURE;
        }
        Mtp3UserPart mup = this.sccpStackImpl.getMtp3UserPart(sap.getMtp3Id());
        if (mup == null) {
            if (logger.isEnabledFor((Priority)Level.WARN)) {
                logger.warn((Object)String.format("Sccp management message for sending=%s but no matching Mtp3UserPart found for Id=%d", message, sap.getMtp3Id()));
            }
            return ReturnCauseValue.SCCP_FAILURE;
        }
        LongMessageRuleType lmrt = LongMessageRuleType.LONG_MESSAGE_FORBBIDEN;
        EncodingResultData erd = message.encode(this.sccpStackImpl, lmrt, mup.getMaxUserDataLength(dpc), logger, this.sccpStackImpl.isRemoveSpc(), this.sccpStackImpl.getSccpProtocolVersion());
        switch (erd.getEncodingResult()) {
            case Success: {
                Mtp3TransferPrimitiveFactory factory = mup.getMtp3TransferPrimitiveFactory();
                if (erd.getSolidData() == null) {
                    if (logger.isEnabledFor((Priority)Level.WARN)) {
                        logger.warn((Object)String.format("Sccp management message for sending=%s was encoded with segments, it is forbidded", message));
                    }
                    return ReturnCauseValue.SCCP_FAILURE;
                }
                Mtp3TransferPrimitive msg = factory.createMtp3TransferPrimitive(3, sap.getNi(), 0, sap.getOpc(), dpc, 0, erd.getSolidData());
                mup.sendMessage(msg);
                return null;
            }
            case ReturnFailure: {
                return erd.getReturnCause();
            }
        }
        String em = String.format("Error %s when encoding a SccpMessage\n%s", erd.getEncodingResult().toString(), message.toString());
        if (logger.isEnabledFor((Priority)Level.WARN)) {
            logger.warn((Object)em);
        }
        throw new IOException(em);
    }

    private TranslationAddressCheckingResult checkTranslationAddress(SccpAddressedMessageImpl msg, Rule rule, SccpAddress translationAddress, String destName) {
        if (translationAddress == null) {
            if (logger.isEnabledFor((Priority)Level.WARN)) {
                logger.warn((Object)String.format("Received SccpMessage=%s for Translation but no matching %s Address defined for Rule=%s for routing", msg, destName, rule));
            }
            return TranslationAddressCheckingResult.translationFailure;
        }
        if (!translationAddress.getAddressIndicator().isPCPresent()) {
            if (logger.isEnabledFor((Priority)Level.WARN)) {
                logger.warn((Object)String.format("Received SccpMessage=%s for Translation but no PC is present for %s Address ", msg, destName));
            }
            return TranslationAddressCheckingResult.translationFailure;
        }
        int targetSsn = translationAddress.getSubsystemNumber();
        if (targetSsn == 0) {
            targetSsn = msg.getCalledPartyAddress().getSubsystemNumber();
        }
        if (this.sccpStackImpl.router.spcIsLocal(translationAddress.getSignalingPointCode())) {
            if (targetSsn == 1 || this.sccpProviderImpl.getSccpListener(targetSsn) != null) {
                return TranslationAddressCheckingResult.destinationAvailable;
            }
            if (logger.isEnabledFor((Priority)Level.WARN)) {
                logger.warn((Object)String.format("Received SccpMessage=%s for Translation but no local SSN is present for %s Address ", msg, destName));
            }
            return TranslationAddressCheckingResult.destinationUnavailable_SubsystemFailure;
        }
        RemoteSignalingPointCode remoteSpc = this.sccpStackImpl.getSccpResource().getRemoteSpcByPC(translationAddress.getSignalingPointCode());
        if (remoteSpc == null) {
            if (logger.isEnabledFor((Priority)Level.WARN)) {
                logger.warn((Object)String.format("Received SccpMessage=%s for Translation but no %s Remote Signaling Pointcode = %d resource defined ", msg, destName, translationAddress.getSignalingPointCode()));
            }
            return TranslationAddressCheckingResult.translationFailure;
        }
        if (remoteSpc.isRemoteSpcProhibited()) {
            if (logger.isEnabledFor((Priority)Level.WARN)) {
                logger.warn((Object)String.format("Received SccpMessage=%s for Translation but %s Remote Signaling Pointcode = %d is prohibited ", msg, destName, translationAddress.getSignalingPointCode()));
            }
            return TranslationAddressCheckingResult.destinationUnavailable_MtpFailure;
        }
        if (remoteSpc.getCurrentRestrictionLevel() > 1) {
            if (logger.isEnabledFor((Priority)Level.WARN)) {
                logger.warn((Object)String.format("Received SccpMessage=%s for Translation but %s Remote Signaling Pointcode = %d is congested with level %d ", msg, destName, translationAddress.getSignalingPointCode(), remoteSpc.getCurrentRestrictionLevel()));
            }
            return TranslationAddressCheckingResult.destinationUnavailable_Congestion;
        }
        if (translationAddress.getAddressIndicator().getRoutingIndicator() == RoutingIndicator.ROUTING_BASED_ON_DPC_AND_SSN && targetSsn != 1) {
            RemoteSubSystem remoteSubSystem = this.sccpStackImpl.getSccpResource().getRemoteSsn(translationAddress.getSignalingPointCode(), targetSsn);
            if (remoteSubSystem == null) {
                if (logger.isEnabledFor((Priority)Level.WARN)) {
                    logger.warn((Object)String.format("Received SccpMessage=%s for Translation but no %s Remote SubSystem = %d (dpc=%d) resource defined ", msg, destName, targetSsn, translationAddress.getSignalingPointCode()));
                }
                return TranslationAddressCheckingResult.translationFailure;
            }
            if (remoteSubSystem.isRemoteSsnProhibited()) {
                if (logger.isEnabledFor((Priority)Level.WARN)) {
                    logger.warn((Object)String.format("Received SccpMessage=%s for Translation but %s Remote SubSystem = %d (dpc=%d) is prohibited ", msg, destName, targetSsn, translationAddress.getSignalingPointCode()));
                }
                return TranslationAddressCheckingResult.destinationUnavailable_SubsystemFailure;
            }
        }
        return TranslationAddressCheckingResult.destinationAvailable;
    }

    private void translationFunction(SccpAddressedMessageImpl msg) throws Exception {
        SccpAddress newCallingPartyAddress;
        SccpAddress callingPartyAddress;
        if (!msg.reduceHopCounter()) {
            if (logger.isEnabledFor((Priority)Level.WARN)) {
                logger.warn((Object)String.format("Received SccpMessage for Translation but hop counter violation detected\nSccpMessage=%s", msg));
            }
            this.sendSccpError(msg, ReturnCauseValue.HOP_COUNTER_VIOLATION);
            return;
        }
        SccpAddress calledPartyAddress = msg.getCalledPartyAddress();
        Rule rule = this.sccpStackImpl.router.findRule(calledPartyAddress, callingPartyAddress = msg.getCallingPartyAddress(), msg.getIsMtpOriginated(), msg.getNetworkId());
        if (rule == null) {
            if (logger.isEnabledFor((Priority)Level.WARN)) {
                logger.warn((Object)String.format("Received SccpMessage for Translation but no matching Rule found for local routing\nSccpMessage=%s", msg));
            }
            this.sendSccpError(msg, ReturnCauseValue.NO_TRANSLATION_FOR_ADDRESS);
            return;
        }
        SccpAddress translationAddressPri = this.sccpStackImpl.router.getRoutingAddress(rule.getPrimaryAddressId());
        TranslationAddressCheckingResult resPri = this.checkTranslationAddress(msg, rule, translationAddressPri, "primary");
        if (resPri == TranslationAddressCheckingResult.translationFailure) {
            this.sendSccpError(msg, ReturnCauseValue.NO_TRANSLATION_FOR_ADDRESS);
            return;
        }
        SccpAddress translationAddressSec = null;
        TranslationAddressCheckingResult resSec = TranslationAddressCheckingResult.destinationUnavailable_SubsystemFailure;
        if (rule.getRuleType() != RuleType.SOLITARY && (resSec = this.checkTranslationAddress(msg, rule, translationAddressSec = this.sccpStackImpl.router.getRoutingAddress(rule.getSecondaryAddressId()), "secondary")) == TranslationAddressCheckingResult.translationFailure) {
            this.sendSccpError(msg, ReturnCauseValue.NO_TRANSLATION_FOR_ADDRESS);
            return;
        }
        if (resPri != TranslationAddressCheckingResult.destinationAvailable && resPri != TranslationAddressCheckingResult.destinationUnavailable_Congestion && resSec != TranslationAddressCheckingResult.destinationAvailable && resSec != TranslationAddressCheckingResult.destinationUnavailable_Congestion) {
            switch (resPri) {
                case destinationUnavailable_SubsystemFailure: {
                    this.sendSccpError(msg, ReturnCauseValue.SUBSYSTEM_FAILURE);
                    return;
                }
                case destinationUnavailable_MtpFailure: {
                    this.sendSccpError(msg, ReturnCauseValue.MTP_FAILURE);
                    return;
                }
                case destinationUnavailable_Congestion: {
                    this.sendSccpError(msg, ReturnCauseValue.NETWORK_CONGESTION);
                    return;
                }
            }
            this.sendSccpError(msg, ReturnCauseValue.SCCP_FAILURE);
            return;
        }
        SccpAddress translationAddress = null;
        SccpAddress translationAddress2 = null;
        if (resPri == TranslationAddressCheckingResult.destinationAvailable && resSec != TranslationAddressCheckingResult.destinationAvailable) {
            translationAddress = translationAddressPri;
        } else if (resPri != TranslationAddressCheckingResult.destinationAvailable && resSec == TranslationAddressCheckingResult.destinationAvailable) {
            translationAddress = translationAddressSec;
        } else if (resPri == TranslationAddressCheckingResult.destinationUnavailable_Congestion && resSec != TranslationAddressCheckingResult.destinationAvailable) {
            translationAddress = translationAddressPri;
        } else if (resPri != TranslationAddressCheckingResult.destinationAvailable && resSec == TranslationAddressCheckingResult.destinationUnavailable_Congestion) {
            translationAddress = translationAddressSec;
        } else {
            switch (rule.getRuleType()) {
                case SOLITARY: 
                case DOMINANT: {
                    translationAddress = translationAddressPri;
                    break;
                }
                case LOADSHARED: {
                    if (msg.getSccpCreatesSls()) {
                        if (this.sccpStackImpl.newSelector()) {
                            translationAddress = translationAddressPri;
                            break;
                        }
                        translationAddress = translationAddressSec;
                        break;
                    }
                    if (this.selectLoadSharingRoute(rule.getLoadSharingAlgorithm(), msg)) {
                        translationAddress = translationAddressPri;
                        break;
                    }
                    translationAddress = translationAddressSec;
                    break;
                }
                case BROADCAST: {
                    translationAddress = translationAddressPri;
                    translationAddress2 = translationAddressSec;
                }
            }
        }
        if (rule.getNewCallingPartyAddressId() != null && (newCallingPartyAddress = this.sccpStackImpl.router.getRoutingAddress(rule.getNewCallingPartyAddressId())) != null) {
            msg.setCallingPartyAddress(newCallingPartyAddress);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("New CallingPartyAddress assigned after translation = %s", newCallingPartyAddress));
            }
        }
        SccpAddress address = rule.translate(calledPartyAddress, translationAddress);
        msg.setCalledPartyAddress(address);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Matching rule found: [%s] CalledPartyAddress after translation = %s", rule, address));
        }
        this.route(msg);
        if (translationAddress2 != null) {
            address = rule.translate(calledPartyAddress, translationAddress2);
            msg.setCalledPartyAddress(address);
            msg.clearReturnMessageOnError();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("CalledPartyAddress after translation - a second broadcast address = %s", address));
            }
            this.route(msg);
        }
    }

    private boolean selectLoadSharingRoute(LoadSharingAlgorithm loadSharingAlgo, SccpAddressedMessageImpl msg) {
        if (loadSharingAlgo == LoadSharingAlgorithm.Bit4) {
            return (msg.getSls() & 0x10) == 0;
        }
        if (loadSharingAlgo == LoadSharingAlgorithm.Bit3) {
            return (msg.getSls() & 8) == 0;
        }
        if (loadSharingAlgo == LoadSharingAlgorithm.Bit2) {
            return (msg.getSls() & 4) == 0;
        }
        if (loadSharingAlgo == LoadSharingAlgorithm.Bit1) {
            return (msg.getSls() & 2) == 0;
        }
        if (loadSharingAlgo == LoadSharingAlgorithm.Bit0) {
            return (msg.getSls() & 1) == 0;
        }
        return true;
    }

    private void route(SccpAddressedMessageImpl msg) throws Exception {
        block38: {
            SccpAddress calledPartyAddress = msg.getCalledPartyAddress();
            int dpc = calledPartyAddress.getSignalingPointCode();
            int ssn = calledPartyAddress.getSubsystemNumber();
            GlobalTitle gt = calledPartyAddress.getGlobalTitle();
            if (calledPartyAddress.getAddressIndicator().isPCPresent()) {
                if (this.sccpStackImpl.router.spcIsLocal(dpc)) {
                    if (ssn > 0) {
                        if (ssn == 1) {
                            if (msg instanceof SccpDataMessage) {
                                this.sccpManagement.onManagementMessage((SccpDataMessage)msg);
                            }
                            return;
                        }
                        SccpListener listener = this.sccpProviderImpl.getSccpListener(ssn);
                        if (listener == null) {
                            if (logger.isEnabledFor((Priority)Level.WARN)) {
                                logger.warn((Object)String.format("Received SccpMessage=%s for routing but the SSN is not available for local routing", msg));
                            }
                            this.sendSccpError(msg, ReturnCauseValue.SUBSYSTEM_FAILURE);
                            return;
                        }
                        try {
                            if (msg instanceof SccpDataMessage) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)String.format("Local deliver : SCCP Data Message=%s", msg.toString()));
                                }
                                this.deliverMessageToSccpUser(listener, (SccpDataMessage)msg);
                            } else if (msg instanceof SccpNoticeMessage) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)String.format("Local deliver : SCCP Notice Message=%s", msg.toString()));
                                }
                                listener.onNotice((SccpNoticeMessage)msg);
                            }
                            break block38;
                        }
                        catch (Exception e) {
                            if (logger.isEnabledFor((Priority)Level.WARN)) {
                                logger.warn((Object)String.format("Exception from the listener side when delivering SccpData to ssn=%d: Message=%s", msg.getOriginLocalSsn(), msg), (Throwable)e);
                            }
                            break block38;
                        }
                    }
                    if (gt != null) {
                        if (calledPartyAddress.isTranslated()) {
                            logger.error((Object)String.format("Droping message. Received SCCPMessage=%s for routing but CalledPartyAddress is already translated once", msg));
                            this.sendSccpError(msg, ReturnCauseValue.SCCP_FAILURE);
                            return;
                        }
                        this.translationFunction(msg);
                    } else {
                        logger.error((Object)String.format("Received SCCPMessage=%s for routing, but neither SSN nor GT present", msg));
                        this.sendSccpError(msg, ReturnCauseValue.NO_TRANSLATION_FOR_NATURE);
                    }
                } else {
                    RemoteSignalingPointCode remoteSpc = this.sccpStackImpl.getSccpResource().getRemoteSpcByPC(dpc);
                    if (remoteSpc == null) {
                        if (logger.isEnabledFor((Priority)Level.WARN)) {
                            logger.warn((Object)String.format("Received SccpMessage=%s for routing but no Remote Signaling Pointcode = %d resource defined ", msg, dpc));
                        }
                        this.sendSccpError(msg, ReturnCauseValue.SCCP_FAILURE);
                        return;
                    }
                    if (remoteSpc.isRemoteSpcProhibited()) {
                        if (logger.isEnabledFor((Priority)Level.WARN)) {
                            logger.warn((Object)String.format("Received SccpMessage=%s for routing but Remote Signaling Pointcode = %d is prohibited", msg, dpc));
                        }
                        this.sendSccpError(msg, ReturnCauseValue.MTP_FAILURE);
                        return;
                    }
                    if (ssn > 1) {
                        if (calledPartyAddress.getAddressIndicator().getRoutingIndicator() == RoutingIndicator.ROUTING_BASED_ON_DPC_AND_SSN) {
                            RemoteSubSystem remoteSsn = this.sccpStackImpl.getSccpResource().getRemoteSsn(dpc, calledPartyAddress.getSubsystemNumber());
                            if (remoteSsn == null) {
                                if (logger.isEnabledFor((Priority)Level.WARN)) {
                                    logger.warn((Object)String.format("Received SCCPMessage=%s for routing, but no Remote SubSystem = %d resource defined ", msg, calledPartyAddress.getSubsystemNumber()));
                                }
                                this.sendSccpError(msg, ReturnCauseValue.SCCP_FAILURE);
                                return;
                            }
                            if (remoteSsn.isRemoteSsnProhibited()) {
                                if (logger.isEnabledFor((Priority)Level.WARN)) {
                                    logger.warn((Object)String.format("Routing of Sccp Message=%s failed as Remote SubSystem = %d is prohibited ", msg, calledPartyAddress.getSubsystemNumber()));
                                }
                                this.sendSccpError(msg, ReturnCauseValue.SUBSYSTEM_FAILURE);
                                return;
                            }
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)String.format("Tx : SCCP Message=%s", msg.toString()));
                        }
                        this.sendMessageToMtp(msg);
                    } else if (gt != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)String.format("Tx : SCCP Message=%s", msg.toString()));
                        }
                        this.sendMessageToMtp(msg);
                    } else {
                        logger.error((Object)String.format("Received SCCPMessage=%s for routing, but neither SSN nor GT present", msg));
                        this.sendSccpError(msg, ReturnCauseValue.NO_TRANSLATION_FOR_NATURE);
                    }
                }
            } else {
                if (gt == null) {
                    if (logger.isEnabledFor((Priority)Level.WARN)) {
                        logger.warn((Object)String.format("Received SccpMessage=%s for routing from local SCCP user part but no pointcode and no GT or SSN included", msg, dpc));
                    }
                    this.sendSccpError(msg, ReturnCauseValue.NO_TRANSLATION_FOR_NATURE);
                    return;
                }
                if (calledPartyAddress.isTranslated()) {
                    logger.error((Object)String.format("Droping message. Received SCCPMessage=%s for Routing , but CalledPartyAddress is already translated once", msg));
                    this.sendSccpError(msg, ReturnCauseValue.SCCP_FAILURE);
                    return;
                }
                this.translationFunction(msg);
            }
        }
    }

    private void deliverMessageToSccpUser(SccpListener listener, SccpDataMessage msg) {
        if (msg.getIsMtpOriginated()) {
            listener.onMessage(msg);
        } else {
            int seqControl = msg.getSls();
            SccpTransferDeliveryHandler hdl = new SccpTransferDeliveryHandler(msg, listener);
            this.sccpStackImpl.msgDeliveryExecutors[this.sccpStackImpl.slsTable[seqControl &= this.sccpStackImpl.slsFilter]].execute(hdl);
        }
    }

    protected void sendMessageToMtp(SccpAddressedMessageImpl msg) throws Exception {
        msg.setOutgoingDpc(msg.getCalledPartyAddress().getSignalingPointCode());
        ReturnCauseValue er = this.send(msg);
        if (er != null) {
            this.sendSccpError(msg, er);
        }
    }

    protected void sendSccpError(SccpAddressedMessageImpl msg, ReturnCauseValue returnCauseInt) throws Exception {
        block10: {
            if (!msg.getReturnMessageOnError()) {
                return;
            }
            SccpNoticeMessageImpl ans = null;
            ReturnCause returnCause = ((ParameterFactoryImpl)this.sccpProviderImpl.getParameterFactory()).createReturnCause(returnCauseInt);
            if (msg instanceof SccpDataMessageImpl) {
                SccpDataMessageImpl msgData = (SccpDataMessageImpl)msg;
                ans = (SccpNoticeMessageImpl)this.messageFactory.createNoticeMessage(msg.getType(), returnCause, msg.getCallingPartyAddress(), msg.getCalledPartyAddress(), msgData.getData(), msgData.getHopCounter(), msgData.getImportance());
            }
            if (ans != null) {
                if (msg.getIsMtpOriginated()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)String.format("sendSccpError to a remote user: SCCP Message=%s", msg.toString()));
                    }
                    this.route(ans);
                } else {
                    SccpListener listener;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)String.format("sendSccpError to a local user: SCCP Message=%s", msg.toString()));
                    }
                    if ((listener = this.sccpProviderImpl.getSccpListener(msg.getOriginLocalSsn())) != null) {
                        try {
                            listener.onNotice(ans);
                        }
                        catch (Exception e) {
                            if (!logger.isEnabledFor((Priority)Level.WARN)) break block10;
                            logger.warn((Object)String.format("Exception from the listener side when delivering SccpNotice to ssn=%d: Message=%s", msg.getOriginLocalSsn(), msg), (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    private class SccpTransferDeliveryHandler
    implements Runnable {
        private SccpDataMessage msg;
        private SccpListener listener;

        public SccpTransferDeliveryHandler(SccpDataMessage msg, SccpListener listener) {
            this.msg = msg;
            this.listener = listener;
        }

        @Override
        public void run() {
            if (SccpRoutingControl.this.sccpStackImpl.isStarted()) {
                try {
                    this.listener.onMessage(this.msg);
                }
                catch (Exception e) {
                    logger.error((Object)("Exception while delivering a system messages to the SCCP-user: " + e.getMessage()), (Throwable)e);
                }
            } else {
                logger.error((Object)String.format("Received SccpDataMessage=%s but SccpStack is not started. Message will be dropped", this.msg));
            }
        }
    }

    private static enum TranslationAddressCheckingResult {
        destinationAvailable,
        destinationUnavailable_SubsystemFailure,
        destinationUnavailable_MtpFailure,
        destinationUnavailable_Congestion,
        translationFailure;

    }
}

