/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.APN;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.PDNGWIdentity;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.SpecificAPNInfo;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.primitives.SequenceBase;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.APNImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.PDNGWIdentityImpl;

public class SpecificAPNInfoImpl
extends SequenceBase
implements SpecificAPNInfo {
    private static final int _TAG_apn = 0;
    private static final int _TAG_pdnGwIdentity = 1;
    private static final int _TAG_extensionContainer = 2;
    private APN apn;
    private PDNGWIdentity pdnGwIdentity;
    private MAPExtensionContainer extensionContainer;

    public SpecificAPNInfoImpl() {
        super("SpecificAPNInfo");
    }

    public SpecificAPNInfoImpl(APN apn, PDNGWIdentity pdnGwIdentity, MAPExtensionContainer extensionContainer) {
        super("SpecificAPNInfo");
        this.apn = apn;
        this.pdnGwIdentity = pdnGwIdentity;
        this.extensionContainer = extensionContainer;
    }

    public APN getAPN() {
        return this.apn;
    }

    public PDNGWIdentity getPdnGwIdentity() {
        return this.pdnGwIdentity;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    @Override
    protected void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.apn = null;
        this.pdnGwIdentity = null;
        this.extensionContainer = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        block8: while (ais.available() != 0) {
            int tag = ais.readTag();
            switch (ais.getTagClass()) {
                case 2: {
                    switch (tag) {
                        case 0: {
                            if (!ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".apn: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.apn = new APNImpl();
                            ((APNImpl)this.apn).decodeAll(ais);
                            continue block8;
                        }
                        case 1: {
                            if (ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".pdnGwIdentity: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.pdnGwIdentity = new PDNGWIdentityImpl();
                            ((PDNGWIdentityImpl)this.pdnGwIdentity).decodeAll(ais);
                            continue block8;
                        }
                        case 2: {
                            if (ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".extensionContainer: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.extensionContainer = new MAPExtensionContainerImpl();
                            ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                            continue block8;
                        }
                    }
                    ais.advanceElement();
                    continue block8;
                }
            }
            ais.advanceElement();
        }
        if (this.apn == null) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parament apn is mandatory but does not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (this.pdnGwIdentity == null) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parament pdnGwIdentity is mandatory but does not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.apn == null) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + " the mandatory parameter apn is not defined");
        }
        if (this.pdnGwIdentity == null) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + " the mandatory parameter pdnGwIdentity is not defined");
        }
        ((APNImpl)this.apn).encodeAll(asnOs, 2, 0);
        ((PDNGWIdentityImpl)this.pdnGwIdentity).encodeAll(asnOs, 2, 1);
        if (this.extensionContainer != null) {
            ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 2);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName + " [");
        if (this.apn != null) {
            sb.append("apn=");
            sb.append(this.apn.toString());
            sb.append(", ");
        }
        if (this.pdnGwIdentity != null) {
            sb.append("pdnGwIdentity=");
            sb.append(this.pdnGwIdentity.toString());
            sb.append(", ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer.toString());
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }
}

