/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.BitSetStrictLength;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.OfferedCamel4CSIs;
import org.mobicents.protocols.ss7.map.primitives.BitStringBase;

public class OfferedCamel4CSIsImpl
extends BitStringBase
implements OfferedCamel4CSIs {
    private static final int _ID_o_csi = 0;
    private static final int _ID_d_csi = 1;
    private static final int _ID_vt_csi = 2;
    private static final int _ID_t_csi = 3;
    private static final int _ID_mt_sms_csi = 4;
    private static final int _ID_mg_csi = 5;
    private static final int _ID_psi_enhancements = 6;
    private boolean badDecoded;

    public OfferedCamel4CSIsImpl() {
        super(7, 16, 7, "OfferedCamel4CSIs");
    }

    public OfferedCamel4CSIsImpl(boolean oCsi, boolean dCsi, boolean vtCsi, boolean tCsi, boolean mtSMSCsi, boolean mgCsi, boolean psiEnhancements) {
        super(7, 16, 7, "OfferedCamel4CSIs");
        if (oCsi) {
            this.bitString.set(0);
        }
        if (dCsi) {
            this.bitString.set(1);
        }
        if (vtCsi) {
            this.bitString.set(2);
        }
        if (tCsi) {
            this.bitString.set(3);
        }
        if (mtSMSCsi) {
            this.bitString.set(4);
        }
        if (mgCsi) {
            this.bitString.set(5);
        }
        if (psiEnhancements) {
            this.bitString.set(6);
        }
    }

    public boolean getOCsi() {
        return this.bitString.get(0);
    }

    public boolean getDCsi() {
        return this.bitString.get(1);
    }

    public boolean getVtCsi() {
        return this.bitString.get(2);
    }

    public boolean getTCsi() {
        return this.bitString.get(3);
    }

    public boolean getMtSmsCsi() {
        return this.bitString.get(4);
    }

    public boolean getMgCsi() {
        return this.bitString.get(5);
    }

    public boolean isBadDecoded() {
        return this.badDecoded;
    }

    @Override
    protected void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        if (length == 1) {
            this.bitString = new BitSetStrictLength(0);
            this.badDecoded = true;
            int n = ansIS.read();
        } else {
            super._decode(ansIS, length);
        }
    }

    public boolean getPsiEnhancements() {
        return this.bitString.get(6);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OfferedCamel4CSIs [");
        if (this.getOCsi()) {
            sb.append("o_csi, ");
        }
        if (this.getDCsi()) {
            sb.append("d_csi, ");
        }
        if (this.getVtCsi()) {
            sb.append("vt_csi, ");
        }
        if (this.getTCsi()) {
            sb.append("t_csi, ");
        }
        if (this.getMtSmsCsi()) {
            sb.append("mt_sms_csi, ");
        }
        if (this.getMgCsi()) {
            sb.append("mg_csi, ");
        }
        if (this.getPsiEnhancements()) {
            sb.append("psi_enhancements, ");
        }
        sb.append("]");
        return sb.toString();
    }
}

