/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement;

import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.LSAAttributes;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.LSAIdentificationPriorityValue;
import org.mobicents.protocols.ss7.map.primitives.OctetStringLength1Base;

public class LSAAttributesImpl
extends OctetStringLength1Base
implements LSAAttributes {
    private static int preferentialAccess_mask = 16;
    private static int activeModeSupport_mask = 32;
    private static int lsaIdentificationPriority_mask = 15;

    public LSAAttributesImpl() {
        super("LSAAttributes");
    }

    public LSAAttributesImpl(int data) {
        super("LSAAttributes", data);
    }

    public LSAAttributesImpl(LSAIdentificationPriorityValue value, boolean preferentialAccessAvailable, boolean activeModeSupportAvailable) {
        super("LSAAttributes", value.getCode() | (preferentialAccessAvailable ? preferentialAccess_mask : 0) | (activeModeSupportAvailable ? activeModeSupport_mask : 0));
    }

    public int getData() {
        return this.data;
    }

    public LSAIdentificationPriorityValue getLSAIdentificationPriority() {
        return LSAIdentificationPriorityValue.getInstance((int)(this.data & lsaIdentificationPriority_mask));
    }

    public boolean isPreferentialAccessAvailable() {
        return (this.data & preferentialAccess_mask) == preferentialAccess_mask;
    }

    public boolean isActiveModeSupportAvailable() {
        return (this.data & activeModeSupport_mask) == activeModeSupport_mask;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        sb.append("  LSAIdentificationPriorityValue=");
        sb.append(this.getLSAIdentificationPriority());
        if (this.isPreferentialAccessAvailable()) {
            sb.append(" , PreferentialAccessAvailable ");
        }
        if (this.isActiveModeSupportAvailable()) {
            sb.append(" , ActiveModeSupportAvailable ");
        }
        sb.append(", Data=");
        sb.append(this.data);
        sb.append("]");
        return sb.toString();
    }
}

