/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.CUGInterlock;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.CUGSubscription;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.ExtBasicServiceCode;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.IntraCUGOptions;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.primitives.SequenceBase;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.CUGInterlockImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.ExtBasicServiceCodeImpl;

public class CUGSubscriptionImpl
extends SequenceBase
implements CUGSubscription {
    private static final int _TAG_extensionContainer = 0;
    private int cugIndex;
    private CUGInterlock cugInterlock = null;
    private IntraCUGOptions intraCugOptions = null;
    private ArrayList<ExtBasicServiceCode> basicService = null;
    private MAPExtensionContainer extensionContainer = null;

    public CUGSubscriptionImpl() {
        super("CUGSubscription");
    }

    public CUGSubscriptionImpl(int cugIndex, CUGInterlock cugInterlock, IntraCUGOptions intraCugOptions, ArrayList<ExtBasicServiceCode> basicService, MAPExtensionContainer extensionContainer) {
        super("CUGSubscription");
        this.cugIndex = cugIndex;
        this.cugInterlock = cugInterlock;
        this.intraCugOptions = intraCugOptions;
        this.basicService = basicService;
        this.extensionContainer = extensionContainer;
    }

    public int getCUGIndex() {
        return this.cugIndex;
    }

    public CUGInterlock getCugInterlock() {
        return this.cugInterlock;
    }

    public IntraCUGOptions getIntraCugOptions() {
        return this.intraCugOptions;
    }

    public ArrayList<ExtBasicServiceCode> getBasicServiceGroupList() {
        return this.basicService;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    @Override
    protected void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.cugIndex = 0;
        this.cugInterlock = null;
        this.intraCugOptions = null;
        this.basicService = null;
        this.extensionContainer = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            block0 : switch (num) {
                case 0: {
                    if (!ais.isTagPrimitive() || tag != 2 || ais.getTagClass() != 0) {
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".cugIndex: bad tag or tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.cugIndex = (int)ais.readInteger();
                    break;
                }
                case 1: {
                    if (!ais.isTagPrimitive() || tag != 4 || ais.getTagClass() != 0) {
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".cugInterlock: bad tag or tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.cugInterlock = new CUGInterlockImpl();
                    ((CUGInterlockImpl)this.cugInterlock).decodeAll(ais);
                    break;
                }
                case 2: {
                    if (!ais.isTagPrimitive() || tag != 10 || ais.getTagClass() != 0) {
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".intraCugOptions: bad tag or tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    int i1 = (int)ais.readInteger();
                    this.intraCugOptions = IntraCUGOptions.getInstance((int)i1);
                    break;
                }
                default: {
                    switch (ais.getTagClass()) {
                        case 2: {
                            switch (tag) {
                                case 0: {
                                    if (ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".extensionContainer: is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.extensionContainer = new MAPExtensionContainerImpl();
                                    ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                                    break block0;
                                }
                            }
                            ais.advanceElement();
                            break block0;
                        }
                        case 0: {
                            switch (tag) {
                                case 16: {
                                    if (ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".basicService: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.basicService = new ArrayList();
                                    AsnInputStream ais2a = ais.readSequenceStream();
                                    while (ais2a.available() != 0) {
                                        int tag2a = ais2a.readTag();
                                        ExtBasicServiceCodeImpl basicServiceItem = new ExtBasicServiceCodeImpl();
                                        basicServiceItem.decodeAll(ais2a);
                                        this.basicService.add(basicServiceItem);
                                    }
                                    if (this.basicService.size() >= 1 && this.basicService.size() <= 32) break block0;
                                    throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".basicService: basicServiceGroupList must be from 1 to 32 size, found: " + this.basicService.size(), MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                default: {
                                    ais.advanceElement();
                                    break;
                                }
                            }
                            break block0;
                        }
                        default: {
                            ais.advanceElement();
                        }
                    }
                }
            }
            ++num;
        }
        if (num < 3) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": cugIndex, cugInterlock and intraCugOptions required, found only mandatory parameters: " + num, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.cugInterlock == null) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + ": cugInterlock required.");
        }
        if (this.intraCugOptions == null) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + ": intraCugOptions required.");
        }
        try {
            asnOs.writeInteger((long)this.cugIndex);
            ((CUGInterlockImpl)this.cugInterlock).encodeAll(asnOs);
            asnOs.writeInteger(0, 10, (long)this.intraCugOptions.getCode());
            if (this.basicService != null) {
                if (this.basicService.size() < 1 || this.basicService.size() > 32) {
                    throw new MAPException("Error while encoding " + this._PrimitiveName + ".basicService: basicServiceGroupList must be from 1 to 32 size, found: " + this.basicService.size());
                }
                asnOs.writeTag(0, false, 16);
                int pos = asnOs.StartContentDefiniteLength();
                for (ExtBasicServiceCode be : this.basicService) {
                    ExtBasicServiceCodeImpl bee = (ExtBasicServiceCodeImpl)be;
                    bee.encodeAll(asnOs);
                }
                asnOs.FinalizeContent(pos);
            }
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 0);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName + " [");
        sb.append("cugIndex=");
        sb.append(this.cugIndex);
        sb.append(", ");
        if (this.cugInterlock != null) {
            sb.append("cugInterlock=");
            sb.append(this.cugInterlock.toString());
            sb.append(", ");
        }
        if (this.intraCugOptions != null) {
            sb.append("intraCugOptions=");
            sb.append(this.intraCugOptions.toString());
            sb.append(", ");
        }
        if (this.basicService != null) {
            sb.append("basicService=[");
            boolean firstItem = true;
            for (ExtBasicServiceCode be : this.basicService) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                sb.append(be.toString());
            }
            sb.append("], ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer.toString());
        }
        sb.append("], ");
        return sb.toString();
    }
}

