/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.subscriberInformation;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.CallWaitingData;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.ExtCwFeature;
import org.mobicents.protocols.ss7.map.primitives.SequenceBase;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberInformation.ExtCwFeatureImpl;

public class CallWaitingDataImpl
extends SequenceBase
implements CallWaitingData {
    private static final int _TAG_CW_FEATURE_LIST = 1;
    private static final int _TAG_NOTIFICATION_TO_CSE = 2;
    private ArrayList<ExtCwFeature> cwFeatureList;
    private boolean notificationToCSE;

    public CallWaitingDataImpl() {
        super("CallWaitingData");
    }

    public CallWaitingDataImpl(ArrayList<ExtCwFeature> cwFeatureList, boolean notificationToCSE) {
        super("CallWaitingData");
        this.cwFeatureList = cwFeatureList;
        this.notificationToCSE = notificationToCSE;
    }

    public ArrayList<ExtCwFeature> getCwFeatureList() {
        return this.cwFeatureList;
    }

    public boolean getNotificationToCSE() {
        return this.notificationToCSE;
    }

    @Override
    protected void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.cwFeatureList = null;
        this.notificationToCSE = false;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        block4: while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 1: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter cwFeatureList is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.cwFeatureList = new ArrayList();
                        AsnInputStream ais2 = ais.readSequenceStream();
                        while (ais2.available() != 0) {
                            if (ais2.readTag() != 16 || ais2.getTagClass() != 0 || ais2.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".extCwFeature: Parameter extCwFeature is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            ExtCwFeatureImpl extCwFeature = new ExtCwFeatureImpl();
                            extCwFeature.decodeAll(ais2);
                            this.cwFeatureList.add(extCwFeature);
                        }
                        if (this.cwFeatureList.size() >= 1 && this.cwFeatureList.size() <= 32) continue block4;
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter cwFeatureList size must be from 1 to 10, found: " + this.cwFeatureList.size(), MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    case 2: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter notificationToCSE is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        ais.readNull();
                        this.notificationToCSE = Boolean.TRUE;
                        break;
                    }
                    default: {
                        ais.advanceElement();
                        break;
                    }
                }
                continue;
            }
            ais.advanceElement();
        }
        if (this.cwFeatureList == null) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + "cwFeatureList is mandatory but it is absent", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.cwFeatureList == null) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + " the mandatory parameter cwFeatureList is not defined");
        }
        if (this.cwFeatureList.size() < 1 || this.cwFeatureList.size() > 32) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + " size cwFeatureList is out of range (1..10). Actual size: " + this.cwFeatureList.size());
        }
        try {
            asnOs.writeTag(2, false, 1);
            int pos = asnOs.StartContentDefiniteLength();
            for (ExtCwFeature extCwFeature : this.cwFeatureList) {
                ((ExtCwFeatureImpl)extCwFeature).encodeAll(asnOs);
            }
            asnOs.FinalizeContent(pos);
            if (this.notificationToCSE) {
                asnOs.writeNull(2, 2);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException ae) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + ae.getMessage(), (Throwable)ae);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        if (this.cwFeatureList != null) {
            sb.append("cwFeatureList=[");
            boolean firstItem = true;
            for (ExtCwFeature extCwFeature : this.cwFeatureList) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                sb.append(extCwFeature);
            }
            sb.append("], ");
        }
        if (this.notificationToCSE) {
            sb.append("isNotificationToCSE, ");
        }
        sb.append("]");
        return sb.toString();
    }
}

