/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.faultRecovery;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPMessageType;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.IMSI;
import org.mobicents.protocols.ss7.map.api.primitives.LMSI;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.mobility.faultRecovery.RestoreDataRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.VLRCapability;
import org.mobicents.protocols.ss7.map.primitives.IMSIImpl;
import org.mobicents.protocols.ss7.map.primitives.LMSIImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.service.mobility.MobilityMessageImpl;
import org.mobicents.protocols.ss7.map.service.mobility.locationManagement.VLRCapabilityImpl;

public class RestoreDataRequestImpl
extends MobilityMessageImpl
implements RestoreDataRequest {
    protected static final int _TAG_vlr_Capability = 6;
    protected static final int _TAG_restorationIndicator = 7;
    public static final String _PrimitiveName = "RestoreDataRequest";
    private IMSI imsi;
    private LMSI lmsi;
    private VLRCapability vlrCapability;
    private MAPExtensionContainer extensionContainer;
    private boolean restorationIndicator;

    public RestoreDataRequestImpl() {
    }

    public RestoreDataRequestImpl(IMSI imsi, LMSI lmsi, VLRCapability vlrCapability, MAPExtensionContainer extensionContainer, boolean restorationIndicator) {
        this.imsi = imsi;
        this.lmsi = lmsi;
        this.vlrCapability = vlrCapability;
        this.extensionContainer = extensionContainer;
        this.restorationIndicator = restorationIndicator;
    }

    public MAPMessageType getMessageType() {
        return MAPMessageType.RestoreData_Request;
    }

    public int getOperationCode() {
        return 57;
    }

    public IMSI getImsi() {
        return this.imsi;
    }

    public LMSI getLmsi() {
        return this.lmsi;
    }

    public VLRCapability getVLRCapability() {
        return this.vlrCapability;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public boolean getRestorationIndicator() {
        return this.restorationIndicator;
    }

    @Override
    public int getTag() throws MAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding RestoreDataRequest: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding RestoreDataRequest: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding RestoreDataRequest: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding RestoreDataRequest: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.imsi = null;
        this.lmsi = null;
        this.vlrCapability = null;
        this.extensionContainer = null;
        this.restorationIndicator = false;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            block0 : switch (num) {
                case 0: {
                    if (ais.getTagClass() != 0 || !ais.isTagPrimitive() || tag != 4) {
                        throw new MAPParsingComponentException("Error while decoding RestoreDataRequest.imsi: Parameter 0 (IMSI) bad tag or tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.imsi = new IMSIImpl();
                    ((IMSIImpl)this.imsi).decodeAll(ais);
                    break;
                }
                default: {
                    if (ais.getTagClass() == 2) {
                        switch (tag) {
                            case 6: {
                                if (ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding RestoreDataRequest.vlr_Capability: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.vlrCapability = new VLRCapabilityImpl();
                                ((VLRCapabilityImpl)this.vlrCapability).decodeAll(ais);
                                break block0;
                            }
                            case 7: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding RestoreDataRequest.restorationIndicator: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                ais.readNull();
                                this.restorationIndicator = true;
                                break block0;
                            }
                        }
                        ais.advanceElement();
                        break;
                    }
                    if (ais.getTagClass() == 0) {
                        switch (tag) {
                            case 4: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding RestoreDataRequest.lmsi: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.lmsi = new LMSIImpl();
                                ((LMSIImpl)this.lmsi).decodeAll(ais);
                                break block0;
                            }
                            case 16: {
                                if (ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding RestoreDataRequest.extensionContainer: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.extensionContainer = new MAPExtensionContainerImpl();
                                ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                                break block0;
                            }
                        }
                        ais.advanceElement();
                        break;
                    }
                    ais.advanceElement();
                }
            }
            ++num;
        }
        if (num < 1) {
            throw new MAPParsingComponentException("Error while decoding RestoreDataRequest: Needs at least 1 mandatory parameters, found " + num, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding RestoreDataRequest: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        try {
            if (this.imsi == null) {
                throw new MAPException("IMSI parameter must not be null");
            }
            ((IMSIImpl)this.imsi).encodeAll(asnOs);
            if (this.lmsi != null) {
                ((LMSIImpl)this.lmsi).encodeAll(asnOs);
            }
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs);
            }
            if (this.vlrCapability != null) {
                ((VLRCapabilityImpl)this.vlrCapability).encodeAll(asnOs, 2, 6);
            }
            if (this.restorationIndicator) {
                asnOs.writeNull(2, 7);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding RestoreDataRequest: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding RestoreDataRequest: " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.imsi != null) {
            sb.append("imsi=");
            sb.append(this.imsi.toString());
            sb.append(", ");
        }
        if (this.lmsi != null) {
            sb.append("lmsi=");
            sb.append(this.lmsi.toString());
            sb.append(", ");
        }
        if (this.vlrCapability != null) {
            sb.append("vlrCapability=");
            sb.append(this.vlrCapability.toString());
            sb.append(", ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer.toString());
            sb.append(", ");
        }
        if (this.restorationIndicator) {
            sb.append("restorationIndicator");
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

