/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractAsnEncodable;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractRemoteOperation;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.OperationCodeImpl;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.ParameterImpl;
import org.mobicents.protocols.ss7.isup.message.parameter.OperationCode;
import org.mobicents.protocols.ss7.isup.message.parameter.OperationCodeType;
import org.mobicents.protocols.ss7.isup.message.parameter.Parameter;
import org.mobicents.protocols.ss7.isup.message.parameter.RemoteOperation;
import org.mobicents.protocols.ss7.isup.message.parameter.ReturnResult;

public class ReturnResultImpl
extends AbstractRemoteOperation
implements ReturnResult {
    private Long invokeId;
    private List<OperationCode> operationCodes = new ArrayList<OperationCode>();
    private Parameter parameter;

    public ReturnResultImpl() {
        super(RemoteOperation.OperationType.ReturnResult);
    }

    public void setInvokeId(Long i) {
        if (i == null || i < -128L || i > 127L) {
            throw new IllegalArgumentException("Invoke ID our of range: <-128,127>: " + i);
        }
        this.invokeId = i;
    }

    public Long getInvokeId() {
        return this.invokeId;
    }

    public void setOperationCodes(OperationCode ... i) {
        this.operationCodes.clear();
        for (OperationCode oc : i) {
            if (oc == null) continue;
            this.operationCodes.add(oc);
        }
    }

    public OperationCode[] getOperationCodes() {
        return this.operationCodes.toArray(new OperationCode[this.operationCodes.size()]);
    }

    public void setParameter(Parameter p) {
        this.parameter = p;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decode(AsnInputStream ais) throws ParameterException {
        block12: {
            try {
                AsnInputStream localAis = ais.readSequenceStream();
                int tag = localAis.readTag();
                if (tag != 2 || localAis.getTagClass() != 0) {
                    throw new ParameterException("Error while decoding Invoke: bad tag or tag class for InvokeID: tag=" + tag + ", tagClass = " + localAis.getTagClass());
                }
                this.invokeId = localAis.readInteger();
                if (localAis.available() == 0) {
                    return;
                }
                while (localAis.available() > 0) {
                    if (this.operationCodes.size() <= 0 || this.parameter == null) continue;
                    throw new ParameterException();
                }
                tag = localAis.readTag();
                if (tag == 16 && localAis.getTagClass() == 0) {
                    try (AsnInputStream operationCodesAIS = new AsnInputStream(localAis.readSequence());){
                        while (operationCodesAIS.available() > 0) {
                            int innerTag = operationCodesAIS.readTag();
                            if (innerTag != 6 && innerTag != 2 || operationCodesAIS.getTagClass() != 0) {
                                throw new ParameterException("Error while decoding Invoke: bad tag or tag class for operationCode: tag=" + tag + ", tagClass = " + localAis.getTagClass());
                            }
                            OperationCodeImpl operationCode = new OperationCodeImpl();
                            operationCode.setOperationType(6 == innerTag ? OperationCodeType.Global : OperationCodeType.Local);
                            ((AbstractAsnEncodable)operationCode).decode(localAis);
                            this.operationCodes.add(operationCode);
                        }
                        break block12;
                    }
                }
                this.parameter = new ParameterImpl(tag, localAis, true);
            }
            catch (IOException e) {
                throw new ParameterException("IOException while decoding Invoke: " + e.getMessage(), (Throwable)e);
            }
            catch (AsnException e) {
                throw new ParameterException("AsnException while decoding Invoke: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void encode(AsnOutputStream aos) throws ParameterException {
        if (this.invokeId == null) {
            throw new ParameterException("Invoke ID not set!");
        }
        try {
            aos.writeTag(2, false, 2);
            int pos = aos.StartContentDefiniteLength();
            aos.writeInteger(this.invokeId.longValue());
            if (this.operationCodes.size() > 0) {
                AsnOutputStream codesAOS = new AsnOutputStream();
                for (OperationCode oc : this.operationCodes) {
                    ((AbstractAsnEncodable)oc).encode(codesAOS);
                }
                aos.writeSequence(0, 16, codesAOS.toByteArray());
            }
            if (this.parameter != null) {
                ((AbstractAsnEncodable)this.parameter).encode(aos);
            }
            aos.FinalizeContent(pos);
        }
        catch (IOException e) {
            throw new ParameterException("IOException while encoding Invoke: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new ParameterException("AsnException while encoding Invoke: " + e.getMessage(), (Throwable)e);
        }
    }
}

