/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractRemoteOperation;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.InvokeImpl;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.RejectImpl;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.ReturnErrorImpl;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.ReturnResultImpl;
import org.mobicents.protocols.ss7.isup.message.parameter.RemoteOperation;
import org.mobicents.protocols.ss7.isup.message.parameter.RemoteOperations;

public class RemoteOperationsImpl
extends AbstractISUPParameter
implements RemoteOperations {
    private List<RemoteOperation> remoteOperations = new ArrayList<RemoteOperation>();
    private byte protocol = (byte)17;

    public RemoteOperationsImpl(byte[] b) throws ParameterException {
        this.decode(b);
    }

    public RemoteOperationsImpl() {
    }

    @Override
    public int decode(byte[] b) throws ParameterException {
        if (b.length < 1) {
            throw new ParameterException();
        }
        this.protocol = (byte)(b[0] & 0x1F);
        if ((b[0] & 0x80) > 0) {
            if (b.length > 1) {
                throw new ParameterException();
            }
            return 1;
        }
        try {
            AsnInputStream asnInputeStream = new AsnInputStream(b);
            asnInputeStream.skip(1L);
            while (asnInputeStream.available() > 0) {
                int tag = asnInputeStream.readTag();
                AbstractRemoteOperation aro = null;
                switch (tag) {
                    case 1: {
                        aro = new InvokeImpl();
                        break;
                    }
                    case 2: {
                        aro = new ReturnResultImpl();
                        break;
                    }
                    case 3: {
                        aro = new ReturnErrorImpl();
                        break;
                    }
                    case 4: {
                        aro = new RejectImpl();
                        break;
                    }
                    default: {
                        throw new ParameterException("Unknown tag: " + tag);
                    }
                }
                aro.decode(asnInputeStream);
                this.remoteOperations.add(aro);
                aro = null;
            }
        }
        catch (IOException e) {
            throw new ParameterException((Throwable)e);
        }
        return b.length;
    }

    @Override
    public byte[] encode() throws ParameterException {
        if (this.remoteOperations.size() == 0) {
            return new byte[]{(byte)(0x80 | this.protocol)};
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(this.protocol);
        AsnOutputStream aos = new AsnOutputStream();
        for (RemoteOperation ro : this.remoteOperations) {
            AbstractRemoteOperation aro = (AbstractRemoteOperation)ro;
            aro.encode(aos);
        }
        try {
            baos.write(aos.toByteArray());
        }
        catch (IOException e) {
            throw new ParameterException((Throwable)e);
        }
        return baos.toByteArray();
    }

    public int getCode() {
        return 50;
    }

    public void setProtocol(byte protocol) {
        this.protocol = this.protocol;
    }

    public byte getProtocol() {
        return this.protocol;
    }

    public void setOperations(RemoteOperation ... operations) {
        this.remoteOperations.clear();
        for (RemoteOperation ro : operations) {
            if (ro == null) continue;
            this.remoteOperations.add(ro);
        }
    }

    public RemoteOperation[] getOperations() {
        return this.remoteOperations.toArray(new RemoteOperation[this.remoteOperations.size()]);
    }
}

