/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractAsnEncodable;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractRemoteOperation;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.ProblemImpl;
import org.mobicents.protocols.ss7.isup.message.parameter.Problem;
import org.mobicents.protocols.ss7.isup.message.parameter.ProblemType;
import org.mobicents.protocols.ss7.isup.message.parameter.Reject;
import org.mobicents.protocols.ss7.isup.message.parameter.RemoteOperation;

public class RejectImpl
extends AbstractRemoteOperation
implements Reject {
    private Long invokeId;
    private Problem problem;

    public RejectImpl() {
        super(RemoteOperation.OperationType.Reject);
    }

    public Long getInvokeId() {
        return this.invokeId;
    }

    public Problem getProblem() {
        return this.problem;
    }

    public void setInvokeId(Long i) {
        if (i != null && (i < -128L || i > 127L)) {
            throw new IllegalArgumentException("Invoke ID our of range: <-128,127>: " + i);
        }
        this.invokeId = i;
    }

    public void setProblem(Problem p) {
        this.problem = p;
    }

    public String toString() {
        return "Reject[invokeId=" + this.invokeId + ", problem=" + this.problem + "]";
    }

    @Override
    public void decode(AsnInputStream ais) throws ParameterException {
        try {
            AsnInputStream localAis = ais.readSequenceStream();
            int tag = localAis.readTag();
            if (localAis.getTagClass() != 0) {
                throw new ParameterException("Error while decoding Reject: bad tag class for InvokeID or NULL: tagClass = " + localAis.getTagClass());
            }
            switch (tag) {
                case 2: {
                    this.invokeId = localAis.readInteger();
                    break;
                }
                case 5: {
                    localAis.readNull();
                }
            }
            tag = localAis.readTag();
            if (localAis.getTagClass() != 1) {
                throw new ParameterException("Error while decoding Reject: bad tag class for a problem: tagClass = " + localAis.getTagClass());
            }
            ProblemType pt = ProblemType.getFromInt((long)tag);
            if (pt == null) {
                throw new ParameterException("Error while decoding Reject: ProblemType not found");
            }
            this.problem = new ProblemImpl();
            this.problem.setType(pt);
            ((AbstractAsnEncodable)this.problem).decode(localAis);
        }
        catch (IOException e) {
            throw new ParameterException("IOException while decoding Reject: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new ParameterException("AsnException while decoding Reject: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encode(AsnOutputStream aos) throws ParameterException {
        if (this.problem == null) {
            throw new ParameterException("Problem not set!");
        }
        try {
            aos.writeTag(2, false, 4);
            int pos = aos.StartContentDefiniteLength();
            if (this.invokeId == null) {
                aos.writeNull();
            } else {
                aos.writeInteger(this.invokeId.longValue());
            }
            ((AbstractAsnEncodable)this.problem).encode(aos);
            aos.FinalizeContent(pos);
        }
        catch (IOException e) {
            throw new ParameterException("IOException while encoding Reject: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new ParameterException("AsnException while encoding Reject: " + e.getMessage(), (Throwable)e);
        }
    }
}

