/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.message.parameter.RedirectionInformation;

public class RedirectionInformationImpl
extends AbstractISUPParameter
implements RedirectionInformation {
    private static final String REDIRECTING_INDICATOR = "redirectingIndicator";
    private static final String ORIGINAL_REDIRECTION_REASON = "originalRedirectionReason";
    private static final String REDIRECTION_COUNTER = "redirectionCounter";
    private static final String REDIRECTION_REASON = "redirectionReason";
    private static final int DEFAULT_INT_VALUE = 0;
    private int redirectingIndicator;
    private int originalRedirectionReason;
    private int redirectionCounter;
    private int redirectionReason;
    protected static final XMLFormat<RedirectionInformationImpl> ISUP_REDIRECTION_INFORMATION_XML = new XMLFormat<RedirectionInformationImpl>(RedirectionInformationImpl.class){

        public void read(XMLFormat.InputElement xml, RedirectionInformationImpl redirectionInformation) throws XMLStreamException {
            redirectionInformation.redirectingIndicator = xml.getAttribute(RedirectionInformationImpl.REDIRECTING_INDICATOR, 0);
            redirectionInformation.originalRedirectionReason = xml.getAttribute(RedirectionInformationImpl.ORIGINAL_REDIRECTION_REASON, 0);
            redirectionInformation.redirectionCounter = xml.getAttribute(RedirectionInformationImpl.REDIRECTION_COUNTER, 0);
            redirectionInformation.redirectionReason = xml.getAttribute(RedirectionInformationImpl.REDIRECTION_REASON, 0);
        }

        public void write(RedirectionInformationImpl redirectionInformation, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(RedirectionInformationImpl.REDIRECTING_INDICATOR, redirectionInformation.redirectingIndicator);
            xml.setAttribute(RedirectionInformationImpl.ORIGINAL_REDIRECTION_REASON, redirectionInformation.originalRedirectionReason);
            xml.setAttribute(RedirectionInformationImpl.REDIRECTION_COUNTER, redirectionInformation.redirectionCounter);
            xml.setAttribute(RedirectionInformationImpl.REDIRECTION_REASON, redirectionInformation.redirectionReason);
        }
    };

    public RedirectionInformationImpl(byte[] b) throws IllegalArgumentException, ParameterException {
        this.decode(b);
    }

    public RedirectionInformationImpl(int redirectingIndicator, int originalRedirectionReason, int redirectionCounter, int redirectionReason) throws IllegalArgumentException {
        this.setRedirectingIndicator(redirectingIndicator);
        this.setOriginalRedirectionReason(originalRedirectionReason);
        this.setRedirectionCounter(redirectionCounter);
        this.setRedirectionReason(redirectionReason);
    }

    public RedirectionInformationImpl() {
    }

    @Override
    public int decode(byte[] b) throws ParameterException {
        if (b == null || b.length != 2) {
            throw new ParameterException("byte[] must  not be null and length must  be 2");
        }
        try {
            this.setRedirectingIndicator(b[0] & 7);
            this.setOriginalRedirectionReason(b[0] >> 4 & 0xF);
            this.setRedirectionCounter(b[1] & 7);
            this.setRedirectionReason(b[1] >> 4 & 0xF);
        }
        catch (Exception e) {
            throw new ParameterException((Throwable)e);
        }
        return 2;
    }

    @Override
    public byte[] encode() throws ParameterException {
        int b0 = this.redirectingIndicator & 7;
        int b1 = this.redirectionCounter & 7;
        return new byte[]{(byte)(b0 |= (this.originalRedirectionReason & 0xF) << 4), (byte)(b1 |= (this.redirectionReason & 0xF) << 4)};
    }

    public int getRedirectingIndicator() {
        return this.redirectingIndicator;
    }

    public void setRedirectingIndicator(int redirectingIndicator) {
        this.redirectingIndicator = redirectingIndicator & 7;
    }

    public int getOriginalRedirectionReason() {
        return this.originalRedirectionReason;
    }

    public void setOriginalRedirectionReason(int originalRedirectionReason) {
        this.originalRedirectionReason = originalRedirectionReason & 0xF;
    }

    public int getRedirectionCounter() {
        return this.redirectionCounter;
    }

    public void setRedirectionCounter(int redirectionCounter) throws IllegalArgumentException {
        if (redirectionCounter < 1 || redirectionCounter > 5) {
            throw new IllegalArgumentException("Out of range - must be between 1 and 5");
        }
        this.redirectionCounter = redirectionCounter & 7;
    }

    public int getRedirectionReason() {
        return this.redirectionReason;
    }

    public void setRedirectionReason(int redirectionReason) {
        this.redirectionReason = redirectionReason & 0xF;
    }

    public String toString() {
        return "RedirectionInformation [redirectingIndicator=" + this.redirectingIndicator + ", originalRedirectionReason=" + this.originalRedirectionReason + ", redirectionCounter=" + this.redirectionCounter + ", redirectionReason=" + this.redirectionReason + "]";
    }

    public int getCode() {
        return 19;
    }
}

