/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.message.parameter.RangeAndStatus;

public class RangeAndStatusImpl
extends AbstractISUPParameter
implements RangeAndStatus {
    private byte range;
    private byte[] status;

    public RangeAndStatusImpl(byte[] b) throws ParameterException {
        if (b.length < 1) {
            throw new ParameterException("RangeAndStatus requires atleast 1 byte.");
        }
        this.decode(b);
    }

    public RangeAndStatusImpl() {
    }

    public RangeAndStatusImpl(byte range, byte[] status) {
        this.range = range;
        this.setStatus(status);
    }

    @Override
    public int decode(byte[] b) throws ParameterException {
        this.range = b[0];
        if (b.length == 1) {
            return 1;
        }
        this.status = new byte[b.length - 1];
        System.arraycopy(b, 1, this.status, 0, this.status.length);
        return b.length;
    }

    @Override
    public byte[] encode() throws ParameterException {
        RangeAndStatusImpl.checkData(this.range, this.status);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(this.range);
        if (this.status != null) {
            try {
                bos.write(this.status);
            }
            catch (IOException e) {
                throw new ParameterException((Throwable)e);
            }
        }
        return bos.toByteArray();
    }

    public byte getRange() {
        return this.range;
    }

    public void setRange(byte range) {
        this.setRange(range, false);
    }

    public void setRange(byte range, boolean addStatus) {
        this.range = range;
        if (addStatus) {
            int len = (range + 1) / 8;
            if ((range + 1) % 8 != 0) {
                ++len;
            }
            this.status = new byte[len];
        }
    }

    public byte[] getStatus() {
        return this.status;
    }

    public void setStatus(byte[] status) {
        this.status = status;
    }

    public boolean isAffected(byte b) throws IllegalArgumentException {
        if (this.status.length < b / 8) {
            throw new IllegalArgumentException("Argument exceeds status!");
        }
        int index_l = b / 8;
        int index = b % 8;
        int n2Pattern = (int)Math.pow(2.0, index);
        return (this.status[index_l] & n2Pattern) > 0;
    }

    public void setAffected(byte subrange, boolean v) throws IllegalArgumentException {
        if (this.status == null) {
            throw new IllegalArgumentException("Can not set affected if no status present!");
        }
        if (this.status.length < subrange / 8) {
            throw new IllegalArgumentException("Argument exceeds status!");
        }
        int index_l = subrange / 8;
        int index = subrange % 8;
        int n2Pattern = (int)Math.pow(2.0, index);
        if (v) {
            int n = index_l;
            this.status[n] = (byte)(this.status[n] | n2Pattern);
        } else {
            n2Pattern = 0xFF ^ n2Pattern;
            int n = index_l;
            this.status[n] = (byte)(this.status[n] & n2Pattern);
        }
    }

    public int getCode() {
        return 22;
    }

    private static void checkData(byte range, byte[] status) throws ParameterException {
        if (status != null) {
            int len = (range + 1) / 8;
            if ((range + 1) % 8 != 0) {
                ++len;
            }
            if (status.length != len) {
                throw new ParameterException("Wrong length of status part: " + status.length + ", range: " + range);
            }
        }
    }
}

