/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.message.parameter.PropagationDelayCounter;

public class PropagationDelayCounterImpl
extends AbstractISUPParameter
implements PropagationDelayCounter {
    private int propagationDelay;

    public PropagationDelayCounterImpl() {
    }

    public PropagationDelayCounterImpl(byte[] b) throws ParameterException {
        this.decode(b);
    }

    public PropagationDelayCounterImpl(int propagationDelay) {
        this.propagationDelay = propagationDelay;
    }

    @Override
    public int decode(byte[] b) throws ParameterException {
        if (b == null || b.length != 2) {
            throw new ParameterException("byte[] must  not be null and length must be 2");
        }
        this.propagationDelay = b[0] << 8;
        this.propagationDelay |= b[1];
        return b.length;
    }

    @Override
    public byte[] encode() throws ParameterException {
        byte b0 = (byte)(this.propagationDelay >> 8);
        byte b1 = (byte)this.propagationDelay;
        return new byte[]{b0, b1};
    }

    public int getPropagationDelay() {
        return this.propagationDelay;
    }

    public void setPropagationDelay(int propagationDelay) {
        this.propagationDelay = propagationDelay;
    }

    public int getCode() {
        return 49;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PropagationDelayCounter [");
        sb.append("propagationDelay=");
        sb.append(this.propagationDelay);
        sb.append("]");
        return sb.toString();
    }
}

