/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractAsnEncodable;
import org.mobicents.protocols.ss7.isup.message.parameter.GeneralProblemType;
import org.mobicents.protocols.ss7.isup.message.parameter.InvokeProblemType;
import org.mobicents.protocols.ss7.isup.message.parameter.Problem;
import org.mobicents.protocols.ss7.isup.message.parameter.ProblemType;
import org.mobicents.protocols.ss7.isup.message.parameter.ReturnErrorProblemType;
import org.mobicents.protocols.ss7.isup.message.parameter.ReturnResultProblemType;

public class ProblemImpl
extends AbstractAsnEncodable
implements Problem {
    private ProblemType type;
    private GeneralProblemType generalProblemType;
    private InvokeProblemType invokeProblemType;
    private ReturnErrorProblemType returnErrorProblemType;
    private ReturnResultProblemType returnResultProblemType;

    public ProblemType getType() {
        return this.type;
    }

    public void setType(ProblemType type) {
        this.type = type;
    }

    public GeneralProblemType getGeneralProblemType() {
        return this.generalProblemType;
    }

    public void setGeneralProblemType(GeneralProblemType generalProblemType) {
        this.generalProblemType = generalProblemType;
        this.setType(ProblemType.General);
    }

    public InvokeProblemType getInvokeProblemType() {
        return this.invokeProblemType;
    }

    public void setInvokeProblemType(InvokeProblemType invokeProblemType) {
        this.setType(ProblemType.Invoke);
        this.invokeProblemType = invokeProblemType;
    }

    public ReturnErrorProblemType getReturnErrorProblemType() {
        return this.returnErrorProblemType;
    }

    public void setReturnErrorProblemType(ReturnErrorProblemType returnErrorProblemType) {
        this.returnErrorProblemType = returnErrorProblemType;
        this.setType(ProblemType.ReturnError);
    }

    public ReturnResultProblemType getReturnResultProblemType() {
        return this.returnResultProblemType;
    }

    public void setReturnResultProblemType(ReturnResultProblemType returnResultProblemType) {
        this.returnResultProblemType = returnResultProblemType;
        this.setType(ProblemType.ReturnResult);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Problem[type=");
        sb.append(this.type);
        sb.append(" ");
        switch (this.type) {
            case General: {
                sb.append("generalProblemType=");
                sb.append(this.generalProblemType);
                break;
            }
            case Invoke: {
                sb.append("invokeProblemType=");
                sb.append(this.invokeProblemType);
                break;
            }
            case ReturnResult: {
                sb.append("returnResultProblemType=");
                sb.append(this.returnResultProblemType);
                break;
            }
            case ReturnError: {
                sb.append("returnErrorProblemType=");
                sb.append(this.returnErrorProblemType);
            }
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void decode(AsnInputStream ais) throws ParameterException {
        try {
            long t = ais.readInteger();
            switch (this.type) {
                case General: {
                    this.generalProblemType = GeneralProblemType.getFromInt((long)t);
                    break;
                }
                case Invoke: {
                    this.invokeProblemType = InvokeProblemType.getFromInt((long)t);
                    break;
                }
                case ReturnError: {
                    this.returnErrorProblemType = ReturnErrorProblemType.getFromInt((long)t);
                    break;
                }
                case ReturnResult: {
                    this.returnResultProblemType = ReturnResultProblemType.getFromInt((long)t);
                    break;
                }
                default: {
                    throw new ParameterException();
                }
            }
        }
        catch (IOException e) {
            throw new ParameterException("IOException while decoding Problem: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new ParameterException("AsnException while decoding Problem: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encode(AsnOutputStream aos) throws ParameterException {
        try {
            switch (this.type) {
                case General: {
                    if (this.generalProblemType == null) {
                        throw new ParameterException("Problem Type is General, no specific type set");
                    }
                    aos.writeInteger(2, (int)this.type.getTypeTag(), this.generalProblemType.getType());
                    break;
                }
                case Invoke: {
                    if (this.invokeProblemType == null) {
                        throw new ParameterException("Problem Type is Invoke, no specific type set");
                    }
                    aos.writeInteger(2, (int)this.type.getTypeTag(), this.invokeProblemType.getType());
                    break;
                }
                case ReturnError: {
                    if (this.returnErrorProblemType == null) {
                        throw new ParameterException("Problem Type is ReturnError, no specific type set");
                    }
                    aos.writeInteger(2, (int)this.type.getTypeTag(), this.returnErrorProblemType.getType());
                    break;
                }
                case ReturnResult: {
                    if (this.returnResultProblemType == null) {
                        throw new ParameterException("Problem Type is Result, no specific type set");
                    }
                    aos.writeInteger(2, (int)this.type.getTypeTag(), this.returnResultProblemType.getType());
                    break;
                }
                default: {
                    throw new ParameterException();
                }
            }
        }
        catch (IOException e) {
            throw new ParameterException("IOException while encoding Problem: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new ParameterException("AsnException while encoding Problem: " + e.getMessage(), (Throwable)e);
        }
    }
}

