/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.Encodable;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.ParameterCompatibilityInstructionIndicatorsImpl;
import org.mobicents.protocols.ss7.isup.message.parameter.ParameterCompatibilityInformation;
import org.mobicents.protocols.ss7.isup.message.parameter.ParameterCompatibilityInstructionIndicators;

public class ParameterCompatibilityInformationImpl
extends AbstractISUPParameter
implements ParameterCompatibilityInformation {
    private List<ParameterCompatibilityInstructionIndicators> instructionIndicators = new ArrayList<ParameterCompatibilityInstructionIndicators>();

    public ParameterCompatibilityInformationImpl(byte[] b) throws ParameterException {
        this.decode(b);
    }

    public ParameterCompatibilityInformationImpl() {
    }

    @Override
    public int decode(byte[] b) throws ParameterException {
        if (b == null || b.length < 2) {
            throw new ParameterException("byte[] must  not be null and length must  greater than 1");
        }
        ByteArrayOutputStream bos = null;
        boolean newParameter = true;
        byte parameterCode = 0;
        for (int index = 0; index < b.length; ++index) {
            if (newParameter) {
                parameterCode = b[index];
                bos = new ByteArrayOutputStream();
                newParameter = false;
                continue;
            }
            bos.write(b[index]);
            if ((b[index] >> 7 & 1) != 0) continue;
            if (bos.size() < 3) {
                this.instructionIndicators.add(new ParameterCompatibilityInstructionIndicatorsImpl(parameterCode, bos.toByteArray()));
            } else {
                this.instructionIndicators.add(new ParameterCompatibilityInstructionIndicatorsImpl(parameterCode, bos.toByteArray(), true));
            }
            newParameter = true;
        }
        return b.length;
    }

    @Override
    public byte[] encode() throws ParameterException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (int index = 0; index < this.instructionIndicators.size(); ++index) {
            try {
                ParameterCompatibilityInstructionIndicators ii = this.instructionIndicators.get(index);
                bos.write(ii.getParameterCode());
                bos.write(((Encodable)ii).encode());
                continue;
            }
            catch (IOException e) {
                throw new ParameterException((Throwable)e);
            }
        }
        return bos.toByteArray();
    }

    public void setParameterCompatibilityInstructionIndicators(ParameterCompatibilityInstructionIndicators ... compatibilityInstructionIndicators) {
        this.instructionIndicators.clear();
        if (compatibilityInstructionIndicators == null || compatibilityInstructionIndicators.length == 0) {
            return;
        }
        for (ParameterCompatibilityInstructionIndicators ii : compatibilityInstructionIndicators) {
            if (ii == null) continue;
            this.instructionIndicators.add(ii);
        }
    }

    public ParameterCompatibilityInstructionIndicators[] getParameterCompatibilityInstructionIndicators() {
        return this.instructionIndicators.toArray(new ParameterCompatibilityInstructionIndicators[this.instructionIndicators.size()]);
    }

    public int getCode() {
        return 57;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ParameterCompatibilityInformation [");
        for (ParameterCompatibilityInstructionIndicators pci : this.instructionIndicators) {
            sb.append("ParameterCompatibilityInstructionIndicators=[");
            sb.append(pci);
            sb.append("], ");
        }
        sb.append("]");
        return sb.toString();
    }
}

