/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractNumber;
import org.mobicents.protocols.ss7.isup.message.parameter.OriginatingParticipatingServiceProvider;

public class OriginatingParticipatingServiceProviderImpl
extends AbstractNumber
implements OriginatingParticipatingServiceProvider {
    private int opspLengthIndicator;

    public OriginatingParticipatingServiceProviderImpl() {
    }

    public OriginatingParticipatingServiceProviderImpl(byte[] representation) throws ParameterException {
        super(representation);
    }

    public OriginatingParticipatingServiceProviderImpl(ByteArrayInputStream bis) throws ParameterException {
        super(bis);
    }

    public OriginatingParticipatingServiceProviderImpl(String address) {
        super(address);
    }

    @Override
    public int decode(byte[] b) throws ParameterException {
        return super.decode(b);
    }

    @Override
    public byte[] encode() throws ParameterException {
        return super.encode();
    }

    @Override
    public int decodeHeader(ByteArrayInputStream bis) throws ParameterException {
        if (bis.available() == 0) {
            throw new ParameterException("No more data to read.");
        }
        int b = bis.read() & 0xFF;
        this.oddFlag = (b & 0x80) >> 7;
        this.opspLengthIndicator = b & 0xF;
        return 1;
    }

    @Override
    public int encodeHeader(ByteArrayOutputStream bos) {
        boolean isOdd;
        int b = 0;
        boolean bl = isOdd = this.oddFlag == 1;
        if (isOdd) {
            b |= 0x80;
        }
        bos.write(b |= this.opspLengthIndicator & 0xF);
        return 1;
    }

    @Override
    public int decodeBody(ByteArrayInputStream bis) throws ParameterException {
        return 0;
    }

    @Override
    public int encodeBody(ByteArrayOutputStream bos) {
        return 0;
    }

    @Override
    public int decodeDigits(ByteArrayInputStream bis) throws ParameterException {
        if (this.opspLengthIndicator > 0) {
            if (bis.available() == 0) {
                throw new ParameterException("No more data to read.");
            }
            return super.decodeDigits(bis, this.opspLengthIndicator);
        }
        return 0;
    }

    @Override
    public int encodeDigits(ByteArrayOutputStream bos) {
        if (this.opspLengthIndicator > 0) {
            return super.encodeDigits(bos);
        }
        return 0;
    }

    public int getOpspLengthIndicator() {
        return this.opspLengthIndicator;
    }

    @Override
    public void setAddress(String address) {
        super.setAddress(address);
        int l = this.address.length();
        this.opspLengthIndicator = l / 2 + l % 2;
        if (this.opspLengthIndicator > 4) {
            throw new IllegalArgumentException("Maximum octets for this parameter in digits part is 4. Address: " + address);
        }
        if (this.opspLengthIndicator == 4 && !this.isOddFlag()) {
            throw new IllegalArgumentException("maximum allowed number of digits is 7. Address: " + address);
        }
    }

    public int getCode() {
        return 0;
    }
}

