/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractNumber;
import org.mobicents.protocols.ss7.isup.message.parameter.NetworkRoutingNumber;

public class NetworkRoutingNumberImpl
extends AbstractNumber
implements NetworkRoutingNumber {
    private int numberingPlanIndicator;
    private int natureOfAddressIndicator;

    public NetworkRoutingNumberImpl(String address) {
        super(address);
    }

    public NetworkRoutingNumberImpl(String address, int numberingPlanIndicator, int natureOfAddressIndicator) {
        super(address);
        this.numberingPlanIndicator = numberingPlanIndicator;
        this.natureOfAddressIndicator = natureOfAddressIndicator;
    }

    public NetworkRoutingNumberImpl() {
    }

    public NetworkRoutingNumberImpl(byte[] representation) throws ParameterException {
        super(representation);
    }

    public NetworkRoutingNumberImpl(ByteArrayInputStream bis) throws ParameterException {
        super(bis);
    }

    @Override
    public int decodeBody(ByteArrayInputStream bis) throws IllegalArgumentException {
        return 0;
    }

    @Override
    public int encodeBody(ByteArrayOutputStream bos) {
        return 0;
    }

    @Override
    public int decodeHeader(ByteArrayInputStream bis) throws IllegalArgumentException {
        int b = bis.read() & 0xFF;
        this.oddFlag = (b & 0x80) >> 7;
        this.numberingPlanIndicator = (b & 0x70) >> 4;
        this.natureOfAddressIndicator = b & 0xF;
        return 1;
    }

    @Override
    public int encodeHeader(ByteArrayOutputStream bos) {
        boolean isOdd;
        int b = 0;
        boolean bl = isOdd = this.oddFlag == 1;
        if (isOdd) {
            b |= 0x80;
        }
        b |= (this.numberingPlanIndicator & 7) << 4;
        bos.write(b |= this.natureOfAddressIndicator & 0xF);
        return 1;
    }

    public int getNumberingPlanIndicator() {
        return this.numberingPlanIndicator;
    }

    public void setNumberingPlanIndicator(int numberingPlanIndicator) {
        this.numberingPlanIndicator = numberingPlanIndicator;
    }

    public int getNatureOfAddressIndicator() {
        return this.natureOfAddressIndicator;
    }

    public void setNatureOfAddressIndicator(int natureOfAddressIndicator) {
        this.natureOfAddressIndicator = natureOfAddressIndicator;
    }

    public int getCode() {
        return 132;
    }
}

