/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.message.parameter.NatureOfConnectionIndicators;

public class NatureOfConnectionIndicatorsImpl
extends AbstractISUPParameter
implements NatureOfConnectionIndicators {
    private static final int _TURN_ON = 1;
    private static final int _TURN_OFF = 0;
    private int satelliteIndicator = 0;
    private int continuityCheckIndicator = 0;
    private boolean echoControlDeviceIndicator = false;

    public NatureOfConnectionIndicatorsImpl(byte[] b) throws ParameterException {
        this.decode(b);
    }

    public NatureOfConnectionIndicatorsImpl() {
    }

    public NatureOfConnectionIndicatorsImpl(byte satelliteIndicator, byte continuityCheckIndicator, boolean echoControlDeviceIndicator) {
        this.satelliteIndicator = satelliteIndicator;
        this.continuityCheckIndicator = continuityCheckIndicator;
        this.echoControlDeviceIndicator = echoControlDeviceIndicator;
    }

    @Override
    public int decode(byte[] b) throws ParameterException {
        if (b == null || b.length != 1) {
            throw new ParameterException("byte[] must not be null and must have length of 1");
        }
        this.satelliteIndicator = (byte)(b[0] & 3);
        this.continuityCheckIndicator = (byte)(b[0] >> 2 & 3);
        this.echoControlDeviceIndicator = b[0] >> 4 == 1;
        return 1;
    }

    @Override
    public byte[] encode() throws ParameterException {
        int b0 = 0;
        b0 = this.satelliteIndicator & 3;
        b0 |= (this.continuityCheckIndicator & 3) << 2;
        return new byte[]{(byte)(b0 |= (this.echoControlDeviceIndicator ? 1 : 0) << 4)};
    }

    @Override
    public int encode(ByteArrayOutputStream bos) throws ParameterException {
        byte[] b = this.encode();
        try {
            bos.write(b);
        }
        catch (IOException e) {
            throw new ParameterException((Throwable)e);
        }
        return b.length;
    }

    public int getSatelliteIndicator() {
        return this.satelliteIndicator;
    }

    public void setSatelliteIndicator(int satelliteIndicator) {
        this.satelliteIndicator = satelliteIndicator & 3;
    }

    public int getContinuityCheckIndicator() {
        return this.continuityCheckIndicator;
    }

    public void setContinuityCheckIndicator(int continuityCheckIndicator) {
        this.continuityCheckIndicator = continuityCheckIndicator & 3;
    }

    public boolean isEchoControlDeviceIndicator() {
        return this.echoControlDeviceIndicator;
    }

    public void setEchoControlDeviceIndicator(boolean echoControlDeviceIndicator) {
        this.echoControlDeviceIndicator = echoControlDeviceIndicator;
    }

    public int getCode() {
        return 6;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NatureOfConnectionIndicators [");
        sb.append("satelliteIndicator=");
        sb.append(this.satelliteIndicator);
        sb.append(", ");
        sb.append("continuityCheckIndicator=");
        sb.append(this.continuityCheckIndicator);
        sb.append(", ");
        sb.append("echoControlDeviceIndicator=");
        sb.append(this.echoControlDeviceIndicator);
        sb.append("]");
        return sb.toString();
    }
}

