/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.MessageCompatibilityInstructionIndicatorImpl;
import org.mobicents.protocols.ss7.isup.message.parameter.MessageCompatibilityInformation;
import org.mobicents.protocols.ss7.isup.message.parameter.MessageCompatibilityInstructionIndicator;

public class MessageCompatibilityInformationImpl
extends AbstractISUPParameter
implements MessageCompatibilityInformation {
    private List<MessageCompatibilityInstructionIndicator> indicators = new LinkedList<MessageCompatibilityInstructionIndicator>();

    public MessageCompatibilityInformationImpl() {
    }

    public MessageCompatibilityInformationImpl(byte[] body) throws ParameterException {
        this.decode(body);
    }

    public int getCode() {
        return 56;
    }

    public void setMessageCompatibilityInstructionIndicators(MessageCompatibilityInstructionIndicator ... indicators) {
        this.indicators.clear();
        for (MessageCompatibilityInstructionIndicator i : indicators) {
            if (i == null) continue;
            this.indicators.add(i);
        }
    }

    public MessageCompatibilityInstructionIndicator[] getMessageCompatibilityInstructionIndicators() {
        return this.indicators.toArray(new MessageCompatibilityInstructionIndicator[this.indicators.size()]);
    }

    @Override
    public int decode(byte[] b) throws ParameterException {
        if (b == null || b.length == 0) {
            throw new ParameterException("byte[] must  not be null and length must  be greater than 0");
        }
        int limit = b.length - 1;
        for (int index = 0; index < b.length; ++index) {
            byte v = b[index];
            if (index == limit) {
                if ((v & 0x7F) == 0) {
                    throw new ParameterException("Extension bit indicates more content, but byte[] is done... " + Arrays.toString(b));
                }
            } else if ((v & 0x7F) == 1) {
                throw new ParameterException("Extension bit indicates end of content, but byte[] is not done... " + Arrays.toString(b));
            }
            MessageCompatibilityInstructionIndicatorImpl instructions = new MessageCompatibilityInstructionIndicatorImpl();
            instructions.decode(new byte[]{v});
            this.indicators.add(instructions);
        }
        return b.length;
    }

    @Override
    public byte[] encode() throws ParameterException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(this.indicators.size());
        int limit = this.indicators.size() - 1;
        for (int index = 0; index < this.indicators.size(); ++index) {
            byte[] val = ((MessageCompatibilityInstructionIndicatorImpl)this.indicators.get(index)).encode();
            val[0] = index == limit ? (byte)(val[0] & 0x7F | 0x80) : (byte)(val[0] & 0x7F);
            try {
                baos.write(val);
                continue;
            }
            catch (IOException e) {
                throw new ParameterException((Throwable)e);
            }
        }
        return baos.toByteArray();
    }
}

