/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.message.parameter.MLPPPrecedence;

public class MLPPPrecedenceImpl
extends AbstractISUPParameter
implements MLPPPrecedence {
    private int lfb;
    private int precedenceLevel;
    private int mllpServiceDomain;
    private byte[] niDigits;

    public MLPPPrecedenceImpl() {
    }

    public MLPPPrecedenceImpl(byte[] b) throws ParameterException {
        this.decode(b);
    }

    public MLPPPrecedenceImpl(byte lfb, byte precedenceLevel, int mllpServiceDomain, byte[] niDigits) {
        this.lfb = lfb;
        this.precedenceLevel = precedenceLevel;
        this.mllpServiceDomain = mllpServiceDomain;
        this.setNiDigits(niDigits);
    }

    @Override
    public int decode(byte[] b) throws ParameterException {
        if (b == null || b.length != 6) {
            throw new ParameterException("byte[] must  not be null and length must  be 6");
        }
        this.precedenceLevel = (byte)(b[0] & 0xF);
        this.lfb = (byte)(b[0] >> 5 & 3);
        byte v = 0;
        this.niDigits = new byte[4];
        for (int i = 0; i < 2; ++i) {
            v = 0;
            v = b[i + 1];
            this.niDigits[i * 2] = (byte)(v & 0xF);
            this.niDigits[i * 2 + 1] = (byte)(v >> 4 & 0xF);
        }
        this.mllpServiceDomain = b[3] << 16;
        this.mllpServiceDomain |= b[4] << 8;
        this.mllpServiceDomain |= b[5];
        return 6;
    }

    @Override
    public byte[] encode() throws ParameterException {
        byte[] b = new byte[6];
        b[0] = (byte)((this.lfb & 3) << 5);
        b[0] = (byte)(b[0] | this.precedenceLevel & 0xF);
        int v = 0;
        for (int i = 0; i < 2; ++i) {
            v = 0;
            v = (byte)(v | (this.niDigits[i * 2] & 0xF) << 4);
            b[i + 1] = v = (int)((byte)(v | this.niDigits[i * 2 + 1] & 0xF));
        }
        b[3] = (byte)(this.mllpServiceDomain >> 16);
        b[4] = (byte)(this.mllpServiceDomain >> 8);
        b[5] = (byte)this.mllpServiceDomain;
        return b;
    }

    public byte getLfb() {
        return (byte)this.lfb;
    }

    public void setLfb(byte lfb) {
        this.lfb = lfb;
    }

    public byte getPrecedenceLevel() {
        return (byte)this.precedenceLevel;
    }

    public void setPrecedenceLevel(byte precedenceLevel) {
        this.precedenceLevel = precedenceLevel;
    }

    public int getMllpServiceDomain() {
        return this.mllpServiceDomain;
    }

    public void setMllpServiceDomain(int mllpServiceDomain) {
        this.mllpServiceDomain = mllpServiceDomain;
    }

    public byte[] getNiDigits() {
        return this.niDigits;
    }

    public void setNiDigits(byte[] niDigits) {
        if (niDigits == null || niDigits.length != 4) {
            throw new IllegalArgumentException();
        }
        this.niDigits = niDigits;
    }

    public int getCode() {
        return 58;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MLPPPrecedence [");
        sb.append("lfb=");
        sb.append(this.lfb);
        sb.append(", ");
        sb.append("precedenceLevel=");
        sb.append(this.precedenceLevel);
        sb.append(", ");
        sb.append("mllpServiceDomain=");
        sb.append(this.mllpServiceDomain);
        if (this.niDigits != null) {
            sb.append(", ");
            sb.append("niDigits=");
            for (int i1 = 1; i1 < this.niDigits.length; ++i1) {
                sb.append(this.niDigits[i1]);
                sb.append(", ");
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

