/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.message.parameter.MCIDRequestIndicators;

public class MCIDRequestIndicatorsImpl
extends AbstractISUPParameter
implements MCIDRequestIndicators {
    private static final int _TURN_ON = 1;
    private static final int _TURN_OFF = 0;
    private boolean mcidRequestIndicator;
    private boolean holdingIndicator;

    public MCIDRequestIndicatorsImpl(byte[] b) throws ParameterException {
        this.decode(b);
    }

    public MCIDRequestIndicatorsImpl() {
    }

    public MCIDRequestIndicatorsImpl(boolean mcidRequest, boolean holdingRequested) {
        this.mcidRequestIndicator = mcidRequest;
        this.holdingIndicator = holdingRequested;
    }

    @Override
    public int decode(byte[] b) throws ParameterException {
        if (b == null || b.length != 1) {
            throw new ParameterException("byte[] must  not be null and length must  be 1");
        }
        this.mcidRequestIndicator = (b[0] & 1) == 1;
        this.holdingIndicator = (b[0] >> 1 & 1) == 1;
        return 1;
    }

    @Override
    public byte[] encode() throws ParameterException {
        int b0 = 0;
        b0 |= this.mcidRequestIndicator ? 1 : 0;
        return new byte[]{(byte)(b0 |= (this.holdingIndicator ? 1 : 0) << 1)};
    }

    public boolean isMcidRequestIndicator() {
        return this.mcidRequestIndicator;
    }

    public void setMcidRequestIndicator(boolean mcidRequestIndicator) {
        this.mcidRequestIndicator = mcidRequestIndicator;
    }

    public boolean isHoldingIndicator() {
        return this.holdingIndicator;
    }

    public void setHoldingIndicator(boolean holdingIndicator) {
        this.holdingIndicator = holdingIndicator;
    }

    public int getCode() {
        return 59;
    }
}

