/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.message.parameter.InformationIndicators;

public class InformationIndicatorsImpl
extends AbstractISUPParameter
implements InformationIndicators {
    private static final int _TURN_ON = 1;
    private static final int _TURN_OFF = 0;
    private int callingPartyAddressResponseIndicator;
    private boolean holdProvidedIndicator;
    private boolean callingPartysCategoryResponseIndicator;
    private boolean chargeInformationResponseIndicator;
    private boolean solicitedInformationIndicator;
    private int reserved;

    public InformationIndicatorsImpl(byte[] b) throws ParameterException {
        this.decode(b);
    }

    public InformationIndicatorsImpl() {
    }

    public InformationIndicatorsImpl(int callingPartyAddressResponseIndicator, boolean holdProvidedIndicator, boolean callingPartysCategoryResponseIndicator, boolean chargeInformationResponseIndicator, boolean solicitedInformationIndicator, int reserved) {
        this.callingPartyAddressResponseIndicator = callingPartyAddressResponseIndicator;
        this.holdProvidedIndicator = holdProvidedIndicator;
        this.callingPartysCategoryResponseIndicator = callingPartysCategoryResponseIndicator;
        this.chargeInformationResponseIndicator = chargeInformationResponseIndicator;
        this.solicitedInformationIndicator = solicitedInformationIndicator;
        this.reserved = reserved;
    }

    @Override
    public int decode(byte[] b) throws ParameterException {
        if (b == null || b.length != 2) {
            throw new ParameterException("byte[] must  not be null and length must  be 2");
        }
        this.reserved = b[1] >> 4 & 0xF;
        this.callingPartyAddressResponseIndicator = b[0] & 3;
        this.holdProvidedIndicator = (b[0] >> 2 & 1) == 1;
        this.callingPartysCategoryResponseIndicator = (b[0] >> 5 & 1) == 1;
        this.chargeInformationResponseIndicator = (b[0] >> 6 & 1) == 1;
        this.solicitedInformationIndicator = (b[0] >> 7 & 1) == 1;
        return 2;
    }

    @Override
    public byte[] encode() throws ParameterException {
        int b1 = this.callingPartyAddressResponseIndicator & 3;
        b1 |= (this.holdProvidedIndicator ? 1 : 0) << 2;
        b1 |= (this.callingPartysCategoryResponseIndicator ? 1 : 0) << 5;
        b1 |= (this.chargeInformationResponseIndicator ? 1 : 0) << 6;
        int n = this.solicitedInformationIndicator ? 1 : 0;
        int b2 = (this.reserved & 0xF) << 4;
        byte[] b = new byte[]{(byte)(b1 |= n << 7), (byte)b2};
        return b;
    }

    public int getCallingPartyAddressResponseIndicator() {
        return this.callingPartyAddressResponseIndicator;
    }

    public void setCallingPartyAddressResponseIndicator(int callingPartyAddressResponseIndicator) {
        this.callingPartyAddressResponseIndicator = callingPartyAddressResponseIndicator;
    }

    public boolean isHoldProvidedIndicator() {
        return this.holdProvidedIndicator;
    }

    public void setHoldProvidedIndicator(boolean holdProvidedIndicator) {
        this.holdProvidedIndicator = holdProvidedIndicator;
    }

    public boolean isCallingPartysCategoryResponseIndicator() {
        return this.callingPartysCategoryResponseIndicator;
    }

    public void setCallingPartysCategoryResponseIndicator(boolean callingPartysCategoryResponseIndicator) {
        this.callingPartysCategoryResponseIndicator = callingPartysCategoryResponseIndicator;
    }

    public boolean isChargeInformationResponseIndicator() {
        return this.chargeInformationResponseIndicator;
    }

    public void setChargeInformationResponseIndicator(boolean chargeInformationResponseIndicator) {
        this.chargeInformationResponseIndicator = chargeInformationResponseIndicator;
    }

    public boolean isSolicitedInformationIndicator() {
        return this.solicitedInformationIndicator;
    }

    public void setSolicitedInformationIndicator(boolean solicitedInformationIndicator) {
        this.solicitedInformationIndicator = solicitedInformationIndicator;
    }

    public int getReserved() {
        return this.reserved;
    }

    public void setReserved(int reserved) {
        this.reserved = reserved;
    }

    public int getCode() {
        return 15;
    }
}

