/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import javax.xml.bind.DatatypeConverter;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.ByteArrayContainer;
import org.mobicents.protocols.ss7.isup.message.parameter.GenericDigits;
import org.mobicents.protocols.ss7.isup.util.BcdHelper;

public class GenericDigitsImpl
extends AbstractISUPParameter
implements GenericDigits {
    private static final String ENCODING_SCHEME = "encodingScheme";
    private static final String TYPE_OF_DIGITS = "typeOfDigits";
    private static final String DIGITS = "digits";
    private static final Charset asciiCharset = Charset.forName("ASCII");
    private static final int DEFAULT_VALUE = 0;
    private int encodingScheme;
    private int typeOfDigits;
    private byte[] digits;
    protected static final XMLFormat<GenericDigitsImpl> ISUP_GENERIC_DIGITS_XML = new XMLFormat<GenericDigitsImpl>(GenericDigitsImpl.class){

        public void read(XMLFormat.InputElement xml, GenericDigitsImpl genericDigits) throws XMLStreamException {
            genericDigits.encodingScheme = xml.getAttribute(GenericDigitsImpl.ENCODING_SCHEME, 0);
            genericDigits.typeOfDigits = xml.getAttribute(GenericDigitsImpl.TYPE_OF_DIGITS, 0);
            ByteArrayContainer bc = (ByteArrayContainer)xml.get(GenericDigitsImpl.DIGITS, ByteArrayContainer.class);
            if (bc != null) {
                GenericDigitsImpl.access$202(genericDigits, bc.getData());
            }
        }

        public void write(GenericDigitsImpl genericDigits, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(GenericDigitsImpl.ENCODING_SCHEME, genericDigits.encodingScheme);
            xml.setAttribute(GenericDigitsImpl.TYPE_OF_DIGITS, genericDigits.typeOfDigits);
            if (genericDigits.digits != null) {
                ByteArrayContainer bac = new ByteArrayContainer(genericDigits.digits);
                xml.add((Object)bac, GenericDigitsImpl.DIGITS, ByteArrayContainer.class);
            }
        }
    };

    public GenericDigitsImpl(byte[] b) throws ParameterException {
        this.decode(b);
    }

    public GenericDigitsImpl(int encodingScheme, int typeOfDigits, byte[] digits) {
        this.encodingScheme = encodingScheme;
        this.typeOfDigits = typeOfDigits;
        this.setEncodedDigits(digits);
    }

    public GenericDigitsImpl(int encodingScheme, int typeOfDigits, String digits) throws UnsupportedEncodingException {
        this.typeOfDigits = typeOfDigits;
        this.setDecodedDigits(encodingScheme, digits);
    }

    public GenericDigitsImpl() {
    }

    public String getDecodedDigits() throws UnsupportedEncodingException {
        switch (this.encodingScheme) {
            case 0: 
            case 1: {
                return BcdHelper.bcdDecodeToHexString(this.encodingScheme, this.digits);
            }
            case 2: {
                return new String(this.digits, asciiCharset);
            }
        }
        throw new UnsupportedEncodingException("Specified GenericDigits encoding: " + this.encodingScheme + " is unsupported");
    }

    public void setDecodedDigits(int encodingScheme, String digits) throws UnsupportedEncodingException {
        if (digits == null || digits.length() < 1) {
            throw new IllegalArgumentException("Digits must not be null or zero length");
        }
        switch (encodingScheme) {
            case 0: 
            case 1: {
                if (digits.length() % 2 == 0) {
                    if (encodingScheme == 1) {
                        throw new UnsupportedEncodingException("SCHEME_BCD_ODD is possible only for odd digits count");
                    }
                } else if (encodingScheme == 0) {
                    throw new UnsupportedEncodingException("SCHEME_BCD_EVEN is possible only for odd digits count");
                }
                this.encodingScheme = encodingScheme;
                this.setEncodedDigits(BcdHelper.encodeHexStringToBCD(digits));
                break;
            }
            case 2: {
                this.encodingScheme = encodingScheme;
                this.setEncodedDigits(digits.getBytes(asciiCharset));
                break;
            }
            default: {
                throw new UnsupportedEncodingException("Specified GenericDigits encoding: " + encodingScheme + " is unsupported");
            }
        }
    }

    @Override
    public int decode(byte[] b) throws ParameterException {
        if (b == null || b.length < 2) {
            throw new ParameterException("byte[] must not be null or has size less than 2");
        }
        this.typeOfDigits = b[0] & 0x1F;
        this.encodingScheme = b[0] >> 5 & 7;
        this.digits = new byte[b.length - 1];
        for (int index = 1; index < b.length; ++index) {
            this.digits[index - 1] = b[index];
        }
        return 1 + this.digits.length;
    }

    @Override
    public byte[] encode() throws ParameterException {
        byte[] b = new byte[this.digits.length + 1];
        b[0] = (byte)(b[0] | this.typeOfDigits & 0x1F);
        b[0] = (byte)(b[0] | (this.encodingScheme & 7) << 5);
        for (int index = 1; index < b.length; ++index) {
            b[index] = this.digits[index - 1];
        }
        return b;
    }

    public int getEncodingScheme() {
        return this.encodingScheme;
    }

    public void setEncodingScheme(int encodingScheme) {
        this.encodingScheme = encodingScheme;
    }

    public int getTypeOfDigits() {
        return this.typeOfDigits;
    }

    public void setTypeOfDigits(int typeOfDigits) {
        this.typeOfDigits = typeOfDigits;
    }

    public byte[] getEncodedDigits() {
        return this.digits;
    }

    public void setEncodedDigits(byte[] digits) {
        if (digits == null) {
            throw new IllegalArgumentException("Digits must not be null");
        }
        this.digits = digits;
    }

    public int getCode() {
        return 193;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GenericDigits [encodingScheme=");
        sb.append(this.encodingScheme);
        sb.append(", typeOfDigits=");
        sb.append(this.typeOfDigits);
        if (this.digits != null) {
            sb.append(", encodedDigits=[");
            sb.append(DatatypeConverter.printHexBinary((byte[])this.digits));
            sb.append("]");
            try {
                String s = this.getDecodedDigits();
                sb.append(", decodedDigits=[");
                sb.append(s);
                sb.append("]");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        sb.append("]");
        return sb.toString();
    }

    static /* synthetic */ byte[] access$202(GenericDigitsImpl x0, byte[] x1) {
        x0.digits = x1;
        return x1;
    }
}

