/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractNumber;
import org.mobicents.protocols.ss7.isup.message.parameter.GVNSUserGroup;

public class GVNSUserGroupImpl
extends AbstractNumber
implements GVNSUserGroup {
    private int gugLengthIndicator;

    public GVNSUserGroupImpl() {
    }

    public GVNSUserGroupImpl(byte[] representation) throws ParameterException {
        super(representation);
    }

    public GVNSUserGroupImpl(ByteArrayInputStream bis) throws ParameterException {
        super(bis);
    }

    public GVNSUserGroupImpl(String address) {
        super(address);
    }

    @Override
    public int decode(byte[] b) throws ParameterException {
        return super.decode(b);
    }

    @Override
    public byte[] encode() throws ParameterException {
        return super.encode();
    }

    @Override
    public int decodeHeader(ByteArrayInputStream bis) throws IllegalArgumentException {
        int b = bis.read() & 0xFF;
        this.oddFlag = (b & 0x80) >> 7;
        this.gugLengthIndicator = b & 0xF;
        return 1;
    }

    @Override
    public int encodeHeader(ByteArrayOutputStream bos) {
        boolean isOdd;
        int b = 0;
        boolean bl = isOdd = this.oddFlag == 1;
        if (isOdd) {
            b |= 0x80;
        }
        bos.write(b |= this.gugLengthIndicator & 0xF);
        return 1;
    }

    @Override
    public int decodeBody(ByteArrayInputStream bis) throws IllegalArgumentException {
        return 0;
    }

    @Override
    public int encodeBody(ByteArrayOutputStream bos) {
        return 0;
    }

    public int getGugLengthIndicator() {
        return this.gugLengthIndicator;
    }

    @Override
    public int decodeDigits(ByteArrayInputStream bis) throws IllegalArgumentException, ParameterException {
        return super.decodeDigits(bis, this.gugLengthIndicator);
    }

    @Override
    public void setAddress(String address) {
        super.setAddress(address);
        int l = this.address.length();
        this.gugLengthIndicator = l / 2 + l % 2;
        if (this.gugLengthIndicator > 8) {
            throw new IllegalArgumentException("Maximum octets for this parameter in digits part is 8.");
        }
    }

    public int getCode() {
        return 0;
    }
}

